// ---------------------------------------------------------------------------
// - Library.hpp                                                             -
// - standard object library - dynamic library class definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_LIBRARY_HPP
#define  ALEPH_LIBRARY_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {

  /// The Library class is used to manipulate system shared libraries. A 
  /// library instance is created by name, and an attempt to open the shared
  /// library is done. Once the library is open, it is possible to invoke a 
  /// a system procedure with the apply method.
  /// @author amaury darsch

  class Library : public Object {
  private:
    /// the library name
    String d_name;
    /// the shared library handle
    void* p_handle;

  public:
    /// open a shared library by name
    /// @param name the library name
    Library (const String& name);

    /// destroy and close this shared library
    ~Library (void);

    /// @return the class name
    String repr (void) const;

    /// @return the library name
    inline String getname (void) const {
      return d_name;
    }

    /// generate a new library object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// evaluate a library member name
    /// @param interp interp the current interpreter
    /// @param nset   the current nameset    
    /// @param name   the name to evaluate
    Object* eval (Interp* interp, Nameset* nset, const String& name);

    /// apply in this library a set of arguments and a method name
    /// @param interp interp the current interpreter
    /// @param nset   the current nameset    
    /// @param name   the name to apply this arguments
    /// @param args   the arguments to apply
    Object* apply (Interp* interp, Nameset* nset, const String& name,
		   Cons* args);
    
  private:
    // make the copy constructor private
    Library (const Library&);
    // make the assignment operator private
    Library& operator = (const Library&);
  };
}

#endif
