// ---------------------------------------------------------------------------
// - System.hpp                                                              -
// - standard object library - system function class definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_SYSTEM_HPP
#define  ALEPH_SYSTEM_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The System class is a collection of static convenient functions. There
  /// purposes is to provide a uniform interface for os dependant features.
  /// @author amaury darsch

  class System {
  public:
    /// @return the option separator
    static char optsep (void);

    /// @return the os name
    static String osname (void);

    /// @return the full version of the aleph system
    static String version (void);

    /// exit unconditionnaly with a status code
    /// @param status the exit status code
    static void exit (int status);

    /// pause for a certain time 
    /// @param time the time to pause in milliseconds
    static void sleep (const long time);

    /// remove a file name extension
    /// @param name the file name
    /// @return a file name without its extension
    static String rmext (const String& name);

    /// Concatenate two name to form a new os path name
    /// @param dir the directory name
    /// @param name the name to concatenate
    /// @return the new path name
    static String join (const String& dir, const String& name);

    /// @return true if the name corresponds to a regular file name
    static bool isfile (const String& name);

    /// @return true if the name corresponds to a directory name
    static bool isdir (const String& name);
 
    /// execute a command in another process
    /// @param cmd the command to execute
    /// @return true on success, false otherwise
    static bool system (const String& cmd);
  };
}

#endif
