


CLISP-READLINE(3)                               CLISP-READLINE(3)


NNAAMMEE
       readline - get a line from a user with editing

NNOOTTAATTIIOONN
       An  emacs-style  notation  is  used  to denote keystrokes.
       Control keys are denoted by C-_k_e_y, e.g.,  C-n  means  Con-
       trol-N.  Similarly, _m_e_t_a keys are denoted by M-_k_e_y, so M-x
       means Meta-X.  (On keyboards without a _m_e_t_a key, M-_x means
       ESC  _x,  i.e.,  press the Escape key then the _x key.  This
       makes ESC the _m_e_t_a _p_r_e_f_i_x.  The  combination  M-C-_x  means
       ESC-Control-_x,  or press the Escape key then hold the Con-
       trol key while pressing the _x key.)

       Readline commands may be given  numeric  _a_r_g_u_m_e_n_t_s,  which
       normally act as a repeat count.  Sometimes, however, it is
       the sign of the argument that is significant.   Passing  a
       negative  argument  to  a command that acts in the forward
       direction (e.g., kkiillll--lliinnee) causes that command to act  in
       a  backward direction.  Commands whose behavior with argu-
       ments deviates from this are noted.

       When a command is described  as  _k_i_l_l_i_n_g  text,  the  text
       deleted  is saved for possible future retrieval (_y_a_n_k_i_n_g).
       The killed text is  saved  in  a  _k_i_l_l_-_r_i_n_g.   Consecutive
       kills  cause  the  text  to  be accumulated into one unit,
       which can be yanked all at once.  Commands  which  do  not
       kill text separate the chunks of text on the kill-ring.

IINNIITTIIAALLIIZZAATTIIOONN FFIILLEE
       Readline  is customized by putting commands in an initial-
       ization file.  The name of this file  is  taken  from  the
       value of the IINNPPUUTTRRCC variable.  If that variable is unset,
       the default is _~_/_._i_n_p_u_t_r_c.  When a program which uses  the
       readline library starts up, the init file is read, and the
       key bindings and variables are set.  There are only a  few
       basic constructs allowed in the readline init file.  Blank
       lines are ignored.  Lines beginning with a ## are comments.
       Lines  beginning with a $$ indicate conditional constructs.
       Other lines denote key  bindings  and  variable  settings.
       Each  program  using this library may add its own commands
       and bindings.

       For example, placing

              M-Control-u: universal-argument
       or
              C-Meta-u: universal-argument
       into the _~_/_._i_n_p_u_t_r_c would make M-C-u execute the  readline
       command _u_n_i_v_e_r_s_a_l_-_a_r_g_u_m_e_n_t.

       The  following  symbolic  character  names  are recognized
       while processing key bindings: _R_U_B_O_U_T, _D_E_L, _E_S_C, _L_F_D, _N_E_W_-
       _L_I_N_E,  _R_E_T,  _R_E_T_U_R_N,  _S_P_C, _S_P_A_C_E, and _T_A_B.  In addition to
       command names, readline allows  keys  to  be  bound  to  a



GNU                       1994 August 18                        1





CLISP-READLINE(3)                               CLISP-READLINE(3)


       string that is inserted when the key is pressed (a _m_a_c_r_o).


   KKeeyy BBiinnddiinnggss
       The syntax for controlling key bindings in the  _~_/_._i_n_p_u_t_r_c
       file  is  simple.  All that is required is the name of the
       command or the text of a macro and a key sequence to which
       it  should  be  bound. The name may be specified in one of
       two ways: as a symbolic key name, possibly with  _M_e_t_a_-  or
       _C_o_n_t_r_o_l_-  prefixes,  or as a key sequence.  When using the
       form kkeeyynnaammee:_f_u_n_c_t_i_o_n_-_n_a_m_e or _m_a_c_r_o, _k_e_y_n_a_m_e is  the  name
       of a key spelled out in English.  For example:

              Control-u: universal-argument
              Meta-Rubout: backward-kill-word
              Control-o: ">&output"

       In the above example, _C_-_u is bound to the function uunniivveerr--
       ssaall--aarrgguummeenntt,  _M_-_D_E_L  is  bound  to  the  function   bbaacckk--
       wwaarrdd--kkiillll--wwoorrdd,   and  _C_-_o  is  bound  to  run  the  macro
       expressed on the right hand side (that is, to  insert  the
       text _>_&_o_u_t_p_u_t into the line).

       In  the second form, ""kkeeyysseeqq"":_f_u_n_c_t_i_o_n_-_n_a_m_e or _m_a_c_r_o, kkeeyy--
       sseeqq differs from kkeeyynnaammee above in that strings denoting an
       entire  key  sequence  may  be  specified  by  placing the
       sequence within double quotes.  Some GNU Emacs  style  key
       escapes can be used, as in the following example.

              "\C-u": universal-argument
              "\C-x\C-r": re-read-init-file
              "\e[11~": "Function Key 1"

       In  this  example, _C_-_u is again bound to the function uunnii--
       vveerrssaall--aarrgguummeenntt.   _C_-_x  _C_-_r  is  bound  to  the   function
       rree--rreeaadd--iinniitt--ffiillee,  and _E_S_C _[ _1 _1 _~ is bound to insert the
       text FFuunnccttiioonn KKeeyy 11.  The full set of escape sequences is

              \\CC--    control prefix

              \\MM--    meta prefix

              \\ee     an escape character

              \\\\     backslash

              \\""     literal "

              \\''     literal '

       When entering the text of a macro, single or double quotes
       should  be  used to indicate a macro definition.  Unquoted
       text is assumed to be a  function  name.   Backslash  will
       quote  any character in the macro text, including " and '.



GNU                       1994 August 18                        2





CLISP-READLINE(3)                               CLISP-READLINE(3)


       BBaasshh allows the current readline key bindings to  be  dis-
       played  or  modified  with  the bbiinndd builtin command.  The
       editing mode may be switched  during  interactive  use  by
       using  the  --oo  option  to the sseett builtin command.  Other
       programs using this library  provide  similar  mechanisms.
       The  _i_n_p_u_t_r_c  file  may be edited and re-read if a program
       does not provide any other means to incorporate new  bind-
       ings.

   VVaarriiaabblleess
       Readline  has  variables  that can be used to further cus-
       tomize its behavior.  A variable may be set in the _i_n_p_u_t_r_c
       file with a statement of the form

              sseett _v_a_r_i_a_b_l_e_-_n_a_m_e _v_a_l_u_e

       Except where noted, readline variables can take the values
       OOnn or OOffff.  The variables and their default values are:

       hhoorriizzoonnttaall--ssccrroollll--mmooddee ((OOffff))
              When set to OOnn, makes readline use  a  single  line
              for  display, scrolling the input horizontally on a
              single screen line when it becomes longer than  the
              screen width rather than wrapping to a new line.
       eeddiittiinngg--mmooddee ((eemmaaccss))
              Controls  whether readline begins with a set of key
              bindings similar to _e_m_a_c_s or _v_i.  eeddiittiinngg--mmooddee  can
              be set to either eemmaaccss or vvii.
       mmaarrkk--mmooddiiffiieedd--lliinneess ((OOffff))
              If set to OOnn, history lines that have been modified
              are displayed with a preceding asterisk (**).
       bbeellll--ssttyyllee ((aauuddiibbllee))
              Controls what happens when readline wants  to  ring
              the  terminal bell.  If set to nnoonnee, readline never
              rings the bell.  If set to vviissiibbllee, readline uses a
              visible  bell if one is available.  If set to aauuddii--
              bbllee, readline attempts to ring the terminal's bell.
       ccoommmmeenntt--bbeeggiinn ((````##''''))
              The  string  that  is  inserted in vvii mode when the
              vvii--ccoommmmeenntt command is executed.
       mmeettaa--ffllaagg ((OOffff))
              If set to OOnn, readline will enable eight-bit  input
              (that  is,  it will not strip the high bit from the
              characters it reads), regardless of what the termi-
              nal claims it can support.
       bblliinnkk--mmaattcchhiinngg--ppaarreenn ((OOnn))
              If set to OOnn, readline will display the correspond-
              ing opening parenthesis when a closing  parenthesis
              is typed.
       ccoonnvveerrtt--mmeettaa ((OOnn))
              If set to OOnn, readline will convert characters with
              the eighth bit set to  an  ASCII  key  sequence  by
              stripping  the  eighth bit and prepending an escape
              character (in effect,  using  escape  as  the  _m_e_t_a



GNU                       1994 August 18                        3





CLISP-READLINE(3)                               CLISP-READLINE(3)


              _p_r_e_f_i_x).
       oouuttppuutt--mmeettaa ((OOffff))
              If set to OOnn, readline will display characters with
              the eighth bit set directly rather than as a  meta-
              prefixed escape sequence.
       ccoommpplleettiioonn--qquueerryy--iitteemmss ((110000))
              This  determines  when  the  user  is queried about
              viewing the number of possible  completions  gener-
              ated  by  the ppoossssiibbllee--ccoommpplleettiioonnss command.  It may
              be set to any integer value greater than  or  equal
              to  zero.  If the number of possible completions is
              greater than or equal to the value  of  this  vari-
              able, the user is asked whether or not he wishes to
              view them; otherwise they are simply listed on  the
              terminal.
       kkeeyymmaapp ((eemmaaccss))
              Set  the current readline keymap.  The set of legal
              keymap names is _e_m_a_c_s_, _e_m_a_c_s_-_s_t_a_n_d_a_r_d_,  _e_m_a_c_s_-_m_e_t_a_,
              _e_m_a_c_s_-_c_t_l_x_, _v_i_, _v_i_-_m_o_v_e_, _v_i_-_c_o_m_m_a_n_d, and _v_i_-_i_n_s_e_r_t.
              _v_i is equivalent to _v_i_-_c_o_m_m_a_n_d; _e_m_a_c_s is equivalent
              to _e_m_a_c_s_-_s_t_a_n_d_a_r_d.  The default value is _e_m_a_c_s; the
              value of  eeddiittiinngg--mmooddee  also  affects  the  default
              keymap.
       sshhooww--aallll--iiff--aammbbiigguuoouuss ((OOffff))
              This  alters the default behavior of the completion
              functions.  If set to oonn,  words  which  have  more
              than  one  possible completion cause the matches to
              be listed immediately instead of ringing the  bell.
       eexxppaanndd--ttiillddee ((OOffff))
              If  set  to  oonn,  tilde expansion is performed when
              readline attempts word completion.

   CCoonnddiittiioonnaall CCoonnssttrruuccttss
       Readline implements a facility similar in  spirit  to  the
       conditional  compilation  features  of  the C preprocessor
       which allows key bindings and variable settings to be per-
       formed  as  the  result  of tests.  There are three parser
       directives used.

       $$iiff    The $$iiff construct allows bindings to be made  based
              on  the  editing  mode, the terminal being used, or
              the application using readline.  The  text  of  the
              test  extends to the end of the line; no characters
              are required to isolate it.

              mmooddee   The mmooddee== form of the $$iiff directive is  used
                     to  test  whether readline is in emacs or vi
                     mode.  This may be used in conjunction  with
                     the sseett kkeeyymmaapp command, for instance, to set
                     bindings in the  _e_m_a_c_s_-_s_t_a_n_d_a_r_d  and  _e_m_a_c_s_-
                     _c_t_l_x  keymaps  only  if readline is starting
                     out in emacs mode.

              tteerrmm   The  tteerrmm==  form  may  be  used  to  include



GNU                       1994 August 18                        4





CLISP-READLINE(3)                               CLISP-READLINE(3)


                     terminal-specific  key  bindings, perhaps to
                     bind the key sequences output by the  termi-
                     nal's  function keys.  The word on the right
                     side of the == is  tested  against  the  full
                     name  of the terminal and the portion of the
                     terminal name  before  the  first  --.   This
                     allows  _s_u_n  to  match both _s_u_n and _s_u_n_-_c_m_d,
                     for instance.

              aapppplliiccaattiioonn
                     The aapppplliiccaattiioonn construct is used to include
                     application-specific settings.  Each program
                     using the readline library sets the _a_p_p_l_i_c_a_-
                     _t_i_o_n  _n_a_m_e,  and  an initialization file can
                     test for a particular value.  This could  be
                     used to bind key sequences to functions use-
                     ful for a specific program.   For  instance,
                     the  following  command  adds a key sequence
                     that quotes the current or previous word  in
                     Bash:
                     $$iiff bash
                     # Quote the current or previous word
                     "\C-xq": "\eb\"\ef\""
                     $$eennddiiff

       $$eennddiiff This  command,  as you saw in the previous example,
              terminates an $$iiff command.

       $$eellssee  Commands in this branch of the  $$iiff  directive  are
              executed if the test fails.

EEDDIITTIINNGG CCOOMMMMAANNDDSS
       The  following  is a list of the names of the commands and
       the default key sequences to which they are bound.

   CCoommmmaannddss ffoorr MMoovviinngg
       bbeeggiinnnniinngg--ooff--lliinnee ((CC--aa))
              Move to the start of the current line.
       eenndd--ooff--lliinnee ((CC--ee))
              Move to the end of the line.
       ffoorrwwaarrdd--cchhaarr ((CC--ff))
              Move forward a character.
       bbaacckkwwaarrdd--cchhaarr ((CC--bb))
              Move back a character.
       ffoorrwwaarrdd--wwoorrdd ((MM--ff))
              Move forward to the end of the  next  word.   Words
              are  composed  of  alphanumeric characters (letters
              and digits).
       bbaacckkwwaarrdd--wwoorrdd ((MM--bb))
              Move back to the start of this,  or  the  previous,
              word.   Words  are composed of alphanumeric charac-
              ters (letters and digits).
       cclleeaarr--ssccrreeeenn ((CC--ll))
              Clear the screen leaving the current  line  at  the



GNU                       1994 August 18                        5





CLISP-READLINE(3)                               CLISP-READLINE(3)


              top  of  the screen.  With an argument, refresh the
              current line without clearing the screen.
       rreeddrraaww--ccuurrrreenntt--lliinnee
              Refresh the current  line.   By  default,  this  is
              unbound.

   CCoommmmaannddss ffoorr MMaanniippuullaattiinngg tthhee HHiissttoorryy
       aacccceepptt--lliinnee ((NNeewwlliinnee,, RReettuurrnn))
              Accept  the line regardless of where the cursor is.
              If this line is non-empty, add it  to  the  history
              list.  If the line is a modified history line, then
              restore the history line to its original state.
       pprreevviioouuss--hhiissttoorryy ((CC--pp))
              Fetch the previous command from the  history  list,
              moving back in the list.
       nneexxtt--hhiissttoorryy ((CC--nn))
              Fetch  the next command from the history list, mov-
              ing forward in the list.
       bbeeggiinnnniinngg--ooff--hhiissttoorryy ((MM--<<))
              Move to the first line in the history.
       eenndd--ooff--hhiissttoorryy ((MM-->>))
              Move to the end of the  input  history,  i.e.,  the
              line currently being entered.
       rreevveerrssee--sseeaarrcchh--hhiissttoorryy ((CC--rr))
              Search  backward  starting  at the current line and
              moving `up' through the history as necessary.  This
              is an incremental search.
       ffoorrwwaarrdd--sseeaarrcchh--hhiissttoorryy ((CC--ss))
              Search  forward  starting  at  the current line and
              moving `down' through  the  history  as  necessary.
              This is an incremental search.
       nnoonn--iinnccrreemmeennttaall--rreevveerrssee--sseeaarrcchh--hhiissttoorryy ((MM--pp))
              Search backward through the history starting at the
              current line using a non-incremental search  for  a
              string supplied by the user.
       nnoonn--iinnccrreemmeennttaall--ffoorrwwaarrdd--sseeaarrcchh--hhiissttoorryy ((MM--nn))
              Search   forward   through   the  history  using  a
              non-incremental search for a string supplied by the
              user.
       hhiissttoorryy--sseeaarrcchh--ffoorrwwaarrdd
              Search  forward  through the history for the string
              of characters between the start of the current line
              and  the  current point.  This is a non-incremental
              search.  By default, this command is unbound.
       hhiissttoorryy--sseeaarrcchh--bbaacckkwwaarrdd
              Search backward through the history for the  string
              of characters between the start of the current line
              and the current point.  This is  a  non-incremental
              search.  By default, this command is unbound.
       yyaannkk--nntthh--aarrgg ((MM--CC--yy))
              Insert  the  first argument to the previous command
              (usually the second word on the previous  line)  at
              point (the current cursor position).  With an argu-
              ment _n, insert  the  _nth  word  from  the  previous



GNU                       1994 August 18                        6





CLISP-READLINE(3)                               CLISP-READLINE(3)


              command  (the  words  in the previous command begin
              with word 0).  A negative argument inserts the  _nth
              word from the end of the previous command.

   CCoommmmaannddss ffoorr CChhaannggiinngg TTeexxtt
       ddeelleettee--cchhaarr ((CC--dd))
              Delete the character under the cursor.  If point is
              at the beginning of the line, there are no  charac-
              ters  in the line, and the last character typed was
              not CC--dd, then return EEOOFF.
       bbaacckkwwaarrdd--ddeelleettee--cchhaarr ((RRuubboouutt))
              Delete the character behind the cursor.  When given
              a  numeric  argument,  save the deleted text on the
              kill-ring.
       qquuootteedd--iinnsseerrtt ((CC--qq,, CC--vv))
              Add the next character that you type  to  the  line
              verbatim.   This  is  how to insert characters like
              CC--qq, for example.
       ttaabb--iinnsseerrtt ((MM--TTAABB))
              Insert a tab character.
       sseellff--iinnsseerrtt ((aa,, bb,, AA,, 11,, !!,, ......))
              Insert the character typed.
       ttrraannssppoossee--cchhaarrss ((CC--tt))
              Drag the character before point  forward  over  the
              character  at  point.  Point moves forward as well.
              If point is at the end of the line, then  transpose
              the  two  characters  before point.  Negative argu-
              ments don't work.
       ttrraannssppoossee--wwoorrddss ((MM--tt))
              Drag the word behind the cursor past  the  word  in
              front  of  the  cursor  moving the cursor over that
              word as well.
       uuppccaassee--wwoorrdd ((MM--uu))
              Uppercase the current (or following) word.  With  a
              negative argument, do the previous word, but do not
              move point.
       ddoowwnnccaassee--wwoorrdd ((MM--ll))
              Lowercase the current (or following) word.  With  a
              negative argument, do the previous word, but do not
              move point.
       ccaappiittaalliizzee--wwoorrdd ((MM--cc))
              Capitalize the current (or following) word.  With a
              negative argument, do the previous word, but do not
              move point.

   KKiilllliinngg aanndd YYaannkkiinngg
       kkiillll--lliinnee ((CC--kk))
              Kill the text from the current cursor  position  to
              the end of the line.
       bbaacckkwwaarrdd--kkiillll--lliinnee ((CC--xx RRuubboouutt))
              Kill backward to the beginning of the line.
       uunniixx--lliinnee--ddiissccaarrdd ((CC--uu))
              Kill  backward  from  point to the beginning of the
              line.



GNU                       1994 August 18                        7





CLISP-READLINE(3)                               CLISP-READLINE(3)


       kkiillll--wwhhoollee--lliinnee
              Kill all characters on the current line, no  matter
              where  the cursor is.  By default, this is unbound.
       kkiillll--wwoorrdd ((MM--dd))
              Kill from the cursor to  the  end  of  the  current
              word,  or  if between words, to the end of the next
              word.  Word boundaries are the same as  those  used
              by ffoorrwwaarrdd--wwoorrdd.
       bbaacckkwwaarrdd--kkiillll--wwoorrdd ((MM--RRuubboouutt))
              Kill  the  word behind the cursor.  Word boundaries
              are the same as those used by bbaacckkwwaarrdd--wwoorrdd.
       uunniixx--wwoorrdd--rruubboouutt ((CC--ww))
              Kill the word behind the cursor, using white  space
              as  a  word boundary.  The word boundaries are dif-
              ferent from bbaacckkwwaarrdd--kkiillll--wwoorrdd.
       ddeelleettee--hhoorriizzoonnttaall--ssppaaccee
              Delete  all  spaces  and  tabs  around  point.   By
              default, this is unbound.
       yyaannkk ((CC--yy))
              Yank  the  top  of the kill ring into the buffer at
              the cursor.
       yyaannkk--ppoopp ((MM--yy))
              Rotate the kill-ring, and yank the new  top.   Only
              works following yyaannkk or yyaannkk--ppoopp.

   NNuummeerriicc AArrgguummeennttss
       ddiiggiitt--aarrgguummeenntt ((MM--00,, MM--11,, ......,, MM----))
              Add  this  digit to the argument already accumulat-
              ing, or start a new argument.  M-- starts  a  nega-
              tive argument.
       uunniivveerrssaall--aarrgguummeenntt
              Each  time  this is executed, the argument count is
              multiplied by four.  The  argument  count  is  ini-
              tially  one,  so  executing this function the first
              time makes the argument count  four.   By  default,
              this is not bound to a key.

   CCoommpplleettiinngg
       ccoommpplleettee ((TTAABB))
              Attempt  to  perform  completion on the text before
              point.  The actual completion performed is applica-
              tion-specific.   CClliisspp, for instance, attempts com-
              pletion of symbol names, of function names (if  the
              text  is  prefixed  by (( or ##'') or of filenames (if
              the text is prefixed by ##"").  BBaasshh,  on  the  other
              hand,  attempts  completion  treating the text as a
              variable (if the text begins with $$), username  (if
              the  text  begins  with  ~~),  hostname (if the text
              begins with @@), or command (including  aliases  and
              functions)  in  turn.   If none of these produces a
              match,  filename  completion  is  attempted.   GGddbb,
              finally, allows completion of program functions and
              variables, and only  attempts  filename  completion
              under certain circumstances.



GNU                       1994 August 18                        8





CLISP-READLINE(3)                               CLISP-READLINE(3)


       ppoossssiibbllee--ccoommpplleettiioonnss ((MM--??))
              List  the  possible  completions of the text before
              point.
       iinnsseerrtt--ccoommpplleettiioonnss
              Insert all completions of  the  text  before  point
              that  would have been generated by ppoossssiibbllee--ccoommppllee--
              ttiioonnss.  By default, this is not bound to a key.

   KKeeyybbooaarrdd MMaaccrrooss
       ssttaarrtt--kkbbdd--mmaaccrroo ((CC--xx (())
              Begin saving the characters typed into the  current
              keyboard macro.
       eenndd--kkbbdd--mmaaccrroo ((CC--xx ))))
              Stop  saving  the characters typed into the current
              keyboard macro and save the definition.
       ccaallll--llaasstt--kkbbdd--mmaaccrroo ((CC--xx ee))
              Re-execute the last keyboard macro defined, by mak-
              ing  the characters in the macro appear as if typed
              at the keyboard.

   MMiisscceellllaanneeoouuss
       rree--rreeaadd--iinniitt--ffiillee ((CC--xx CC--rr))
              Read in the contents of your init file, and  incor-
              porate  any  bindings or variable assignments found
              there.
       aabboorrtt ((CC--gg))
              Abort the current editing command and ring the ter-
              minal's   bell   (subject   to   the   setting   of
              bbeellll--ssttyyllee).
       ddoo--uuppppeerrccaassee--vveerrssiioonn ((MM--aa,, MM--bb,, ......))
              Run the command that is bound to the  corresponding
              uppercase character.
       pprreeffiixx--mmeettaa ((EESSCC))
              Metafy  the next character typed.  EESSCC ff is equiva-
              lent to MMeettaa--ff.
       uunnddoo ((CC--__,, CC--xx CC--uu))
              Incremental undo, separately  remembered  for  each
              line.
       rreevveerrtt--lliinnee ((MM--rr))
              Undo  all  changes made to this line.  This is like
              typing the uunnddoo command enough times to return  the
              line to its initial state.
       ttiillddee--eexxppaanndd ((MM--~~))
              Perform tilde expansion on the current word.
       dduummpp--ffuunnccttiioonnss
              Print  all  of the functions and their key bindings
              to the readline output stream.  If a numeric  argu-
              ment is supplied, the output is formatted in such a
              way that it can be made part of an _i_n_p_u_t_r_c file.
       eemmaaccss--eeddiittiinngg--mmooddee ((CC--ee))
              When in vvii editing mode, this causes  a  switch  to
              eemmaaccss editing mode.
       vvii--eeddiittiinngg--mmooddee ((MM--CC--jj))
              When in eemmaaccss editing mode, this causes a switch to



GNU                       1994 August 18                        9





CLISP-READLINE(3)                               CLISP-READLINE(3)


              vvii editing mode.

DDEEFFAAUULLTT KKEEYY BBIINNDDIINNGGSS
       The following is a list of the default emacs and vi  bind-
       ings.   Characters  with  the  8th  bit set are written as
       M-<character>, and are referred to as _m_e_t_a_f_i_e_d characters.
       The  printable  ASCII characters not mentioned in the list
       of emacs standard bindings are bound  to  the  _s_e_l_f_-_i_n_s_e_r_t
       function,  which just inserts the given character into the
       input line.  In vi  insertion  mode,  all  characters  not
       specifically  mentioned are bound to _s_e_l_f_-_i_n_s_e_r_t.  Charac-
       ters assigned to signal generation by _s_t_t_y(1) or the  ter-
       minal  driver,  such  as C-Z or C-C, retain that function.
       Upper and lower case _m_e_t_a_f_i_e_d characters are bound to  the
       same  function in the emacs mode meta keymap.  The remain-
       ing characters are unbound, which causes readline to  ring
       the  bell  (subject to the setting of the bbeellll--ssttyyllee vari-
       able).

   EEmmaaccss MMooddee
             Emacs Standard bindings

             "C-A"                    ->  beginning-of-line
             "C-B"                    ->  backward-char
             "C-D"                    ->  delete-char
             "C-E"                    ->  end-of-line
             "C-F"                    ->  forward-char
             "C-G"                    ->  abort
             "C-H"                    ->  backward-delete-char
             "C-I"                    ->  complete
             "C-J"                    ->  accept-line
             "C-K"                    ->  kill-line
             "C-L"                    ->  clear-screen
             "C-M"                    ->  accept-line
             "C-N"                    ->  next-history
             "C-P"                    ->  previous-history
             "C-Q"                    ->  quoted-insert
             "C-R"                    ->  reverse-search-history
             "C-S"                    ->  forward-search-history
             "C-T"                    ->  transpose-chars
             "C-U"                    ->  unix-line-discard
             "C-V"                    ->  quoted-insert
             "C-W"                    ->  unix-word-rubout
             "C-Y"                    ->  yank
             "C-_"                    ->  undo
             " " to "/"               ->  self-insert
             "0"  to "9"              ->  self-insert
             ":"  to "~"              ->  self-insert
             "C-?"                    ->  backward-delete-char

             Emacs Meta bindings

             "M-C-H"                  ->  backward-kill-word
             "M-C-I"                  ->  tab-insert



GNU                       1994 August 18                       10





CLISP-READLINE(3)                               CLISP-READLINE(3)


             "M-C-J"                  ->  vi-editing-mode
             "M-C-M"                  ->  vi-editing-mode
             "M-C-R"                  ->  revert-line
             "M-C-Y"                  ->  yank-nth-arg
             "M-C-["                  ->  complete
             "M-&"                    ->  tilde-expand
             "M--"                    ->  digit-argument
             "M-0"                    ->  digit-argument
             "M-1"                    ->  digit-argument
             "M-2"                    ->  digit-argument
             "M-3"                    ->  digit-argument
             "M-4"                    ->  digit-argument
             "M-5"                    ->  digit-argument
             "M-6"                    ->  digit-argument
             "M-7"                    ->  digit-argument
             "M-8"                    ->  digit-argument
             "M-9"                    ->  digit-argument
             "M-<"                    ->  beginning-of-history
             "M->"                    ->  end-of-history
             "M-?"                    ->  possible-completions
             "M-B"                    ->  backward-word
             "M-C"                    ->  capitalize-word
             "M-D"                    ->  kill-word
             "M-F"                    ->  forward-word
             "M-L"                    ->  downcase-word
             "M-N"                    ->  non-incremental-forward-search-history
             "M-O"                    ->  arrow-key-prefix
             "M-P"                    ->  non-incremental-reverse-search-history
             "M-R"                    ->  revert-line
             "M-T"                    ->  transpose-words
             "M-U"                    ->  upcase-word
             "M-Y"                    ->  yank-pop
             "M-C-Y"                  ->  yank-nth-arg
             "M-C-?"                  ->  backward-delete-word

             Emacs Control-X bindings

             "C-XC-G"                 ->  abort
             "C-XC-R"                 ->  re-read-init-file
             "C-XC-U"                 ->  undo
             "C-X("                   ->  start-kbd-macro
             "C-X)"                   ->  end-kbd-macro
             "C-Xe"                   ->  call-last-kbd-macro
             "C-XC-?"                 ->  backward-kill-line


   VVII MMooddee bbiinnddiinnggss
             VI Insert Mode functions

             "C-D"                    ->  vi-eof-maybe
             "C-H"                    ->  backward-delete-char
             "C-I"                    ->  complete
             "C-J"                    ->  accept-line
             "C-K"                    ->  kill-line



GNU                       1994 August 18                       11





CLISP-READLINE(3)                               CLISP-READLINE(3)


             "C-L"                    ->  clear-screen
             "C-M"                    ->  accept-line
             "C-N"                    ->  next-history
             "C-P"                    ->  previous-history
             "C-Q"                    ->  quoted-insert
             "C-R"                    ->  reverse-search-history
             "C-S"                    ->  forward-search-history
             "C-T"                    ->  transpose-chars
             "C-U"                    ->  unix-line-discard
             "C-V"                    ->  quoted-insert
             "C-W"                    ->  unix-word-rubout
             "C-Y"                    ->  yank
             "C-["                    ->  vi-movement-mode
             " " to "~"               ->  self-insert
             "C-?"                    ->  backward-delete-char

             VI Command Mode functions

             "C-D"                    ->  vi-eof-maybe
             "C-E"                    ->  emacs-editing-mode
             "C-G"                    ->  abort
             "C-H"                    ->  backward-char
             "C-J"                    ->  accept-line
             "C-K"                    ->  kill-line
             "C-L"                    ->  clear-screen
             "C-M"                    ->  accept-line
             "C-N"                    ->  next-history
             "C-P"                    ->  previous-history
             "C-Q"                    ->  quoted-insert
             "C-R"                    ->  reverse-search-history
             "C-S"                    ->  forward-search-history
             "C-T"                    ->  transpose-chars
             "C-U"                    ->  unix-line-discard
             "C-V"                    ->  quoted-insert
             "C-W"                    ->  unix-word-rubout
             "C-Y"                    ->  yank
             "C-["                    ->  abort
             " "                      ->  forward-char
             "#"                      ->  vi-comment
             "$"                      ->  end-of-line
             "%"                      ->  vi-match
             "&"                      ->  vi-tilde-expand
             "*"                      ->  vi-complete
             "+"                      ->  down-history
             ","                      ->  vi-char-search
             "-"                      ->  previous-history
             "."                      ->  vi-redo
             "/"                      ->  vi-search
             "0"                      ->  beginning-of-line
             "1" to "9"               ->  vi-arg-digit
             ";"                      ->  vi-char-search
             "="                      ->  vi-complete
             "?"                      ->  vi-search
             "@"                      ->  is undefined



GNU                       1994 August 18                       12





CLISP-READLINE(3)                               CLISP-READLINE(3)


             "A"                      ->  vi-append-eol
             "B"                      ->  vi-prev-word
             "C"                      ->  vi-change-to
             "D"                      ->  vi-delete-to
             "E"                      ->  vi-end-word
             "F"                      ->  vi-char-search
             "I"                      ->  vi-insert-beg
             "N"                      ->  vi-search-again
             "P"                      ->  vi-put
             "R"                      ->  vi-replace
             "S"                      ->  vi-subst
             "T"                      ->  vi-char-search
             "U"                      ->  revert-line
             "W"                      ->  vi-next-word
             "X"                      ->  backward-delete-char
             "Y"                      ->  vi-yank-to
             "\"                      ->  vi-complete
             "^"                      ->  vi-first-print
             "_"                      ->  vi-yank-arg
             "a"                      ->  vi-append-mode
             "b"                      ->  vi-prev-word
             "c"                      ->  vi-change-to
             "d"                      ->  vi-delete-to
             "e"                      ->  vi-end-word
             "f"                      ->  vi-char-search
             "h"                      ->  backward-char
             "i"                      ->  vi-insertion-mode
             "j"                      ->  next-history
             "k"                      ->  prev-history
             "l"                      ->  forward-char
             "n"                      ->  vi-search-again
             "r"                      ->  vi-change-char
             "s"                      ->  vi-subst
             "t"                      ->  vi-char-search
             "u"                      ->  undo
             "w"                      ->  vi-next-word
             "x"                      ->  vi-delete
             "y"                      ->  vi-yank-to
             "|"                      ->  vi-column
             "~"                      ->  vi-change-case

SSEEEE AALLSSOO
       _T_h_e _G_n_u _R_e_a_d_l_i_n_e _L_i_b_r_a_r_y, Brian Fox
       _T_h_e _G_n_u _H_i_s_t_o_r_y _L_i_b_r_a_r_y, Brian Fox
       _b_a_s_h(1)

FFIILLEESS
       _~_/_._i_n_p_u_t_r_c
              Individual rreeaaddlliinnee initialization file

AAUUTTHHOORRSS
              Brian  Fox,  Free  Software   Foundation   (primary
              author)
              bfox@ai.MIT.Edu



GNU                       1994 August 18                       13





CLISP-READLINE(3)                               CLISP-READLINE(3)


              Chet Ramey, Case Western Reserve University
              chet@ins.CWRU.Edu

              Bruno Haible
              haible@ma2s2.mathematik.uni-karlsruhe.de

BBUUGG RREEPPOORRTTSS
       If  you find a bug in rreeaaddlliinnee,, you should report it. Send
       mail to _h_a_i_b_l_e_@_m_a_2_s_2_._m_a_t_h_e_m_a_t_i_k_._u_n_i_-_k_a_r_l_s_r_u_h_e_._d_e.

BBUUGGSS
       It's too big and too slow.













































GNU                       1994 August 18                       14


