// kForth.cpp
//
// The kForth environment
//
// Copyright (c) 1998--1999 Krishna Myneni, Creative Consulting for
//   Research and Education
// 
// This software is provided under the terms of the GNU General Public License.
//
//
// Usage from console prompt:
//
//      kforth name[.4th] [-D]
//
char* Rls_Date = "7-17-1999";

#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <vector>
#include "fbc.h"
#include "ForthCompiler.h"
#include "ForthVM.h"

extern vector<DictionaryEntry> Dictionary;
extern char* C_ErrorMessages[];

extern "C" int* JumpTable;

int debug = 0;

void main(int argc, char *argv[])
{
    char name[256], InFileName[256], OutFileName[256], *cp, ch;
    char s[256];
    istrstream* pSS = NULL;
    char* prompt = " ok\n";
    vector<byte> op;
    int nWords, i, j, ec;

    cout << "\nkForth v 1.0";
    cout << "\nRls. " << Rls_Date;
    cout << "\nCopyright (c) 1998--1999 Krishna Myneni";
    cout << "\nCreative Consulting for Research and Education";
    cout << "\nProvided under the GNU General Public License.\n\n";


    nWords = OpenForth();

    i = 1;

    while (i < argc)
    {
	if (strstr(argv[i], "-D"))
	{
	   debug = -1;
	}
	else
	{
		strcpy (s, "include ");
        	strcat (s, argv[i]);
		pSS = new istrstream (s);
	}
	++i;
    }

    if (debug) cout << '\n' << nWords << " words defined.\n";

    int* sp;
    byte* tp;
    int line_num;

    if (debug) cout << "Jump Table address is " << JumpTable;
    cout << "\nReady!\n";

//----------------  the interpreter main loop

    while (1)
    {

        // Obtain commands and execute

        do
        {
	    if (! pSS)
	    {
            	cin.getline(s, 255);
            	pSS = new istrstream (s);
	    }

            ec = ForthCompiler (&op, *pSS, cout, &line_num);
	    delete pSS;
	    pSS = NULL;

        } while (ec == E_C_ENDOFSTREAM) ;   // test for premature end of input
                                            //   such as a word definition
                                            //   that spans multiple lines

        if ( ec == E_C_UNKNOWNWORD)
	{
	   if (strcmp(s, "BYE") == 0 || strcmp(s, "bye") == 0) break;
	}

        if (ec)
        {
	    if (ec < MAX_ERR_MESSAGES)
	      cout << "Line " << line_num << ": " << C_ErrorMessages[ec] << '\n';

            if (debug)
	    {
		cout << "\nGenerated " << op.size() << " opcodes.\n";
            	OutputForthByteCode (&op, cout);
	    }
        }
        else
        {
            if (debug) OutputForthByteCode (&op, cout);

            if (op.size())
            {
                ec = ForthVM (&op, cin, cout, &sp, &tp);
                if (ec)
                {
		  if (ec != 8)
                    cout << "\nVM Error: " << ec << '\n';
// StackDump(cout);
                }
		else
		  cout << prompt;
            }


        }

        op.erase(op.begin(), op.end());

    }

    CloseForth();
    cout << "\nGoodbye.\n";
}
//---------------------------------------------------------------

