#include "global.h"

/*
 * Range
 */
static VALUE
range_get_adj(self)
	 VALUE self;
{
    GtkWidget *widget = get_widget(self);
    GtkAdjustment *adj = gtk_range_get_adjustment(GTK_RANGE(widget));

    return make_gobject(gAdjustment, GTK_OBJECT(adj));
}

static VALUE
range_set_update_policy(self, policy)
    VALUE self, policy;
{
    gtk_range_set_update_policy(GTK_RANGE(get_widget(self)),
				(GtkUpdateType)NUM2INT(policy));
    return self;
}

static VALUE
range_set_adj(self, adj)
    VALUE self, adj;
{
	if (! NIL_P(adj))
	  gtk_range_set_adjustment(GTK_RANGE(get_widget(self)),
							   GTK_ADJUSTMENT(get_gobject(adj)));

    return self;
}

static VALUE
range_draw_bg(self)
    VALUE self;
{
    gtk_range_draw_background(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_draw_trough(self)
    VALUE self;
{
    gtk_range_draw_trough(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_draw_slider(self)
    VALUE self;
{
    gtk_range_draw_slider(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_draw_step_forw(self)
    VALUE self;
{
    gtk_range_draw_step_forw(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_draw_step_back(self)
    VALUE self;
{
    gtk_range_draw_step_back(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_slider_update(self)
    VALUE self;
{
    gtk_range_slider_update(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_trough_click(self, x, y)
    VALUE self, x, y;
{
    int i;

    i = gtk_range_trough_click(GTK_RANGE(get_widget(self)),
			       NUM2INT(x), NUM2INT(y),
			       0);
    return INT2FIX(i);
}

static VALUE
range_default_hslider_update(self)
    VALUE self;
{
    gtk_range_default_hslider_update(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_default_vslider_update(self)
    VALUE self;
{
    gtk_range_default_vslider_update(GTK_RANGE(get_widget(self)));
    return self;
}

static VALUE
range_default_htrough_click(self, x, y)
    VALUE self, x, y;
{
    int i;

    i = gtk_range_default_htrough_click(GTK_RANGE(get_widget(self)),
					NUM2INT(x), NUM2INT(y),
					0);
    return INT2FIX(i);
}

static VALUE
range_default_vtrough_click(self, x, y, jump_prec)
    VALUE self, x, y, jump_prec;
{
    int i;

    i = gtk_range_default_vtrough_click(GTK_RANGE(get_widget(self)),
					NUM2INT(x), NUM2INT(y),
					0);
    return INT2FIX(i);
}

static VALUE
range_default_hmotion(self, xdelta, ydelta)
    VALUE self, xdelta, ydelta;
{
    gtk_range_default_hmotion(GTK_RANGE(get_widget(self)),
			      NUM2INT(xdelta), NUM2INT(ydelta));
    return self;
}

static VALUE
range_default_vmotion(self, xdelta, ydelta)
    VALUE self, xdelta, ydelta;
{
    gtk_range_default_vmotion(GTK_RANGE(get_widget(self)),
			      NUM2INT(xdelta), NUM2INT(ydelta));
    return self;
}

void Init_gtk_range()
{
  gRange = rb_define_class_under(mGtk, "Range", gWidget);

  rb_define_method(gRange, "get_adjustment", range_get_adj, 0);
  rb_define_method(gRange, "set_update_policy", range_set_update_policy, 1);
  rb_define_method(gRange, "set_adjustment", range_set_adj, 1);
  rb_define_method(gRange, "draw_background", range_draw_bg, 0);
  rb_define_method(gRange, "draw_trough", range_draw_trough, 0);
  rb_define_method(gRange, "draw_slider", range_draw_slider, 0);
  rb_define_method(gRange, "draw_step_forw", range_draw_step_forw, 0);
  rb_define_method(gRange, "draw_step_back", range_draw_step_back, 0);
  rb_define_method(gRange, "slider_update", range_slider_update, 0);
  rb_define_method(gRange, "trough_click", range_trough_click, 2);
  rb_define_method(gRange, "draw_background", range_draw_bg, 2);
  rb_define_method(gRange, "default_hslider_update", range_default_hslider_update, 0);
  rb_define_method(gRange, "default_vslider_update", range_default_vslider_update, 0);
  rb_define_method(gRange, "default_htrough_click", range_default_htrough_click, 2);
  rb_define_method(gRange, "default_vtrough_click", range_default_vtrough_click, 2);
  rb_define_method(gRange, "default_hmotion", range_default_hmotion, 2);
  rb_define_method(gRange, "default_vmotion", range_default_vmotion, 2);
}

/*
 * Scale
 */
static VALUE
scale_set_digits(self, digits)
    VALUE self, digits;
{
    gtk_scale_set_digits(GTK_SCALE(get_widget(self)), NUM2INT(digits));
    return self;
}

static VALUE
scale_set_draw_value(self, draw_value)
    VALUE self, draw_value;
{
    gtk_scale_set_draw_value(GTK_SCALE(get_widget(self)),
			     RTEST(draw_value));
    return self;
}

static VALUE
scale_set_value_pos(self, pos)
    VALUE self, pos;
{
    gtk_scale_set_value_pos(GTK_SCALE(get_widget(self)), 
			    (GtkPositionType)NUM2INT(pos));
    return self;
}

static VALUE
scale_value_width(self)
    VALUE self;
{
    int i = gtk_scale_value_width(GTK_SCALE(get_widget(self)));

    return INT2FIX(i);
}

static VALUE
scale_draw_value(self)
    VALUE self;
{
    gtk_scale_draw_value(GTK_SCALE(get_widget(self)));
    return self;
}

void Init_gtk_scale()
{
  gScale = rb_define_class_under(mGtk, "Scale", gRange);

  rb_define_method(gScale, "set_digits", scale_set_digits, 1);
  rb_define_method(gScale, "set_draw_value", scale_set_draw_value, 1);
  rb_define_method(gScale, "set_value_pos", scale_set_value_pos, 1);
  rb_define_method(gScale, "value_width", scale_value_width, 0);
  rb_define_method(gScale, "draw_value", scale_draw_value, 0);
}

/*
 * HScale
 */
static VALUE
hscale_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1;
    GtkAdjustment *adj = NULL;

    rb_scan_args(argc, argv, "01", &arg1);
    if (!NIL_P(arg1)) adj = GTK_ADJUSTMENT(get_gobject(arg1));

    set_widget(self, gtk_hscale_new(adj));
    return Qnil;
}

void Init_gtk_hscale()
{
  gHScale = rb_define_class_under(mGtk, "HScale", gScale);

  rb_define_method(gHScale, "initialize", hscale_initialize, -1);
}

/*
 * Vscale
 */
static VALUE
vscale_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1;
    GtkAdjustment *adj = NULL;

    rb_scan_args(argc, argv, "01", &arg1);
    if (!NIL_P(arg1)) adj = GTK_ADJUSTMENT(get_gobject(arg1));

    set_widget(self, gtk_vscale_new(adj));
    return Qnil;
}

void Init_gtk_vscale()
{
  gVScale = rb_define_class_under(mGtk, "VScale", gScale);

  rb_define_method(gVScale, "initialize", vscale_initialize, -1);
}

/*
 * Scrollbar
 */
void Init_gtk_scrollbar()
{
  gScrollbar = rb_define_class_under(mGtk, "Scrollbar", gRange);

  /* -- */
}

/*
 * HScrollbar
 */
static VALUE
hscrollbar_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1;
    GtkAdjustment *adj = NULL;

    rb_scan_args(argc, argv, "01", &arg1);
    if (!NIL_P(arg1)) adj = GTK_ADJUSTMENT(get_gobject(arg1));

    set_widget(self, gtk_hscrollbar_new(adj));
    return Qnil;
}

void Init_gtk_hscrollbar()
{
  gHScrollbar = rb_define_class_under(mGtk, "HScrollbar", gScrollbar);

  rb_define_method(gHScrollbar, "initialize", hscrollbar_initialize, -1);
}

/*
 * VScrollbar
 */
static VALUE
vscrollbar_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1;
    GtkAdjustment *adj = NULL;

    rb_scan_args(argc, argv, "01", &arg1);
    if (!NIL_P(arg1)) adj = GTK_ADJUSTMENT(get_gobject(arg1));

    set_widget(self, gtk_vscrollbar_new(adj));
    return Qnil;
}

void Init_gtk_vscrollbar()
{
  gVScrollbar = rb_define_class_under(mGtk, "VScrollbar", gScrollbar);

  rb_define_method(gVScrollbar, "initialize", vscrollbar_initialize, -1);
}
