/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * dblsub.h ---	Declarations for double number (64 Bit) arithmetics.
 *		This file depends on GNU-C version 2.3.3
 *
 * (duz 16Jul93)
 */

#ifndef __DBLSUB_H
#define __DBLSUB_H

#ifndef __CONFIG_H
#include "config.h"
#endif

#ifndef __VIRTUAL_H
#include "virtual.h"
#endif

void dasl (dCell * a, int n);
void dasr (dCell * a, int n);
void dnegate (dCell * a);
void madd (dCell * a, Cell b);
void dadd (dCell * a, dCell * b);
void dsub (dCell * a, dCell * b);
int dless (dCell * a, dCell * b);
int duless (udCell * a, udCell * b);
udCell ummul (uCell a, uCell b);
dCell mmul (Cell a, Cell b);
udiv_t umdiv (udCell num, uCell denom);
fdiv_t smdiv (dCell num, Cell denom);
fdiv_t fmdiv (dCell num, Cell denom);

#endif
