/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * options.h ---	User configurable options, change to suit your needs.
 *			See file `install' for explanations.
 */


#ifndef __OPTIONS_H
#define __OPTIONS_H

/*
 * System location on disk and file name conventions:
 */

#if defined DOS_FILENAMES	/* MS-DOS like file and path names */

#if defined WATCOM
# define _STR_(X) X
#else
# define _STR_(X) STRING1(X)
#endif

# ifdef PREFIX
#   define ROOTDIR		_STR_(PREFIX)
# else
#   define ROOTDIR		"C:"
# endif
# ifdef PFELIB
#   define LIBDIR		_STR_ (PFELIB)
# else
#   define LIBDIR		ROOTDIR"\\PFE"
# endif
# ifdef PFEHLP
#   define HELPDIR		_STR_ (PFEHLP)
# else
#   define HELPDIR		LIBDIR"\\HELP"
# endif

# define PATH_DELIMITER		';'
# define DIR_DELIMITER		'\\'
# define INC_PATHS		";"LIBDIR"\\INCLUDE"
# define INC_EXTENSIONS		";.PFE;.FS;.4TH;.FTH"
# define BLK_PATHS		INC_PATHS
# define BLK_EXTENSIONS		";.BLK;.SCR;.FB"
# define PFERC_FILE		"PFE0.RC"
# define DEFAULT_BLKFILE	"PFE.BLK"
# define LLCMD			"DIR"
# define LSCMD			"DIR /W"

#elif defined UNIX_FILENAMES	/* UNIX-like file and path names */

# ifdef PREFIX
#   define ROOTDIR		STRING1 (PREFIX)
# else
#   define ROOTDIR		"/usr/local"
# endif
# ifdef PFELIB
#   define LIBDIR		STRING1 (PFELIB)
# else
#   define LIBDIR		ROOTDIR"/lib/pfe"
# endif
# ifdef PFEHLP
#   define HELPDIR		STRING1 (PFEHLP)
# else
#   define HELPDIR		LIBDIR"/help"
# endif

# define PATH_DELIMITER		':'
# define DIR_DELIMITER		'/'
# define INC_PATHS		":~/.pfe:"LIBDIR"/include"
# define INC_EXTENSIONS		":.pfe:.fs:.4th:.fth:.forth"
# define BLK_PATHS		INC_PATHS
# define BLK_EXTENSIONS		":.blk:.scr:.fb"
# define PFERC_FILE		"~/.pferc"
# define DEFAULT_BLKFILE	"pfe.blk"
# define LLCMD			"ls -alF"
# define LSCMD			"ls -C"

#else

#error "Don't know what kind of file names your system uses, check config.h"

#endif


/*
 * System size in memory:
 */

#define	TOTAL_KB	1024	/* size of system altogether in KBytes */
#define TOTAL_SIZE	(TOTAL_KB * 1024)
#define	STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 8 */
#define	FLT_STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 16 */
#define	RET_STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 16 */
				/* the rest is used for dictionary, history, */
				/* string and block buffers, files etc. */

/*
 * Number and size of various system buffers:
 */

#define	MAX_FILES	0x10	/* maximum number of open files */
#define POCKETS		8	/* number of buffers and */
#define	POCKET_SIZE	0x100	/* size of buffers for interpretation of S" */

#define	MIN_HOLD	0x100	/* minimum space for <# # #S HOLD #> etc. */
#define	MIN_PAD		0x400	/* minimum free space in PAD */
#define	HISTORY_SIZE	0x1000	/* size of command line history buffer */


/*
 * Options controlling the dictionary structure:
 */

#define	ORDER_LEN	16	/* maximum word lists in search order */
#define	LD_THREADS	5	/* 2^n is number of threads in a words list */
#define	LD_LOCALS	5	/* 2^n is number of local variables allowed */


/*
 * Options controlling input and output:
 */

#define	TEXT_COLS	80	/* used only in case pfe fails determining */
#define	TEXT_ROWS	25	/* the screen size */

#define	PREFIX_HEX	'$'	/* 0 or prefix for input of hex numbers */
#define	PREFIX_BINARY	'%'	/* 0 or prefix for input of binary numbers */
#define	CAPS_ON		0	/* do you like (faked) caps lock by default? */
#define	LOWER_CASE_ON	1	/* allow "dup" to find "DUP" by default */
#define LWRCASE_FN_ON	1	/* convert file names to lower case? */
#define FLOAT_INPUT_ON	1	/* allow input of floating point numbers */
#define	NO_COMPLETION	0	/* 1 if you don't like completion feature */


/*
 * Options for the text and block editor:
 */

#define	EDITOR		"emacs"	/* preferred editor for text files, */
				/* env-variable EDITOR overrides this */
#define	LOGNAME		"you"	/* if your machine has no env-variable */
				/* LOGNAME, put your name here */
#define	ED_TABW		4	/* width of tab steps in block editor */


/*
 * Special keys, effective when using termunix terminal driver:
 */

#define	INTR_KEY	'\025'	/* (^U) key to send a SIGINT */
#define	QUIT_KEY	'\034'	/* (^\) key to send a SIGQUIT */
#define	SUSP_KEY	'\032'	/* (^Z) key to send a SIGTSTP */


#endif /* ndef __OPTIONS_H */
