/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * term.h ---	Declarations for terminal driver of pfe.
 *		It doesn't matter how you supply these functions,
 *		  --- just do it!
 *		For an example driver refer to term-ux.c.
 * (duz 09May93)
 */

#ifndef __TERM_H
#define __TERM_H

enum ekey_codes			/* The function keys known to pfe */
{
  EKEY_k1 = 0x100,		/* function keys F1 through F10 */
  EKEY_k2,
  EKEY_k3,
  EKEY_k4,
  EKEY_k5,
  EKEY_k6,
  EKEY_k7,
  EKEY_k8,
  EKEY_k9,
  EKEY_k0,

  EKEY_F1,			/* function keys S-F1 through S-F10 */
  EKEY_F2,
  EKEY_F3,
  EKEY_F4,
  EKEY_F5,
  EKEY_F6,
  EKEY_F7,
  EKEY_F8,
  EKEY_F9,
  EKEY_FA,

  /* "kl", "kr", "ku", "kd" */
  EKEY_kl,			/* arrow key left */
  EKEY_kr,			/* arrow key right */
  EKEY_ku,			/* arrow key up */
  EKEY_kd,			/* arrow key down */
  /* "kh", "kH", "kN", "kP" */
  EKEY_kh,			/* home key */
  EKEY_kH,			/* home down key */
  EKEY_kN,			/* next page key */
  EKEY_kP,			/* previous page key */
  /* "kb", "kD", "kM", "kI" */
  EKEY_kb,			/* backspace key */
  EKEY_kD,			/* delete character key */
  EKEY_kM,			/* exit insert mode key */
  EKEY_kI,			/* insert character key */
  /* "kA", "kE", "kL", "kC" */
  EKEY_kA,			/* insert line key */
  EKEY_kE,			/* clear to end of line key */
  EKEY_kL,			/* delete line key */
  EKEY_kC,			/* clear screen key */
  /* count the keys: */
  EKEY_LAST,
  NO_OF_KEYS = EKEY_LAST - EKEY_k1
};

extern char
  *rawkey_string [NO_OF_KEYS];	/* what all those keys really send */

/*
 * These variables are defined in the term.c and initialized by
 * term-xxx:prepare_terminal().  If window size can change, it would
 * be nice if they were kept up to date.
 */
extern int rows, cols;		/* size of text screen */
extern int xmax, ymax;		/* size of graphics window in pixels */

/* Refer to termcap.c for what these functions are expected to do: */

int tty_interrupt_key (char ch);
int prepare_terminal (void);
void interactive_terminal (void);
void system_terminal (void);
void query_winsize (void);

int c_keypressed (void);	/* I added the "c_"-prefix to avoid */
int c_getkey (void);		/* name clashes */

void c_putc_noflush (char c);
void c_flush (void);
void c_putc (char c);
void c_puts (const char *s);
void c_gotoxy (int x, int y);
void c_wherexy (int *x, int *y);

void c_goleft (void);
void c_goright (void);
void c_goup (void);
void c_godown (void);

void c_home (void);
void c_clrscr (void);
void c_clreol (void);
void c_clrdown (void);
void c_bell (void);

void c_standout_on (void);
void c_standout_off (void);
void c_bright (void);
void c_reverse (void);
void c_blinking (void);
void c_normal (void);
void c_underline_on (void);
void c_underline_off (void);

/* These are not part of the driver, but system independent, in term.c */

int printable (int c);		/* like isprint() for ISO-characters */
void c_putc_printable (int c);	/* like cputc() but certainly visible */
int change_case (int key);	/* exchange lower case with upper case char */
int getekey (void);		/* get a character like EKEY */
int ekeypressed (void);		/* check for extended key available */
int getwskey (void);		/* get a character, for block editor */

extern void (*on_stop) (void);
extern void (*on_continue) (void);
extern void (*on_winchg) (void);

#endif
