/********************************************************************************
*                                                                               *
*                  F i l e - A s s o c i a t i o n   T a b l e                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileDict.h,v 1.4 1999/11/16 18:29:25 jeroen Exp $                      *
********************************************************************************/
#ifndef FXFILEDICT_H
#define FXFILEDICT_H


// Registers stuff to know about the extension
struct FXFileAssoc {
  FXString   command;           // Command to execute
  FXString   extension;         // Full extension name
  FXString   mimetype;          // Mime type name
  FXIcon    *bigicon;           // Full size icon
  FXIcon    *miniicon;          // Mini icon
  FXDragType dragtype;          // Registered drag type
  FXuint     flags;             // Flags
  };


// Icon dictionary
class FXAPI FXIconDict : public FXDict {
  FXDECLARE(FXIconDict)
  friend class FXFileDict;
  FXApp        *app;            // Application object
  const FXchar *path;           // Where to search icons
protected:
  FXIconDict(){}
  virtual void *createData(const void*);
  virtual void deleteData(void*);
private:
  FXIconDict(const FXIconDict&);
  FXIconDict &operator=(const FXIconDict&);
public:

  // Construct an icon dictionary
  FXIconDict(FXApp* a);

  // Get application
  FXApp* getApp() const { return app; }

  // Insert unique icon loaded from filename into dictionary
  FXIcon* insert(const FXchar* name){ return (FXIcon*)FXDict::insert(name,name); }

  // Remove icon from dictionary
  FXIcon* remove(const FXchar* name){ return (FXIcon*)FXDict::remove(name); }

  // Find icon by name
  FXIcon* find(const FXchar* name){ return (FXIcon*)FXDict::find(name); }

  // Save to stream
  virtual void save(FXStream& store) const;

  // Load from stream
  virtual void load(FXStream& store);

  // Destruct
  virtual ~FXIconDict();
  };

    
// File Association dictionary
class FXAPI FXFileDict : public FXDict {
  FXDECLARE(FXFileDict)
protected:
  FXIconDict    icons;          // Icon table
protected:
  FXFileDict(){}
  virtual void *createData(const void*);
  virtual void deleteData(void*);
private:
  FXFileDict(const FXFileDict&);
  FXFileDict &operator=(const FXFileDict&);
public:

  // Construct an file association table
  FXFileDict(FXApp* a);

  // Get application
  FXApp* getApp() const { return icons.getApp(); }

  // Replace file association
  FXFileAssoc* replace(const FXchar* ext,const FXchar* str);

  // Remove file association
  FXFileAssoc* remove(const FXchar* ext);

  // Find file association already in dictionary
  FXFileAssoc* find(const FXchar* ext){ return (FXFileAssoc*)FXDict::find(ext); }

  // Find file association from registry
  FXFileAssoc* associate(const FXchar* ext);

  // Save to stream
  virtual void save(FXStream& store) const;

  // Load from stream
  virtual void load(FXStream& store);

  // Destruct
  virtual ~FXFileDict();
  };
  

#endif
