/********************************************************************************
*                                                                               *
*                               F o n t   O b j e c t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFont.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                         *
********************************************************************************/
#ifndef FXFONT_H
#define FXFONT_H



// Font class
class FXAPI FXFont : public FXId {
  FXDECLARE(FXFont)
private:
#ifdef FX_NATIVE_WIN32
  HDC		  dc;			// Dummy
#endif
protected:
  FXString	  name;                 // Name of the font
  FXuint	  size;                 // Font size (points*10)
  FXuint	  weight;               // Font weight
  FXuint	  slant;                // Font slant
  FXuint          encoding;             // Character set encoding
  FXuint	  setwidth;             // Relative setwidth
  FXuint	  hints;                // Matching hints
  void		 *font;                 // Info about the font
protected:
  FXFont();
#ifndef FX_NATIVE_WIN32
  char* findbestfont(char *fontname);
  const char* fallbackfont();
  char* findmatch(char *fontname,const char* family);
#endif  
private:
  FXFont(const FXFont&);
  FXFont &operator=(const FXFont&);
public:

  // Construct font from font description
  FXFont(FXApp* a,const FXFontDesc& fontdesc);

  // Construct a font with given face name, size in points(pixels), weight, slant, character set encoding, setwidth, and hints
  FXFont(FXApp* a,const FXString& face,FXuint sz,FXuint wt=FONTWEIGHT_NORMAL,FXuint sl=FONTSLANT_REGULAR,FXuint enc=FONTENCODING_DEFAULT,FXuint setw=FONTSETWIDTH_DONTCARE,FXuint h=0);

  // Construct a font with given X11 font string
  FXFont(FXApp* a,const FXString& nm);

  // Create the font
  virtual void create();

  // Detach the font
  virtual void detach();

  // Destroy the font
  virtual void destroy();

  // Get face name
  FXString getName() const { return name; }

  // Get size in deci-points
  FXuint getSize() const { return size; }

  // Get font weight
  FXuint getWeight() const { return weight; }

  // Get slant
  FXuint getSlant() const { return slant; }

  // Get character set encoding
  FXuint getEncoding() const { return encoding; }

  // Get setwidth
  FXuint getSetWidth() const { return setwidth; }

  // Get hints
  FXuint getHints() const { return hints; }

  // Get font description
  void getFontDesc(FXFontDesc& fontdesc);
  
  // Find out if the font is monotype or proportional
  FXbool isFontMono() const;
  
  // See if font has glyph for ch
  FXbool hasChar(FXchar ch) const;
  
  // Left bearing
  FXint leftBearing(FXchar ch) const;
  
  // Right bearing
  FXint rightBearing(FXchar ch) const;
  
  // Width of widest character in font
  FXint getFontWidth() const;
  
  // Height of highest character in font
  FXint getFontHeight() const;
  
  // Ascent from baseline
  FXint getFontAscent() const;
  
  // Descent from baseline
  FXint getFontDescent() const;
  
  // Get font leading [that is lead-ing as in Pb!]
  FXint getFontLeading() const;
  
  // Get font line spacing
  FXint getFontSpacing() const;

  // Calculate width of given text in this font
  FXint getTextWidth(const FXchar *text,FXuint n) const;
  
  // Calculate height of given text in this font
  FXint getTextHeight(const FXchar *text,FXuint n) const;
  
  // List all fonts matching hints
  static FXbool listFonts(FXFontDesc*& fonts,FXuint& numfonts,const FXString& face,FXuint wt=FONTWEIGHT_DONTCARE,FXuint sl=FONTSLANT_DONTCARE,FXuint sw=FONTSETWIDTH_DONTCARE,FXuint en=FONTENCODING_DEFAULT,FXuint h=0);

  // Save font data into stream
  virtual void save(FXStream& store) const;
  
  // Load font data from stream
  virtual void load(FXStream& store);

  // Destruct font
  virtual ~FXFont();
  };
  
    
#endif
