/********************************************************************************
*                                                                               *
*                       P r o f i l e r    C l a s s                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXProfiler.h,v 1.6 1999/10/14 18:38:21 gui Exp $                      *
********************************************************************************/
#ifndef FXPROFILER_H
#define FXPROFILER_H


// Different options for sorting the report
enum FXProfilerOptions {
  PROFILER_SORT_BY_NAME,
  PROFILER_SORT_BY_HITS,
  PROFILER_SORT_BY_TOTAL_TIME,
  PROFILER_SORT_BY_AVERAGE_TIME
  };


// Keeps track of number of hits and total time spent in functions
class FXProfiler {
private:
  struct FXProfilerStruct {
    FXString	    name;
    FXuint	    ncalls;
    FXdouble	    totaltime;
    FXdouble	    avgtime;
    };
  static FXuint	    flags;
  static FXDict     dict;
private:
  FXProfilerStruct *ps;
#ifdef WIN32
  LARGE_INTEGER     start;
#else
  struct timeval    start;
#endif
private:
  FXProfiler(const FXProfiler&);
  FXProfiler &operator=(const FXProfiler&);
  static int compare(const void* elem1,const void* elem2);
  void startClock();
  void stopClock();
public:
  FXProfiler(const FXchar* func);
  static void speak(FXProfilerOptions opts=PROFILER_SORT_BY_TOTAL_TIME);
  static void reset();
  ~FXProfiler();
  };


#ifdef FX_ENABLE_PROFILING
#define FXPROFILE(s) FXProfiler _profiler(s)
#else
#define FXPROFILE(s) ((void)0)
#endif

#endif
