/********************************************************************************
*                                                                               *
*                         T o p   W i n d o w   O b j e c t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXTopWindow.cpp,v 1.11 1999/11/15 22:00:14 gui Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXCursor.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXRootWindow.h"
#include "FXShell.h"
#include "FXTopWindow.h"
#include "FXImage.h"
#include "FXIcon.h"

/*
  Notes:
  - Need to trap & forward iconify messages.
  - Handle zero width/height case similar to FXWindow.
  - Pass Size Hints to Window Manager as per ICCCM.
  - Add padding options, as this is convenient for FXDialogBox subclasses;
    for FXTopWindow/FXMainWindow, padding should default to 0, for FXDialogBox,
    default to something easthetically pleasing...
  - Now observes LAYOUT_FIX_X and LAYOUT_FIX_Y hints.
  - LAYOUT_FIX_WIDTH and LAYOUT_FIX_HEIGHT take precedence over PACK_UNIFORM_WIDTH and
    PACK_UNIFORM_HEIGHT!
  - We should use some sort of SizeHints to let the WM know about our desired size.
      
    David Heath <dave@hipgraphics.com>

      I have something that appears to work under X/Motif, but even there I
      have not tested it under many window managers. Here is a little
      code snippet which sets the variables wmLeft, wmRight, wmTop, wmBottom
      to the border sizes.

            Window w, rw;
            unsigned int border, depth;
            unsigned int sx, sy, msx, msy;
            int ox, oy;
            Display *dpy = theApp->display ();

            w = XtWindow ((theApp->mainWindow ())->mainWindowWidget ());
            XGetGeometry (dpy, w, &rw, &ox, &oy, &msx, &msy, &border, &depth);

            wmLeft = wmRight = wmTop = wmBottom = 0;

            Window pw, c[100];
            unsigned int cn;

            do{
              XQueryTree (dpy, w, &rw, &pw, (Window **) &c, &cn);
              XGetGeometry (dpy, w, &rw, &ox, &oy, &sx, &sy, &border, &depth);
              printf ("Window 0x%p [%4dx%4d] +[%4d,%4d], border %4d\n", w, sx, sy, ox, oy, border);
              if(pw != rw){
                wmLeft += ox;
                wmTop += oy;
                }
              w = pw;
              } 
            while(w != rw);
            wmRight  = (sx - msx - wmLeft);
            wmBottom = (sy - msy - wmTop);
            printf ("WM Borders l:%d r:%d t:%d b:%d\n", wmLeft, wmRight, wmTop, wmBottom);




      One thing that I would find useful, if you do eventually add code
      to fox to determine these sizes, that you make the values accessible
      to the API in the rare case that someone needs them.
        
        
    Theo Veenker <theo.veenker@let.uu.nl>
        
*/

      
// Side layout modes
#define LAYOUT_SIDE_MASK (LAYOUT_SIDE_LEFT|LAYOUT_SIDE_RIGHT|LAYOUT_SIDE_TOP|LAYOUT_SIDE_BOTTOM)


// Layout modes
#define LAYOUT_MASK (LAYOUT_SIDE_MASK|LAYOUT_RIGHT|LAYOUT_CENTER_X|LAYOUT_BOTTOM|LAYOUT_CENTER_Y|LAYOUT_FIX_X|LAYOUT_FIX_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT|LAYOUT_FILL_X|LAYOUT_FILL_Y)


/*******************************************************************************/


// Definitions for Motif-style WM Hints.
// We should not assume Motif presence, so we define it here ourselves.
#ifndef FX_NATIVE_WIN32

// Definitions for FXMotifHints.flags
#define MWM_HINTS_FUNCTIONS	(1L << 0)
#define MWM_HINTS_DECORATIONS	(1L << 1)
#define MWM_HINTS_INPUT_MODE	(1L << 2)
#define MWM_HINTS_ALL           (MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS|MWM_HINTS_INPUT_MODE)

// Definitions for FXMotifHints.functions
#define MWM_FUNC_ALL		(1L << 0)
#define MWM_FUNC_RESIZE		(1L << 1)
#define MWM_FUNC_MOVE		(1L << 2)
#define MWM_FUNC_MINIMIZE	(1L << 3)
#define MWM_FUNC_MAXIMIZE	(1L << 4)
#define MWM_FUNC_CLOSE		(1L << 5)

// Definitions for FXMotifHints.decorations 
#define MWM_DECOR_ALL		(1L << 0)
#define MWM_DECOR_BORDER	(1L << 1)
#define MWM_DECOR_RESIZEH	(1L << 2)
#define MWM_DECOR_TITLE		(1L << 3)
#define MWM_DECOR_MENU		(1L << 4)
#define MWM_DECOR_MINIMIZE	(1L << 5)
#define MWM_DECOR_MAXIMIZE	(1L << 6)

// Values for FXMotifHints.inputmode
#define MWM_INPUT_MODELESS		    0
#define MWM_INPUT_PRIMARY_APPLICATION_MODAL 1
#define MWM_INPUT_SYSTEM_MODAL		    2
#define MWM_INPUT_FULL_APPLICATION_MODAL    3




// The _MWM_HINTS property.
struct FXMotifHints {
  long flags;
  long functions;
  long decorations;
  long inputmode;
  };
  
#endif


/*******************************************************************************/

// Map
FXDEFMAP(FXTopWindow) FXTopWindowMap[]={
  FXMAPFUNC(SEL_CLOSE,0,FXTopWindow::onClose),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXTopWindow::onCmdSetStringValue),
  };


// Object implementation
FXIMPLEMENT_ABSTRACT(FXTopWindow,FXShell,FXTopWindowMap,ARRAYNUMBER(FXTopWindowMap))


// Create toplevel window object & add to toplevel window list
FXTopWindow::FXTopWindow(FXApp* a,const FXString& name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs):
  FXShell(a,opts,x,y,w,h){
  title=name;
  icon=ic;
  miniIcon=mi;
  accelTable=new FXAccelTable;
  hspacing=hs;
  vspacing=vs;
  }


// Create toplevel window object & add to toplevel window list
FXTopWindow::FXTopWindow(FXWindow* own,const FXString& name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs):
  FXShell(own,opts,x,y,w,h){
  title=name;
  icon=ic;
  miniIcon=mi;
  accelTable=new FXAccelTable;
  hspacing=hs;
  vspacing=vs;
  }



// Close window
long FXTopWindow::onClose(FXObject*,FXSelector,void*){
  
  // If handled, we're not closing the window after all
  if(target && target->handle(this,MKUINT(message,SEL_CLOSE),NULL)) return 1;
  
  // Otherwise close window by hiding it
  hide();
  
  return 1;
  }


// Update value from a message
long FXTopWindow::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setTitle(*((FXString*)ptr));
  return 1;
  }


// Create window
void FXTopWindow::create(){
  FXShell::create();
  
  // Create icons
  if(icon) icon->create();
  if(miniIcon) miniIcon->create();
  
  // Catch delete window 
#ifndef FX_NATIVE_WIN32
  XSetWMProtocols(getApp()->display,xid,(Atom*)&getApp()->wmDeleteWindow,1);
#endif
  
  // Set position for Window Manager
#ifndef FX_NATIVE_WIN32
  XSizeHints size;
  
  size.flags=USPosition|PPosition|USSize|PSize|PWinGravity;
  size.min_width=0;
  size.min_height=0;
  size.max_width=0;
  size.max_height=0;
  size.x=xpos;
  size.y=ypos;
  size.width=width;
  size.height=height;
  size.width_inc=0;
  size.height_inc=0;
  size.min_aspect.x=0;
  size.min_aspect.y=0;
  size.max_aspect.x=0;
  size.max_aspect.y=0;
  size.base_width=0;
  size.base_height=0;
  size.win_gravity=StaticGravity; // Account for border (ICCCM)

  // Set hints
  XSetWMNormalHints(getApp()->display,xid,&size);
#endif

  // Set title
  settitle();
  
  // Set decorations
  setdecorations();
  
  // Set icon for X-Windows
  seticons();
  }


// Detach window
void FXTopWindow::detach(){
  FXShell::detach();
  if(icon) icon->detach();
  if(miniIcon) miniIcon->detach();
  }


// Display window and raise it
void FXTopWindow::show(){
  FXint ww=width,hh=height; 
  if(ww<8 || hh<8){
    if(ww<8) ww=getDefaultWidth();
    if(hh<8) hh=getDefaultHeight();
    resize(ww,hh);
    }
  FXShell::show();
  raise();
  }


// Set large icon(s)
void FXTopWindow::seticons(){
  
  // Set icon for X-Windows
#ifndef FX_NATIVE_WIN32
  XWMHints   wmhints;
//   XIconSize *iconsize;
//   FXint      numiconsizes,s;
//   
//   // Obtain best icon size
//   if(XGetIconSizes(getApp()->display,xid,&iconsize,&numiconsizes)){
//     FXTRACE((10,"Got icon sizes\n"));
//     for(s=0; s<numiconsizes; s++){
//       FXTRACE((10,"minw=%d minh=%d maxw=%d maxh=%d incw=%d inch=%d\n",
//         iconsize[s].min_width,
//         iconsize[s].min_height,
//         iconsize[s].max_width,
//         iconsize[s].max_height,
//         iconsize[s].width_inc,
//         iconsize[s].height_inc));
//       }
//     }
  
  wmhints.flags=InputHint;
  wmhints.input=TRUE;
  if(icon){
    if(!icon->xid || !icon->shape){ fxerror("%s::setIcon: illegal icon specified.\n",getClassName()); } 
    wmhints.flags|=IconPixmapHint|IconMaskHint;
    wmhints.icon_pixmap=icon->xid;
    wmhints.icon_mask=icon->shape;
    }
  else if(miniIcon){
    if(!miniIcon->xid || !miniIcon->shape){ fxerror("%s::setMiniIcon: illegal icon specified.\n",getClassName()); } 
    wmhints.flags|=IconPixmapHint|IconMaskHint;
    wmhints.icon_pixmap=miniIcon->xid;
    wmhints.icon_mask=miniIcon->shape;
    }
//   if(getApp()->getMainWindow()){
//     if(!getApp()->getMainWindow()->id()){ fxerror("%s::create:: expected main window to be created first.\n",getClassName()); }
//     wmhints.flags|=WindowGroupHint;
//     wmhints.window_group=getApp()->getMainWindow()->id();
//     }
  XSetWMHints(getApp()->display,xid,&wmhints);
  
  // Set both large and mini icon for MS-Windows
#else
  if(icon){
    FXASSERT(FALSE);
    }
  if(miniIcon){
    FXASSERT(FALSE);
    }
#endif
  }


// Set title
void FXTopWindow::settitle(){
#ifndef FX_NATIVE_WIN32
  XTextProperty t;
  char *s;
  s=(char*)title.text();
  if(XStringListToTextProperty((char**)&s,1,&t)){
    XSetWMIconName(getApp()->display,xid,&t);
    XSetWMName(getApp()->display,xid,&t);
    XFree(t.value);
    }
#else
  SetWindowText((HWND)xid,title.text());
#endif
  }


// Set decorations
void FXTopWindow::setdecorations(){
#ifndef FX_NATIVE_WIN32
  FXMotifHints prop;
  prop.flags=MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS|MWM_HINTS_INPUT_MODE;
  prop.decorations=0;
  prop.functions=MWM_FUNC_MOVE;
  prop.inputmode=MWM_INPUT_MODELESS;
  if(options&DECOR_TITLE){
    prop.decorations|=MWM_DECOR_TITLE;
    }
  if(options&DECOR_MINIMIZE){
    prop.decorations|=MWM_DECOR_MINIMIZE;
    prop.functions|=MWM_FUNC_MINIMIZE;
    }
  if(options&DECOR_MAXIMIZE){
    prop.decorations|=MWM_DECOR_MAXIMIZE;
    prop.functions|=MWM_FUNC_MAXIMIZE;
    }
  if(options&DECOR_CLOSE){
    prop.functions|=MWM_FUNC_CLOSE;
    }
  if(options&DECOR_BORDER){
    prop.decorations|=MWM_DECOR_BORDER;
    }
  if(options&DECOR_RESIZE){
    prop.decorations|=MWM_DECOR_RESIZEH;
    prop.functions|=MWM_FUNC_RESIZE;
    }
  if(options&DECOR_MENU){
    prop.decorations|=MWM_DECOR_MENU;
    prop.functions|=MWM_FUNC_RESIZE;
    }
  XChangeProperty(getApp()->display,xid,getApp()->wmMotifHints,getApp()->wmMotifHints,32,PropModeReplace,(unsigned char*)&prop,4);
#else
  DWORD dwStyle=WS_OVERLAPPED;
  if(options&DECOR_TITLE){
    dwStyle|=WS_CAPTION;
    }
  if(options&DECOR_MINIMIZE){
    FXASSERT(options&DECOR_MENU);
    dwStyle|=WS_MINIMIZEBOX|WS_SYSMENU;
    }
  if(options&DECOR_MAXIMIZE){
    FXASSERT(options&DECOR_MENU);
    dwStyle|=WS_MAXIMIZEBOX|WS_SYSMENU;
    }
  if(options&DECOR_CLOSE){
    // Looks like we always get this?
    }
  if(options&DECOR_BORDER){
    dwStyle|=WS_BORDER;
    }
  if(options&DECOR_RESIZE){
    dwStyle|=WS_THICKFRAME;
    }
  if(options&DECOR_MENU){
    dwStyle|=WS_SYSMENU;
    }
  SetWindowLong((HWND)xid,GWL_STYLE,dwStyle);
#endif
  }



// Change decorations
void FXTopWindow::setDecorations(FXuint decorations){
  FXuint opts=(decorations&~DECOR_ALL) | (decorations&DECOR_ALL);
  if(options!=opts){
    options=opts;
    if(xid) setdecorations();
    recalc();
    }
  }


// Get decorations
FXuint FXTopWindow::getDecorations() const { 
  return options&DECOR_ALL; 
  }


// Compute minimum width based on child layout hints
int FXTopWindow::getDefaultWidth(){
  register FXint t,wcum,wmax,mw=0;
  register FXWindow* child;
  register FXuint hints,side;
  wmax=wcum=0;
  if(options&PACK_UNIFORM_WIDTH) mw=maxChildWidth();
  for(child=getLast(); child; child=child->getPrev()){
    if(child->shown()){
      hints=child->getLayoutHints();
      side=hints&LAYOUT_SIDE_MASK;
      if(hints&LAYOUT_FIX_WIDTH) t=child->getWidth(); 
      else if(options&PACK_UNIFORM_WIDTH) t=mw;
      else t=child->getDefaultWidth();
      if(hints&LAYOUT_FIX_X){ 
        t=child->getX()+t;
        if(t>wmax) wmax=t;
        }
      else if(side==LAYOUT_SIDE_LEFT || side==LAYOUT_SIDE_RIGHT){
        if(child->getPrev()) wcum+=hspacing;
        wcum+=t;
        }
      else{
        if(t>wcum) wcum=t;
        }
      }
    }
  return FXMAX(wcum,wmax);
  }
  

// Compute minimum height based on child layout hints
int FXTopWindow::getDefaultHeight(){
  register FXint t,hcum,hmax,mh=0;
  register FXWindow* child;
  register FXuint hints,side;
  hmax=hcum=0;
  if(options&PACK_UNIFORM_HEIGHT) mh=maxChildHeight();
  for(child=getLast(); child; child=child->getPrev()){
    if(child->shown()){
      hints=child->getLayoutHints();
      side=hints&LAYOUT_SIDE_MASK;
      if(hints&LAYOUT_FIX_HEIGHT) t=child->getHeight(); 
      else if(options&PACK_UNIFORM_HEIGHT) t=mh;
      else t=child->getDefaultHeight();
      if(hints&LAYOUT_FIX_Y){
        t=child->getY()+t;
        if(t>hmax) hmax=t;
        }
      else if(side==LAYOUT_SIDE_TOP || side==LAYOUT_SIDE_BOTTOM){
        if(child->getPrev()) hcum+=vspacing;
        hcum+=t;
        }
      else{
        if(t>hcum) hcum=t;
        }
      }
    }
  return FXMAX(hcum,hmax);
  }


// Recalculate layout
void FXTopWindow::layout(){
  FXint left,right,top,bottom;
  FXint mw=0,mh=0;
  FXWindow* child;
  FXint x,y,w,h;
  FXint extra_space,total_space;
  FXuint hints,side;
  
  // Placement rectangle; right/bottom non-inclusive
  left=0;
  right=width;
  top=0;
  bottom=height;
  
  // Get maximum child size
  if(options&PACK_UNIFORM_WIDTH) mw=maxChildWidth();
  if(options&PACK_UNIFORM_HEIGHT) mh=maxChildHeight();
  
  // Pack them in the cavity
  for(child=getFirst(); child; child=child->getNext()){
    if(child->shown()){
      hints=child->getLayoutHints();
      side=hints&LAYOUT_SIDE_MASK;
      x=child->getX();
      y=child->getY();
      if(hints&LAYOUT_FIX_WIDTH) w=child->getWidth(); 
      else if(options&PACK_UNIFORM_WIDTH) w=mw;
      else w=child->getDefaultWidth();
      if(hints&LAYOUT_FIX_HEIGHT) h=child->getHeight(); 
      else if(options&PACK_UNIFORM_HEIGHT) h=mh;
      else h=child->getDefaultHeight();
      if(side==LAYOUT_SIDE_LEFT){           // Left side
        if(!(hints&LAYOUT_FIX_Y)){
          extra_space=0;
          if(hints&LAYOUT_FILL_Y){
            h=bottom-top;
            if(h<0) h=0;
            }
          else if(hints&LAYOUT_CENTER_Y){
            if(h<(bottom-top)) extra_space=(bottom-top-h)/2;
            }
          if(hints&LAYOUT_BOTTOM)
            y=bottom-extra_space-h;
          else /*hints&LAYOUT_TOP*/
            y=top+extra_space;
          }
        if(!(hints&LAYOUT_FIX_X)){
          extra_space=0;
          total_space=0;
          if(hints&LAYOUT_FILL_X){
            w=right-left;
            if(w<0) w=0;
            }
          else if(hints&LAYOUT_CENTER_X){
            if(w<(right-left)){
              total_space=right-left-w;
              extra_space=total_space/2;
              }
            }
          x=left+extra_space;
          left+=(w+hspacing+total_space);
          }
        }
      else if(side==LAYOUT_SIDE_RIGHT){     // Right side
        if(!(hints&LAYOUT_FIX_Y)){
          extra_space=0;
          if(hints&LAYOUT_FILL_Y){
            h=bottom-top;
            if(h<0) h=0;
            }
          else if(hints&LAYOUT_CENTER_Y){
            if(h<(bottom-top)) extra_space=(bottom-top-h)/2;
            }
          if(hints&LAYOUT_BOTTOM)
            y=bottom-extra_space-h;
          else /*hints&LAYOUT_TOP*/
            y=top+extra_space;
          }
        if(!(hints&LAYOUT_FIX_X)){
          extra_space=0;
          total_space=0;
          if(hints&LAYOUT_FILL_X){
            w=right-left;
            if(w<0) w=0;
            }
          else if(hints&LAYOUT_CENTER_X){
            if(w<(right-left)){
              total_space=right-left-w;
              extra_space=total_space/2;
              }
            }
          x=right-w-extra_space;
          right-=(w+hspacing+total_space);
          }
        }
      else if(side==LAYOUT_SIDE_BOTTOM){    // Bottom side
        if(!(hints&LAYOUT_FIX_X)){
          extra_space=0;
          if(hints&LAYOUT_FILL_X){
            w=right-left;
            if(w<0) w=0;
            }
          else if(hints&LAYOUT_CENTER_X){
            if(w<(right-left)) extra_space=(right-left-w)/2;
            }
          if(hints&LAYOUT_RIGHT)
            x=right-extra_space-w;
          else /*hints&LAYOUT_LEFT*/
            x=left+extra_space;
          }
        if(!(hints&LAYOUT_FIX_Y)){
          extra_space=0;
          total_space=0;
          if(hints&LAYOUT_FILL_Y){
            h=bottom-top;
            if(h<0) h=0;
            }
          else if(hints&LAYOUT_CENTER_Y){
            if(h<(bottom-top)){
              total_space=bottom-top-h;
              extra_space=total_space/2;
              }
            }
          y=bottom-h-extra_space;
          bottom-=(h+vspacing+total_space);
          }
        }
      else if(side==LAYOUT_SIDE_TOP){       // Top side
        if(!(hints&LAYOUT_FIX_X)){
          extra_space=0;
          if(hints&LAYOUT_FILL_X){
            w=right-left;
            if(w<0) w=0;
            }
          else if(hints&LAYOUT_CENTER_X){
            if(w<(right-left)) extra_space=(right-left-w)/2;
            }
          if(hints&LAYOUT_RIGHT)
            x=right-extra_space-w;
          else /*hints&LAYOUT_LEFT*/
            x=left+extra_space;
          }
        if(!(hints&LAYOUT_FIX_Y)){
          extra_space=0;
          total_space=0;
          if(hints&LAYOUT_FILL_Y){
            h=bottom-top;
            if(h<0) h=0;
            }
          else if(hints&LAYOUT_CENTER_Y){
            if(h<(bottom-top)){
              total_space=bottom-top-h;
              extra_space=total_space/2;
              }
            }
          y=top+extra_space;
          top+=(h+vspacing+total_space);
          }
        }
      child->position(x,y,w,h);
      }
    }
  
  // No more dirty
  flags&=~FLAG_DIRTY;
  }


// Request for toplevel window move
void FXTopWindow::move(FXint x,FXint y){
  if((x!=xpos) || (y!=ypos)){
    xpos=x;
    ypos=y;
    if(xid){
#ifndef FX_NATIVE_WIN32
      XWindowChanges cw;
      cw.x=xpos;
      cw.y=ypos;
      XReconfigureWMWindow(getApp()->display,xid,DefaultScreen(getApp()->display),CWX|CWY,&cw);
#else
      // Calculate the required window position based on the desired
      // position of the *client* rectangle.
      RECT rect;
      SetRect(&rect,xpos,ypos,0,0);
      DWORD dwStyle=GetWindowLong((HWND)xid,GWL_STYLE);
      BOOL bMenu=FALSE;	// No, we always account for the menu bar ourselves
      DWORD dwExStyle=GetWindowLong((HWND)xid,GWL_EXSTYLE);
      AdjustWindowRectEx(&rect,dwStyle,bMenu,dwExStyle);
      SetWindowPos((HWND)xid,NULL,rect.left,rect.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
#endif
      }
    }
  }
  
  
// Request for toplevel window resize
void FXTopWindow::resize(FXint w,FXint h){
  if((flags&FLAG_DIRTY) || (w!=width) || (h!=height)){
    width=FXMAX(w,1);
    height=FXMAX(h,1);
    if(xid){
#ifndef FX_NATIVE_WIN32
      XWindowChanges cw;
      cw.width=width;
      cw.height=height;
      XReconfigureWMWindow(getApp()->display,xid,DefaultScreen(getApp()->display),CWWidth|CWHeight,&cw);
#else
      // Calculate the required window size based on the desired
      // size of the *client* rectangle.
      RECT rect;
      SetRect(&rect,0,0,width,height);
      DWORD dwStyle=GetWindowLong((HWND)xid,GWL_STYLE);
      BOOL bMenu=FALSE;	// No, we always account for the menu bar ourselves
      DWORD dwExStyle=GetWindowLong((HWND)xid,GWL_EXSTYLE);
      AdjustWindowRectEx(&rect,dwStyle,bMenu,dwExStyle);
      SetWindowPos((HWND)xid,NULL,0,0,FXMAX(rect.right-rect.left,1),FXMAX(rect.bottom-rect.top,1),SWP_NOMOVE|SWP_NOZORDER);
#endif
      layout();
      }
    }
  }

  
// Request for toplevel window reposition
void FXTopWindow::position(FXint x,FXint y,FXint w,FXint h){
  if((flags&FLAG_DIRTY) || (x!=xpos) || (y!=ypos) || (w!=width) || (h!=height)){
    xpos=x;
    ypos=y;
    width=FXMAX(w,1);
    height=FXMAX(h,1);
    if(xid){
#ifndef FX_NATIVE_WIN32
      XWindowChanges cw;
      cw.x=xpos;
      cw.y=ypos;
      cw.width=width;
      cw.height=height;
      XReconfigureWMWindow(getApp()->display,xid,DefaultScreen(getApp()->display),CWX|CWY|CWWidth|CWHeight,&cw);
#else
      // Calculate the required window position & size based on the desired
      // position & size of the *client* rectangle.
      RECT rect;
      SetRect(&rect,xpos,ypos,xpos+width,ypos+height);
      DWORD dwStyle=GetWindowLong((HWND)xid,GWL_STYLE);
      BOOL bMenu=FALSE;	// No, we always account for the menu bar ourselves
      DWORD dwExStyle=GetWindowLong((HWND)xid,GWL_EXSTYLE);
      AdjustWindowRectEx(&rect,dwStyle,bMenu,dwExStyle);
      SetWindowPos((HWND)xid,NULL,rect.left,rect.top,FXMAX(rect.right-rect.left,1),FXMAX(rect.bottom-rect.top,1),SWP_NOZORDER);
#endif
      layout();
      }
    }
  }


// Change regular icon
void FXTopWindow::setIcon(FXIcon* ic){
  if(icon!=ic){
    icon=ic;
    if(xid) seticons();
    }
  }


// Change mini icon
void FXTopWindow::setMiniIcon(FXIcon *ic){
  if(miniIcon!=ic){
    miniIcon=ic;
    if(xid) seticons();
    }
  }


// Set new window title
void FXTopWindow::setTitle(const FXString& name){
  if(title!=name){
    title=name;
    if(xid) settitle();
    }
  }


// Change packing hints
void FXTopWindow::setPackingHints(FXuint ph){
  FXuint opts=(options&~(PACK_UNIFORM_HEIGHT|PACK_UNIFORM_WIDTH)) | (ph&(PACK_UNIFORM_HEIGHT|PACK_UNIFORM_WIDTH));
  if(opts!=options){
    options=opts;
    recalc();
    update();
    }
  }


// Get packing hints
FXuint FXTopWindow::getPackingHints() const { 
  return (options&(PACK_UNIFORM_HEIGHT|PACK_UNIFORM_WIDTH));
  }


// Change horizontal spacing
void FXTopWindow::setHSpacing(FXint hs){
  if(hspacing!=hs){
    hspacing=hs;
    recalc();
    update();
    }
  }


// Change vertical spacing
void FXTopWindow::setVSpacing(FXint vs){
  if(vspacing!=vs){
    vspacing=vs;
    recalc();
    update();
    }
  }


// Remove this one from toplevel window list
FXTopWindow::~FXTopWindow(){
  icon=(FXIcon*)-1;
  miniIcon=(FXIcon*)-1;
  }


