REM Copyright (c) 1995, 3Dfx Interactive, Inc.
REM All Rights Reserved.
REM
REM This is UNPUBLISHED PROPRIETARY SOURCE CODE of 3Dfx Interactive, Inc.;
REM the contents of this file may not be disclosed to third parties, copied or
REM duplicated in any form, in whole or in part, without the prior written
REM permission of 3Dfx Interactive, Inc.
REM
REM RESTRICTED RIGHTS LEGEND:
REM Use, duplication or disclosure by the Government is subject to restrictions
REM as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
REM and Computer Software clause at DFARS 252.227-7013, and/or in similar or
REM successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished  -
REM rights reserved under the Copyright Laws of the United States.


@echo off
REM ------------------------------------------
REM CSETUP.BAT SET UP 3DFX BUILD ENVIRONMENT
REM ------------------------------------------

IF "%1"=="MSVC"   SET CTARGET=MSVC
IF "%1"=="msvc"   SET CTARGET=MSVC
IF "%1"=="WATDOS" SET CTARGET=WATDOS
IF "%1"=="watdos" SET CTARGET=WATDOS
IF "%CTARGET%"=="" GOTO USAGE

REM ------------------------------------------
REM STORE THE PATH
REM ------------------------------------------
IF NOT "%OLDPATH%"=="" GOTO DONTSTORE
SET OLDPATH=%PATH%
:DONTSTORE


REM ---------------------------------------------------------
REM SET THE FOLLOWING VARIABLES (before attempting to compile
REM ---------------------------------------------------------

REM You must set NMAKE to the directory that contains nmake.exe
set NMAKE=d:\nmake

REM You must set BUILD_DRIVE to the drive that you are building on ex:
set BUILD_DRIVE=d:

REM You must set BUILD_ROOT to the root of where you extracted your
REM source kit to ex:
set BUILD_ROOT=d:\3dfx\devel

REM You must set MASM to the location of your Microsoft Assembler
REM directory ex:
set MASM=c:\DevTools\masm613

REM You must set MSVC to the location of your Microsoft Visual C++
REM compiler ex:
set MSVC=c:\DevTools\msvc42

REM You must set DIRECTXSDK to the location of your DirectX SDK 
REM 3Dfx requires DirectX 6 SDK
REM directory ex:
SET DIRECTXSDK=c:\DevTools\dx6\sdk

REM You must set DIRECTXDDK to the location of your DirectX DDK
REM 3Dfx requires DirectX 5 DDK (release 3)
REM directory ex:
SET DIRECTXDDK=c:\DevTools\dx5sdkr3\ddk

REM You must set WATCOM to the location of your Watcom compiler files ex:
set WATCOM=c:\DevTools\wat106

REM You must set FX_DLL_BUILD to 1 if you are attempting to build a Glide
REM DLL.  However, if you would just like to build static libs it must
REM be UN-set  (set FX_DLL_BUILD=).  You must also UN-set this to build
REM for DOS.
REM set FX_DLL_BUILD=1 (will build .dll)
set FX_DLL_BUILD=1


REM ------------------------------------------
REM CHECK CRITICAL VARS
REM ------------------------------------------
IF NOT "%BUILD_DRIVE%"=="" GOTO DRIVEDEFD
ECHO You must set the environment variable BUILD_DRIVE
ECHO   to the driver letter of the source tree.
ECHO eg. SET BUILD_DRIVE=d:
GOTO END
:DRIVEDEFD
IF NOT "%BUILD_ROOT%"=="" GOTO ROOTDEFD
ECHO You must set the environment variable BUILD_ROOT
ECHO    to the root directory of the source tree.
ECHO eg. SET BUILD_ROOT=\3dfx\devel 
ECHO NOTE: BUILD_ROOT doesn't need a drive letter.
GOTO END
:ROOTDEFD
IF NOT "%MASM%=="" GOTO MASMDEFD
ECHO You must set the environment variable MASM
ECHO    To the install directory for 
ECHO    Microsoft Assember VERSION 6.11 ( or greater )
ECHO eg. SET MASM=C:\DEVEL\MASM611
GOTO END
:MASMDEFD


REM ------------------------------------------
REM   SET COMMON VARS
REM ------------------------------------------
SET BUILD_ROOT_H3=%BUILD_ROOT%\H3
SET BUILD_ROOT_SWLIBS=%BUILD_ROOT%\swlibs
SET FX_GLIDE_HW=H3
REM ******************SET FX_HW_PROJECTS=GLIDE
REM ***************SET HAL_HW=1
SET FX_NO_GEN_BOF=1
SET DXDDK=%DIRECTXDDK%

REM ------------------------------------------
REM SWITCH TO COMPILER
REM ------------------------------------------
GOTO %CTARGET%

REM ------------------------------------------
REM MSVC Targetting Win32
REM ------------------------------------------
:MSVC
IF NOT "%MSVC%"=="" GOTO MSVCDEFD
ECHO You must set the environment variable MSVC
ECHO   to the install directory for Microsoft 
ECHO   visual C/C++ 4.2 or greater
ECHO eg. SET MSVC=C:\devel\msdev
GOTO END
:MSVCDEFD
ECHO *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
ECHO   Ensure that the original %BUILD_ROOT%\swlibs\fxpci directory is being
ECHO   used when compiling GLide2 for Windows 95.
ECHO   See README.TXT for details.
ECHO *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
PAUSE

SET PATH=%MSVC%\bin;%OLDPATH%;%MASM%\bin

SET INCLUDE=%MSVC%\INCLUDE;%MSVC%\MFC\INCLUDE;%BUILD_ROOT_SWLIBS%\include
SET INCLUDE=%INCLUDE%;%BUILD_ROOT_SWLIBS%\include\nmake;%MASM%\INCLUDE

SET LIB=%MSVC%\lib;%MSVC%\MFC\lib;%MASM%\lib
SET AT_LOADER_MG=1

SET FX_COMPILER=MICROSOFT
SET FX_TARGET=WIN32
SET FX_HOST=DOS
GOTO END


REM ------------------------------------------
REM Watcom Targetting Dos
REM ------------------------------------------
:WATDOS
IF NOT "%WATCOM%"=="" GOTO WATDEFD1
ECHO You must set the environment variable WATCOM
ECHO   to the install directory for Watcom
ECHO   C/C++ 10.6 or greater
ECHO eg. SET WATCOM=C:\devel\WATCOM
GOTO END
:WATDEFD1
ECHO *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
ECHO   The directory %BUILD_ROOT%\swlibs\DOSfxpci needs to be renamed to
ECHO   %BUILD_ROOT%\swlibs\fxpci for the DOS compile.  Save the original
ECHO   %BUILD_ROOT%\swlibs\fxpci directory for use when compiling GLide2
ECHO   for Windows 95.  See README.TXT for details.
ECHO *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
PAUSE

SET PATH=%WATCOM%\binnt;%WATCOM%\binw;%OLDPATH%;%NMAKE%;%MASM%\bin

SET INCLUDE=%WATCOM%\H;%WATCOM%\H\NT
SET INCLUDE=%INCLUDE%;%BUILD_ROOT_SWLIBS%\include\nmake;%MASM%\INCLUDE

SET LIB=%WATCOM%\LIB386\DOS;%MASM%\lib

SET FX_COMPILER=WATCOM
SET FX_TARGET=DOS
SET FX_HOST=DOS
SET FX_WATCOM_REG_CALL=
GOTO END

:USAGE
ECHO CSETUP.BAT - Set up 3Dfx Software Build Environment
ECHO USAGE: CSETUP buildspec
ECHO where buildspec is:
ECHO         msvc   - Microsoft Visual C Targetting Win32
ECHO         watdos - Watcom C/C++ 10.6 Targetting Dos
GOTO END

:END
set CTARGET=

