##
## by Christian Hammers <ch@westend.com>
##
## Thanks to Stephan Kulow since I learned very much from his 
## KDE m4 files and even borrowed the AC_FIND_FILE from him
##

## Here I try to find the location of the mysql, pgsql, msql files
## If they are found and wanted, they get included

AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2; do
	for j in $1; do
		if test -r "$i/$j"; then
			$3=$i
			break 2
		fi
	done
done
])

##
##
##
## PGSQL
##
##
##
AC_DEFUN(CH_CHECK_PGSQL,
[
AC_MSG_CHECKING([for pgsql])

ac_pgsql="NO"
ac_pgsql_incdir="NO"
ac_pgsql_libdir="NO"
pgsql=""
pgsql_include=""
pgsql_libdir=""

AC_ARG_WITH(pgsql,
	[  --with-pgsql		  compile pgsql support],
	[  ac_pgsql="YES" ])
AC_ARG_WITH(pgsql-dir,
	[  --with-pgsql-dir	  where the root of pgsql is installed ],
	[  ac_pgsql_incdir="$withval"/include
	   ac_pgsql_libdir="$withval"/lib ])
AC_ARG_WITH(pgsql-incdir,
	[  --with-pgsql-incdir	  where the pgsql includes are ],
	[  ac_pgsql_incdir="$withval" ])
AC_ARG_WITH(pgsql-libdir,
	[  --with-pgsql-libdir	  where the pgsql libs are ],
	[  ac_pgsql_libdir="$withval" ])

if test "$ac_pgsql" = "YES"; then
	# Test for the libraries needed by PostgresQL
	if test "$ac_pgsql_incdir" = "NO" || test "$ac_pgsql_libs" = "NO"; then
		##### No ? Then we have to search ! #####
		pgsql_incdirs="/usr/include /usr/local/include /usr/include/pgsql /usr/local/include/pgsql /usr/local/pgsql/include /usr/include/postgresql /usr/local/postgresql/include"
		AC_FIND_FILE(libpq-fe.h, $pgsql_incdirs, ac_pgsql_incdir)
		pgsql_libdirs="/usr/lib /usr/local/lib /usr/lib/pgsql /usr/local/lib/pgsql /usr/local/pgsql/lib"
		pgsql_libs="libpq.so libpq.a"
		AC_FIND_FILE($pgsql_libs, $pgsql_libdirs, ac_pgsql_libdir)
		# here we could try to compile a little program, but I'm too lazy
		# but now it's time for some errors
		if test "$ac_pgsql_incdir" = "NO"; then
			AC_MSG_ERROR([pgsql includes not found.])
			exit;
		fi
		if test "$ac_pgsql_libdir" = "NO"; then
			AC_MSG_ERROR([pgsql libraries not found.])
			exit;
		fi
	fi
	AC_MSG_RESULT([libraries $ac_pgsql_libdir, headers $ac_pgsql_incdir])
	# substitute the directories
	pgsql=libchpgsql.la
	pgsql_libdir="-L$ac_pgsql_libdir"
	pgsql_incdir="-I$ac_pgsql_incdir"
	all_libraries="$pgsql_libdir $all_libraries"
	all_includes="$pgsql_incdir $all_includes"
	AC_SUBST(pgsql)
	AC_SUBST(pgsql_libdir)
	AC_SUBST(pgsql_incdir)
	# substitute the header file in libch.h
	pgsqlinc="$ac_pgsql_incdir/libpq-fe.h"
	AC_SUBST(pgsqlinc)
else
	AC_MSG_RESULT("not wanted")
fi
]
)

##
##
##
## MYSQL
##
##
##
AC_DEFUN(CH_CHECK_MYSQL,
[
ac_mysql="NO"
ac_mysql_incdir="NO"
ac_mysql_libdir="NO"
mysql=""
mysql_incdir=""
mysql_libdir=""

AC_ARG_WITH(mysql,
	[  --with-mysql		  compile mysql support],
	[  ac_mysql="YES" ])
AC_ARG_WITH(mysql-dir,
	[  --with-mysql-dir	  where the root of mysql is installed ],
	[  ac_mysql_incdir="$withval"/include
	   ac_mysql_libdir="$withval"/lib ])
AC_ARG_WITH(mysql-incdir,
	[  --with-mysql-incdir	  where the mysql includes are ],
	[  ac_mysql_incdir="$withval" ])
AC_ARG_WITH(mysql-libdir,
	[  --with-mysql-libdir	  where the mysql libs are ],
	[  ac_mysql_libdir="$withval" ])

if test "$ac_mysql" = "YES"; then
	# check if we have all the libraries needed by MySQL
	AC_SEARCH_LIBS(yp_bind, "nsl")
	AC_SEARCH_LIBS(crypt, "crypt")
	AC_SEARCH_LIBS(socket, "socket")

	AC_MSG_CHECKING([for mysql])
	if test "$ac_mysql_incdir" = "NO" || test "$ac_mysql_libs" = "NO"; then
		##### No ? Then we have to search ! #####
		mysql_incdirs="/usr/include /usr/local/include /usr/include/mysql /usr/local/include/mysql /usr/local/mysql/include /usr/local/mysql/include/mysql"
		AC_FIND_FILE(mysql.h, $mysql_incdirs, ac_mysql_incdir)
		mysql_libdirs="/usr/lib /usr/local/lib /usr/lib/mysql /usr/local/lib/mysql /usr/local/mysql/lib /usr/local/mysql/lib/mysql"
		mysql_libs="libmysqlclient.so libmysqlclient.a"
		AC_FIND_FILE($mysql_libs, $mysql_libdirs, ac_mysql_libdir)
		# here we could try to compile a little program, but I'm too lazy
		# but now it's time for some errors
		if test "$ac_mysql_incdir" = "NO"; then
			AC_MSG_ERROR([mysql includes not found.])
			exit;
		fi
		if test "$ac_mysql_libdir" = "NO"; then
			AC_MSG_ERROR([mysql libraries not found.])
			exit;
		fi
	fi
	AC_MSG_RESULT([libraries $ac_mysql_libdir, headers $ac_mysql_incdir])
	# substitute the directories
	mysql=libchmysql.la
	mysql_libdir="-L$ac_mysql_libdir"
	mysql_incdir="-I$ac_mysql_incdir"
	all_libraries="$mysql_libdir $all_libraries"
	all_includes="$mysql_incdir $all_includes"
	AC_SUBST(mysql)
	AC_SUBST(mysql_libdir)
	AC_SUBST(mysql_incdir)
    # substitute the header file in libch.h
	mysqlinc="$ac_mysql_incdir/mysql.h"
	AC_SUBST(mysqlinc)
else
	AC_MSG_CHECKING([for mysql])
	AC_MSG_RESULT("not wanted")
fi
]
)


##
##
##
## MSQL
##
##
##
AC_DEFUN(CH_CHECK_MSQL,
[
AC_MSG_CHECKING([for msql])

ac_msql="NO"
ac_msql_incdir="NO"
ac_msql_libdir="NO"
msql=""
msql_include=""
msql_libdir=""

AC_ARG_WITH(msql,
	[  --with-msql	 	  compile msql support],
	[  ac_msql="YES" ])
AC_ARG_WITH(msql-dir,
	[  --with-msql-dir	  where the root of msql is installed ],
	[  ac_msql_incdir="$withval"/include
	   ac_msql_libdir="$withval"/lib ])
AC_ARG_WITH(msql-incdir,
	[  --with-msql-incdir	  where the msql includes are ],
	[  ac_msql_incdir="$withval" ])
AC_ARG_WITH(msql-libdir,
	[  --with-msql-libdir	  where the msql libs are ],
	[  ac_msql_libdir="$withval" ])

if test "$ac_msql" = "YES"; then
	if test "$ac_msql_incdir" = "NO" || test "$ac_msql_libs" = "NO"; then
		##### No ? Then we have to search ! #####
		msql_incdirs="/usr/include /usr/local/Hughes/include /usr/local/include /usr/include/msql /usr/local/include/msql /usr/local/msql/include"
		AC_FIND_FILE(msql.h, $msql_incdirs, ac_msql_incdir)
		msql_libdirs="/usr/lib /usr/local/Hughes/lib /usr/local/lib /usr/lib/msql /usr/local/lib/msql /usr/local/msql/lib"
		msql_libs="libmsql.so libmsql.a"
		AC_FIND_FILE($msql_libs, $msql_libdirs, ac_msql_libdir)
		# here we could try to compile a little program, but I'm too lazy
		# but now it's time for some errors
		if test "$ac_msql_incdir" = "NO"; then
			AC_MSG_ERROR([msql includes not found.])
			exit;
		fi
		if test "$ac_msql_libdir" = "NO"; then
			AC_MSG_ERROR([msql libraries not found.])
			exit;
		fi
	fi
	AC_MSG_RESULT([libraries $ac_msql_libdir, headers $ac_msql_incdir])
	# substitute the directories
	msql=libchmsql.la
	msql_libdir="-L$ac_msql_libdir"
	msql_incdir="-I$ac_msql_incdir"
	all_libraries="$msql_libdir $all_libraries"
	all_includes="$msql_incdir $all_includes"
	AC_SUBST(msql)
	AC_SUBST(msql_libdir)
	AC_SUBST(msql_incdir)
    # substitute the header file in libch.h
	msqlinc="$ac_msql_incdir/msql.h"
	AC_SUBST(msqlinc)
else
	AC_MSG_RESULT("not wanted")
fi
]
)
