/* $Id: x.h,v 1.5 1999/02/14 17:31:06 marcus Exp $
******************************************************************************

   Display-X: data

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_X_H
#define _GGI_DISPLAY_X_H

#include <ggi/internal/ggi-dl.h>
#include <ggi/input/xwin.h>
#include <ggi/display/mansync.h>

#include <ggi/display/xcommon.h>

#ifdef HAVE_SYS_SHM_H
#define HAVE_SHM
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#if defined(__osf__)
extern int XShmQueryExtension(Display *);
#endif

ggifunc_flush		GGI_X_flush;
ggifunc_getmode		GGI_X_getmode;
ggifunc_setmode		GGI_X_setmode;
ggifunc_checkmode	GGI_X_checkmode;
ggifunc_getapi 		GGI_X_getapi;
ggifunc_setflags	GGI_X_setflags;

ggifunc_setpalvec	GGI_X_setpalvec;

struct Xhooks {
	Display	   *display;
	int	    screen;
	XVisualInfo visual;
	Window      window;
	Cursor      cursor;

	int       wintype;
	ggi_coord defsize;

	GC       gc;
	Colormap cmap;
	int      cmap_first, cmap_last, nocols; /* Info for palettized modes */

	gii_input *inp;
	void   *XLibLock;

	int      xoff, yoff;	/* We can pan, too */
	int      ysplit;	/* Emulating Splitline ;-) */
	int      viswidth, visheight;
	XImage  *ximage;		/* Current frame */
	XImage  *ximage_list[8];	/* List of frames */
	_ggi_opmansync *opmansync;
	
#ifdef HAVE_SHM
	XShmSegmentInfo shminfo[8];	/* Segment info. */
	int     have_shm;
#endif
};

/* Defined in mode.c */
int _ggi_x_do_blit(struct Xhooks *priv, int x, int y, int w, int h);


#define XLIB_PRIV(vis) ((struct Xhooks *)LIBGGI_PRIVATE(vis))

void _GGI_X_freedbs(ggi_visual *, struct Xhooks *);


#define MANSYNC_init(vis)   XLIB_PRIV(vis)->opmansync->init(vis)
#define MANSYNC_deinit(vis) XLIB_PRIV(vis)->opmansync->deinit(vis)
#define MANSYNC_start(vis)  XLIB_PRIV(vis)->opmansync->start(vis)
#define MANSYNC_stop(vis)   XLIB_PRIV(vis)->opmansync->stop(vis)
#define MANSYNC_ignore(vis) XLIB_PRIV(vis)->opmansync->ignore(vis)
#define MANSYNC_cont(vis)   XLIB_PRIV(vis)->opmansync->cont(vis)

#endif /* _GGI_DISPLAY_X_H */
