/* File "symbols.h":
 * Administrates the name and atoms for each symbol. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

extern value_t symbol_to_value (symbol_t symbol);
/* Return a value that consists of <symbol>. */

extern string_t symbol_name (symbol_t symbol);
/* Return the name of <symbol>. */

extern symbol_t find_symbol (string_t name);
/* Find a symbol by <name> in the symbol table and return its code. */

extern bool_t is_symbol (string_t name);
/* Return whether <symbol> is really a symbol. */

extern symbol_t find_multi_symbol (value_t atom_list);
/* Find the multi-symbol for <atom_list> and return its code. 
 * If there is no multi-symbol for <atom_list>, report an error. */

extern long_t number_of_symbols (void);
/* Return the number of symbols defined. */

extern value_t atoms_of_symbol (symbol_t symbol);
/* Return the list of symbols in the multi-symbol table for <symbol>.
 * If <symbol> is no multi-symbol, return NULL. */

extern void read_symbol_file (string_t file_name);
/* Read symbol table from file <file_name>. */

extern void free_symbol_table (void);
/* Free all memory used by the symbol table. */
