/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_x11video.h,v 1.1 1999/11/23 23:46:25 hercules Exp $";
#endif

#ifndef _SDL_x11video_h
#define _SDL_x11video_h

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#ifdef XFREE86_DGA
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>
#endif

#include "SDL_mouse.h"
#include "SDL_sysvideo.h"

/* Hidden "this" pointer for the video functions */
#define _THIS	SDL_VideoDevice *this

/* Private display data */
struct SDL_PrivateVideoData {
    Display *X11_Display;	/* Used for events and window management */
    Display *GFX_Display;	/* Used for graphics and colormap stuff */
    Window window;		/* Shared by both displays (no X security?) */
    Colormap DisplayColormap;	/* The default display colormap */
    Colormap PrivateColormap;	/* A hidden colormap we create */
    Colormap XColorMap;		/* The current window colormap */
    Atom DELWIN;		/* "close-window" protocol atom */
    WMcursor *BlankCursor;	/* The invisible cursor */
    int XF86_DGA;		/* Flag: true if we can use DGA */
    int MTRR_fd;		/* Descriptor for Memory Type Range Registers */
    char *windowid;		/* Flag: true if we have been passed a window */
    XImage *Ximage;		/* The X image for our window */
    GC	gc;			/* The graphic context for drawing */
    int *XPixels;		/* A list of pixels that have been allocated */
    SDL_Rect **modelist;	/* A list of valid video modes */
    int x11_w, x11_h;		/* The original display resolution */
    int switchable_modes;	/* Flag: true if we can switch modes */
    int swap_pixels;		/* Flag: true if display is swapped endian */
    Uint8 *iconcolors;		/* List of colors used by the icon */

    /* MIT shared memory information */
    int use_mitshm;
    XShmSegmentInfo shminfo;

    /* Private structure to keep track of the video card parameters */
    struct {
	int active;
	int width;
	int lines;
	int page;
	int w, h;
	int flip;
	char *base[2];
    } vinfo;
};
/* Old variable names */
#define SDL_Display		(this->hidden->X11_Display)
#define GFX_Display		(this->hidden->GFX_Display)
#define SDL_Screen		DefaultScreen(this->hidden->X11_Display)
#define SDL_Visual		DefaultVisual(this->hidden->X11_Display, SDL_Screen)
#define SDL_Window		(this->hidden->window)
#define SDL_DisplayColormap	(this->hidden->DisplayColormap)
#define SDL_PrivateColormap	(this->hidden->PrivateColormap)
#define SDL_XColorMap		(this->hidden->XColorMap)
#define SDL_DELWIN		(this->hidden->DELWIN)
#define SDL_BlankCursor		(this->hidden->BlankCursor)
#define SDL_windowid		(this->hidden->windowid)
#define SDL_Ximage		(this->hidden->Ximage)
#define SDL_GC			(this->hidden->gc)
#define SDL_XPixels		(this->hidden->XPixels)
#define SDL_modelist		(this->hidden->modelist)
#define SDL_iconcolors		(this->hidden->iconcolors)
#define shminfo			(this->hidden->shminfo)
#define x11_w			(this->hidden->x11_w)
#define x11_h			(this->hidden->x11_h)
#define vinfo			(this->hidden->vinfo)

/* Used to get the X cursor from a window-manager specific cursor */
extern Cursor SDL_GetWMXCursor(WMcursor *cursor);

#ifdef XFREE86_DGA	/* XFree86 DGA driver bug workarounds */
#define NO_DIRECTMOUSE

#define DGA_BROKEN_VIEWPORT
#ifdef DGA_BROKEN_VIEWPORT
/* This is used to work around a bug in XFree86, in which the viewport
   gets moved when mouse events occur in DGA mode.  It doesn't happen
   on all cards, but..
*/
extern void DGA_FixViewPort(_THIS);
#endif


#endif /* XFREE86_DGA */

#endif /* _SDL_x11video_h */
