/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL.h,v 1.14 1999/06/22 16:44:50 slouken Exp $";
#endif

/* Main include header for the SDL library */

#ifndef _SDL_H
#define _SDL_H

#include "SDL_mangle.h"
#include "SDL_types.h"
#include "SDL_error.h"
#include "SDL_rwops.h"
#include "SDL_timer.h"
#include "SDL_audio.h"
#include "SDL_cdrom.h"
#include "SDL_events.h"
#include "SDL_video.h"
#include "SDL_byteorder.h"
#include "SDL_version.h"

#include "begin_code.h"

/* As of version 0.5, SDL is loaded dynamically into the application */

/* These are the flags which may be passed to SDL_Init() -- you should
   specify the subsystems which you will be using in your application.
*/
#define	SDL_INIT_TIMER		0x00000001
#define SDL_INIT_AUDIO		0x00000010
#define SDL_INIT_VIDEO		0x00000020
#define SDL_INIT_CDROM		0x00000100
#define SDL_INIT_EVENTTHREAD	0x01000000	/* Not supported on all OS's */
#define SDL_INIT_EVERYTHING	0x00FFFFFF

/* This function loads the SDL dynamically linked library and initializes 
 * the subsystems specified by 'flags' (and those satisfying dependencies)
 */
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_Init _SDL_Init
#endif
/**/
extern DECLSPEC int SDL_Init(Uint32 flags);

/* This function cleans up the initialized subsystems and unloads the
 * dynamically linked library.  You should call it upon all exit conditions.
 */
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_Quit _SDL_Quit
#endif
/**/
extern DECLSPEC void SDL_Quit(void);

/* This function allows you to set the library load path before you 
   call SDL_Init().  It only affects the loading of the SDL library.
   Any '/' characters in the pathname will be translated into the native
   directory separator character before used in dynamic library loading.
   This function is a part of load.c, in the static SDL library.
*/
extern void SDL_SetLibraryPath(const char *path);

/* This function is not exported for general use */
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_LockSO _SDL_LockSO
#endif
/**/
extern DECLSPEC int SDL_LockSO(void);

#include "close_code.h"

#endif /* _SDL_H */
