/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_mangle.h,v 1.9 1999/06/07 07:43:51 slouken Exp $";
#endif

#ifndef _SDL_mangle_h
#define _SDL_mangle_h

/* Redefine main() on Win32 and MacOS so that it is called by winmain.c */

#if defined(WIN32) || (defined(__MWERKS__) && !defined(__BEOS__)) || \
    defined(macintosh)

#ifdef __cplusplus
#define C_EXTERN	extern
#define C_LINKAGE	"C"
#else
#define C_EXTERN
#define C_LINKAGE
#endif /* __cplusplus */

/* The application's main() function must be called with C linkage,
   and should be declared like this:
	main(int argc, char *argv[])
	{
	}
 */
#define main	C_EXTERN C_LINKAGE int RunMain

/* The prototype for the application's main() function */
extern C_LINKAGE int RunMain(int argc, char *argv[]);

#endif /* MANGLE_MAIN */

#endif /* _SDL_mangle_h */
