/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_mouse.h,v 1.8 1999/07/15 18:42:02 slouken Exp $";
#endif

/* Include file for SDL mouse event handling */

#ifndef _SDL_mouse_h
#define _SDL_mouse_h

#include "SDL_types.h"
#include "SDL_video.h"

#include "begin_code.h"

typedef struct WMcursor WMcursor;	/* Implementation dependent */
typedef struct {
	SDL_Rect area;			/* The area of the mouse cursor */
	Sint16 hot_x, hot_y;		/* The "tip" of the cursor */
	Uint8 *data;			/* B/W cursor data */
	Uint8 *mask;			/* B/W cursor mask */
	Uint8 *save[2];			/* Place to save cursor area */
	WMcursor *wm_cursor;		/* Window-manager cursor */
} SDL_Cursor;

/* Function prototypes */
/*
 * Retrieve the current state of the mouse.
 * The current button state is returned as a button bitmask, which can
 * be tested using the SDL_BUTTON(X) macros, and x and y are set to the
 * current mouse cursor position.  You can pass NULL for either x or y.
 */
SDL_DEFUN(Uint8, SDL_GetMouseState, (int *x, int *y))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_GetMouseState _SDL_GetMouseState
#endif
/**/

/*
 * Set the position of the mouse cursor (generates a mouse motion event)
 */
SDL_DEFUN(void, SDL_WarpMouse, (Uint16 x, Uint16 y))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_WarpMouse _SDL_WarpMouse
#endif
/**/

/*
 * Create a cursor using the specified data and mask (in MSB format).
 * The cursor width must be a multiple of 8 bits.
 *
 * The cursor is created in black and white according to the following:
 * data  mask    resulting pixel on screen
 *  0     1       White
 *  1     1       Black
 *  0     0       Transparent
 *  1     0       Inverted color if possible, black if not.
 *
 * Cursors created with this function must be freed with SDL_FreeCursor().
 */
SDL_DEFUN(SDL_Cursor *, SDL_CreateCursor,
		(Uint8 *data, Uint8 *mask, int w, int h, int hot_x, int hot_y))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_CreateCursor _SDL_CreateCursor
#endif
/**/

/*
 * Set the currently active cursor to the specified one.
 * If the cursor is currently visible, the change will be immediately 
 * represented on the display.
 */
SDL_DEFUN(void, SDL_SetCursor, (SDL_Cursor *cursor))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_SetCursor _SDL_SetCursor
#endif
/**/

/*
 * Returns the currently active cursor.
 */
SDL_DEFUN(SDL_Cursor *, SDL_GetCursor, (void))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_GetCursor _SDL_GetCursor
#endif
/**/

/*
 * Deallocates a cursor created with SDL_CreateCursor().
 */
SDL_DEFUN(void, SDL_FreeCursor, (SDL_Cursor *cursor))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_FreeCursor _SDL_FreeCursor
#endif
/**/

/*
 * Toggle whether or not the cursor is shown on the screen.
 * The cursor start off displayed, but can be turned off.
 * SDL_ShowCursor() returns 1 if the cursor was being displayed
 * before the call, or 0 if it was not.
 */
SDL_DEFUN(int, SDL_ShowCursor, (int toggle))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_ShowCursor _SDL_ShowCursor
#endif
/**/

/* Used as a mask when testing buttons in buttonstate
   Button 1:	Left mouse button
   Button 2:	Middle mouse button
   Button 3:	Right mouse button
 */
#define SDL_BUTTON(X)	(SDL_PRESSED<<(X-1))

#include "close_code.h"

#endif /* _SDL_mouse_h */
