/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_blit_0.c,v 1.3 1999/02/20 00:54:47 slouken Exp $";
#endif

#include <stdio.h>

#include "SDL_types.h"
#include "SDL_video.h"
#include "SDL_blit.h"

/* Functions to blit from bitmaps to other surfaces */

static void SDL_BlitBto1(SDL_BlitInfo *info)
{
	int c;
	int width, height;
	Uint8 *src, *map, *dst;
	int srcskip, dstskip;
	Uint8 byte, bit;

	/* Set up some basic variables */
	width = info->d_width;
	height = info->d_height;
	src = info->s_pixels;
	srcskip = info->s_skip;
	dst = info->d_pixels;
	dstskip = info->d_skip;
	map = info->table;
	srcskip += width-(width+7)/8;

	if ( map ) {
		while ( height-- ) {
	    		for ( c=0; c<width; ++c ) {
				if ( (c%8) == 0 ) {
					byte = *src++;
				}
				bit = (byte&0x80)>>7;
				if ( 1 ) {
				  *dst = map[bit];
				}
				dst++;
				byte <<= 1;
			}
			src += srcskip;
			dst += dstskip;
		}
	} else {
		while ( height-- ) {
	    		for ( c=0; c<width; ++c ) {
				if ( (c%8) == 0 ) {
					byte = *src++;
				}
				bit = (byte&0x80)>>7;
				if ( 1 ) {
				  *dst = bit;
				}
				dst++;
				byte <<= 1;
			}
			src += srcskip;
			dst += dstskip;
		}
	}
}
static void SDL_BlitBto2(SDL_BlitInfo *info)
{
	int c;
	int width, height;
	Uint8 *src;
	Uint16 *map, *dst;
	int srcskip, dstskip;
	Uint8 byte, bit;

	/* Set up some basic variables */
	width = info->d_width;
	height = info->d_height;
	src = info->s_pixels;
	srcskip = info->s_skip;
	dst = (Uint16 *)info->d_pixels;
	dstskip = info->d_skip/2;
	map = (Uint16 *)info->table;
	srcskip += width-(width+7)/8;

	while ( height-- ) {
	    	for ( c=0; c<width; ++c ) {
			if ( (c%8) == 0 ) {
				byte = *src++;
			}
			bit = (byte&0x80)>>7;
			if ( 1 ) {
				*dst = map[bit];
			}
			byte <<= 1;
			dst++;
		}
		src += srcskip;
		dst += dstskip;
	}
}
static void SDL_BlitBto3(SDL_BlitInfo *info)
{
	int c, o;
	int width, height;
	Uint8 *src, *map, *dst;
	int srcskip, dstskip;
	Uint8 byte, bit;

	/* Set up some basic variables */
	width = info->d_width;
	height = info->d_height;
	src = info->s_pixels;
	srcskip = info->s_skip;
	dst = info->d_pixels;
	dstskip = info->d_skip;
	map = info->table;
	srcskip += width-(width+7)/8;

	while ( height-- ) {
	    	for ( c=0; c<width; ++c ) {
			if ( (c%8) == 0 ) {
				byte = *src++;
			}
			bit = (byte&0x80)>>7;
			if ( 1 ) {
				o = bit * 4;
				dst[0] = map[o++];
				dst[1] = map[o++];
				dst[2] = map[o++];
			}
			byte <<= 1;
			dst += 3;
		}
		src += srcskip;
		dst += dstskip;
	}
}
static void SDL_BlitBto4(SDL_BlitInfo *info)
{
	int width, height;
	Uint8 *src;
	Uint32 *map, *dst;
	int srcskip, dstskip;
	int c;
	Uint8 byte, bit;

	/* Set up some basic variables */
	width = info->d_width;
	height = info->d_height;
	src = info->s_pixels;
	srcskip = info->s_skip;
	dst = (Uint32 *)info->d_pixels;
	dstskip = info->d_skip/4;
	map = (Uint32 *)info->table;
	srcskip += width-(width+7)/8;

	while ( height-- ) {
	    	for ( c=0; c<width; ++c ) {
			if ( (c%8) == 0 ) {
				byte = *src++;
			}
			bit = (byte&0x80)>>7;
			if ( 1 ) {
				*dst = map[bit];
			}
			byte <<= 1;
			dst++;
		}
		src += srcskip;
		dst += dstskip;
	}
}

static SDL_loblit bitmap_blit[] = {
	NULL, SDL_BlitBto1, SDL_BlitBto2, SDL_BlitBto3, SDL_BlitBto4
};
static SDL_loblit complex_blit[] = {
	NULL, SDL_BlitKey, SDL_BlitAlpha, SDL_BlitAlphaKey
};

SDL_loblit SDL_CalculateBlit0(SDL_Surface *surface, int complex)
{
	int which;

	if ( surface->map->dst->format->BitsPerPixel < 8 ) {
		which = 0;
	} else {
		which = surface->map->dst->format->BytesPerPixel;
	}
	if ( complex ) {
		return(complex_blit[complex]);
	} else {
		return(bitmap_blit[which]);
	}
}
