/*
 * Copyright (c) 1994 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/* Tcl_LdapModRDNCmd - simple function to modify an entry's RDN using LDAP */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <lber.h>
#include <ldap.h>
#include "tcl.h"

extern int ldcnt;
extern LDAP *ldprime[1024];

int Tcl_LdapModRDNCmd (dummy, interp, argc, argv)
     ClientData dummy;
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
    char *dn, *rdn;
    int rc, replace, conn;

    if (argc < 5) {
	Tcl_AppendResult (interp, "Usage: \n", (char *) NULL);
	Tcl_AppendResult (interp, argv[0], " LdapConn DN RDN ", (char *) NULL);
	Tcl_AppendResult (interp, "ReplaceFlag(1=replace,0=add)", (char *) NULL);
	return TCL_ERROR;
    }

    conn = atoi (argv[1]);
    dn = argv[2];
    rdn = argv[3];
    replace = atoi (argv[4]);
    if (conn > ldcnt || conn < 0) {
	Tcl_AppendResult (interp, "Invalid connection number!", (char *) NULL);
	return TCL_ERROR;
    }

    ldprime[conn]->ld_deref = LDAP_DEREF_NEVER;		/* Turn off aliasing */

    if ((rc = ldap_modrdn2_s (ldprime[conn], dn, rdn, replace)) != LDAP_SUCCESS) {
	Tcl_AppendResult (interp, "Unable to rename entry!", (char *) NULL);
	return TCL_ERROR;
    } else {
	Tcl_AppendResult (interp, "Entry renamed!", (char *) NULL);
	return TCL_OK;
    }
}
