NAME
     wncmp -- comparison functions for sorting and sorted trees.

SYNOPSIS
     #include "wncmp.h"

     int wn_intcmp(int i1,int i2)

     int wn_ptrcmp(ptr p1,ptr p2)

     int wn_ptrNULLcmp(bool &success,ptr p1,ptr p2)

     int wn_boolcmp(bool b1,bool b2)

     int wn_doublecmp(double d1,double d2)

     int wn_pdoublecmp(double *pd1,double *pd2)

     int wn_numstrcmp(char s1[],s2[])

     int wn_memcmp(ptr m1,ptr m2,int len)

DESCRIPTION
     These routines are designed to assist in sorting (see wnsort) and in
     building sorted trees (see wnbtr).  They return an int
     >, ==, or < than zero, according to whether arg 1 is >, ==, or <
     than arg 2.

     "wn_numstrcmp" compares strings "s1" that "s2" so that the intuitively
     correct notion of numerical order is respected.  Thus, the
     string "var9" is < "var10", according to "wn_numstrcmp".
     Similarly, "var99" < "var100", "x99y" < "x200y", etc.

     "wn_ptrNULLcmp" sets "success" to TRUE iff "p1" or "p2" is NULL.
     If "p1" and "p2" are NULL, it returns 0.  If "p1" is NULL but
     "p2" is not NULL, it returns a number < 0.  If "p1" is not NULL but
     "p2" is NULL, it returns a number > 0.  This function is useful for
     constructing complicated linked structure compares where it is possible
     for some pointers to be NULL.

DIAGNOSTICS
  
BUGS

SEE ALSO
     wnsort, wnbtr, wnbtrl, wnhtbl, wncpy

AUTHOR
     Will Naylor

