if {[catch {set imDebug}]} {
    set imDebug 0
}

bind imConfig <Configure> {
    if {[string compare [focus] "%W"] == 0} {
	tkConfigIm %W 1
    }
}
bind imConfig <Destroy> {
    global tkPriv
    unset tkPriv(haveConfigHandler:%W)
}

proc tkAddConfigImHandler {path} {
    set tags [bindtags $path]
    if {[lsearch $tags imConfig] < 0} {
	bindtags $path "imConfig $tags"
    }
}

foreach i "Text Entry" {
    bind $i <FocusIn> {
	tkConfigIm %W
	global tkPriv
	if {[catch {set tkPriv(haveConfigHandler:%W)}]} {
	    set tkPriv(haveConfigHandler:%W) 1
	    tkAddConfigImHandler %W
	}
    }
}
unset i

proc tkGetPreferredIMInputStyle {prefStyle supportedStyle} {
    foreach i $prefStyle {
	if {[lsearch $supportedStyle $i] >= 0} {
	    return $i
	}
    }
    return ""
}


proc tkInitializeIMInputStyle {path} {
    global tkPriv
    set class [winfo class $path]
    set scrn [winfo screen $path]
    set key ${scrn}/IMStyles
    
    set sList ""
    if {[catch {set sList $tkPriv(${key})}] == 1} {
	catch {set sList [imconfigure $path -supportedStyle]}
	set tkPriv(${key}) $sList
    }
    if {[string length $sList] <= 0} {
	puts stderr "Warning: No input method server is available."
	return ""
    }

    set style ""
    catch {set style $tkPriv(${key}:${class})}
    if {[string length $style] > 0} {
	if {[string comapre "none" [lindex $style 0]] == 0} {
	    puts stderr "Warning: The input method server can't handle: [lindex $style 1]"
	    return ""
	} else {
	    return $style
	}
    }

    set userPref [option get . tkPreferredImStyle($class) *]
    if {[string length $userPref] > 0} {
	set style [tkGetPreferredIMInputStyle $userPref $sList]
	if {[string length $style] > 0} {
	    set tkPriv(${key}:${class}) $style
	    return $style
	} else {
	    set tkPriv(${key}:${class}) [list none $userPref]
	    puts stderr "Warning: The input method server can't handle style: {$userPref}"
	    return ""
	}
    } else {
	switch "$class" {
	    "Text" {
		set userPref [list "PreeditPosition StatusArea" "PreeditPosition StatusNothing" "PreeditArea StatusArea" "PreeditNothing StatusNothing"]
	    }
	    "Entry" {
		set userPref [list "PreeditPosition StatusNothing" "PreeditNothing StatusNothing"]
	    }
	    default {
		set userPref [list "PreeditPosition StatusArea" "PreeditPosition StatusNothing" "PreeditArea StatusArea" "PreeditNothing StatusNothing"]
	    }
	}
	set style [tkGetPreferredIMInputStyle $userPref $sList]
	if {[string length $style] > 0} {
	    set tkPriv(${key}:${class}) $style
	    return $style
	} else {
	    set tkPriv(${key}:${class}) [list none $userPref]
	    puts stderr "Warning: The input method server can't handle: {$userPref}"
	    return ""
	}
    }
    return ""
}


proc tkGetIMInputStyle {path} {
    global tkPriv
    set class [winfo class $path]
    set scrn [winfo screen $path]
    set key ${scrn}/IMStyles
    set style ""
    if {[catch {set style $tkPriv(${key}:${class})}]} {
	tkInitializeIMInputStyle $path
	set style ""
	catch {set style $tkPriv(${key}:${class})}
    }
    return $style
}


proc tkCleanIMInputStyle {path} {
    global tkPriv
    set class [winfo class $path]
    set scrn [winfo screen $path]
    set key ${scrn}/IMStyles
    if {[catch {set tkPriv(${key}:${class})}]} {
	return
    } else {
	catch {unset tkPriv($key)}
	catch {unset tkPriv(${key}:${class})}
    }
}


proc tkConfigIm {path {force 0}} {
    global imDebug

    set stat ""
    catch {set stat [imconfigure $path -status]}
    if {[string length $stat] <= 0} {
	tkCleanIMInputStyle $path
	return
    }
    set started 0
    if {$imDebug == 1 || $force == 1} {
	set ret "imconfigure $path -force"
    } else {
	set ret "imconfigure $path"
    }
    set style ""
    if {[string compare $stat "never"] == 0} {
	set style [tkGetIMInputStyle $path]
	if {[string length $style] <= 0} {
	    return
	}
	append ret " -style {$style}"
    } else {
	set style [imconfigure $path -style]
	set started 1
    }

    set fg ""
    set bg ""
    set font ""
    set spot ""

    set preedit [lindex $style 0]
    set status [lindex $style 1]
    set doStatusArea 0
    if {[string compare $status "StatusArea"] == 0} {
	set doStatusArea 1
    }

    if {$imDebug == 0} {
	if {[catch {set fg [$path cget -fg]}]} {
	    set fg black
	}
	if {[catch {set bg [$path cget -bg]}]} {
	    set bg white
	}
    } else {
	set fg red
	set bg blue
    }
    
    if {[string compare $preedit "PreeditArea"] == 0 && $doStatusArea == 1} {
	append ret " -foreground {$bg} -background {$fg}"
    } else {
	append ret " -foreground {$fg} -background {$bg}"
    }
    
    if {[catch {set font [$path cget -font]}]} {
	set font Mincho:Courier-12
    }
    append ret " -font {$font}"

    if {$started == 0} {
	if {[catch {eval $ret} msg]} {
            puts stderr "$msg"
	    return
	}
	if {$imDebug == 1 || $force == 1} {
	    set ret "imconfigure $path -force"
	} else {
	    set ret "imconfigure $path"
	}
    }
    
    set bo [expr [$path cget -bo] + [$path cget -highlightthickness]]
    set w [expr [winfo width $path] - $bo * 2]
    set h [expr [winfo height $path] - $bo * 2]
    set fontH [expr [font metrics $font -ascent] + [font metrics $font -descent]]
    set spotX $bo
    set spotY $fontH
    set stH $fontH
    set stW [expr $fontH * 3]
    if {$doStatusArea == 1} {
	set spArea ""
	catch {set spArea [imconfigure $path -preferredStatusArea]}
	if {[string length $spArea] > 0} {
	    set pstW [lindex $spArea 2]
	    set pstH [lindex $spArea 3]
	    if {$pstW > 0 && $pstH > 0} {
		if {[expr ${w}.0 / ${pstW}.0] <= 5.0} {
		    set pstW [expr $pstH * 3]
		}
		set stW $pstW
		set stH $pstH
	    }
	}
    }
    
    switch "$preedit" {
	"PreeditPosition" {
	    catch {set spot [$path xypos insert]}
	    if {[string length $spot] > 0} {
		set spotX [lindex $spot 0]
		set spotY [lindex $spot 1]
	    }
	    append ret " -spot {$spotX $spotY} -preeditArea {$bo $bo $w $h}"
	    if {$doStatusArea == 1} {
		set stY [expr $spotY + $bo]
		append ret " -statusArea {$spotX $stY $stW $stH}"
	    }
	}

	"PreeditArea" {
	    switch "$status" {
		"StatusNothing" {
		    append ret " -preeditArea {$bo $bo $w $h}"
		}
		"StatusArea" {
		    set H [expr $h - $stH + $bo]
		    set pX [expr $bo + $stW]
		    set pW [expr $w - $pX + $bo]
		    append ret " -preeditArea {$pX $H $pW $stH} -statusArea {$bo $H $stW $stH}"
		}
	    }
	}
    }
    if {[catch {eval $ret} msg]} {
        puts stderr $msg
    }
}


# tkEntryBackspace -- redefine.
# Backspace over the character just before the insertion cursor.
# If backspacing would move the cursor off the left edge of the
# window, reposition the cursor at about the middle of the window.
#
# Arguments:
# w -		The entry window in which to backspace.

proc tkEntryBackspace w {
    if {[$w selection present]} {
	$w delete sel.first sel.last
    } else {
	set x [expr {[$w index insert] - 1}]
	if {$x >= 0} {$w delete $x}
	if {[$w index @0] >= [$w index insert]} {
	    set range [$w xview]
	    set left [lindex $range 0]
	    set right [lindex $range 1]
	    $w xview moveto [expr {$left - ($right - $left)/2.0}]
	}
    }
    tkEntrySeeInsert $w
}


# tkEntrySeeInsert -- redefine.
# Make sure that the insertion cursor is visible in the entry window.
# If not, adjust the view so that it is.
#
# Arguments:
# w -           The entry window.

proc tkEntrySeeInsert w {
    set c [$w index insert]
    set left [$w index @0]
    if {$left > $c} {
        $w xview $c
	tkConfigIm $w
        return
    }
    set x [winfo width $w]
    while {([$w index @$x] <= $c) && ($left < $c)} {
        incr left
        $w xview $left
    }
    tkConfigIm $w
}


# tkTextInsert -- redefine.
# Insert a string into a text at the point of the insertion cursor.
# If there is a selection in the text, and it covers the point of the
# insertion cursor, then delete the selection before inserting.
#
# Arguments:
# w -           The text window in which to insert the string
# s -           The string to insert (usually just a single character)

proc tkTextInsert {w s} {
    if {($s == "") || ([$w cget -state] == "disabled")} {
        return
    }
    catch {
        if {[$w compare sel.first <= insert]
                && [$w compare sel.last >= insert]} {
            $w delete sel.first sel.last
        }
    }
    $w insert insert $s
    $w see insert
    tkConfigIm $w
}


# tkTextSetCursor - redefine.
# Move the insertion cursor to a given position in a text.  Also
# clears the selection, if there is one in the text, and makes sure
# that the insertion cursor is visible.  Also, don't let the insertion
# cursor appear on the dummy last line of the text.
#
# Arguments:
# w -		The text window.
# pos -		The desired new position for the cursor in the window.

proc tkTextSetCursor {w pos} {
    if [$w compare $pos == end] {
	set pos {end - 1 chars}
    }
    $w mark set insert $pos
    $w tag remove sel 1.0 end
    $w see insert
    tkConfigIm $w
}

bind Text <1> {
    tkTextButton1 %W %x %y
    %W tag remove sel 0.0 end
    tkTextSetCursor %W insert
}

bind Text <Delete> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
	%W delete sel.first sel.last
	tkTextSetCursor %W insert
    } else {
	tkTextSetCursor %W insert-1c
	%W delete insert
	%W see insert
    }
}

bind Text <Control-h> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
	%W delete sel.first sel.last
	tkTextSetCursor %W insert
    } else {
	tkTextSetCursor %W insert-1c
	%W delete insert
	%W see insert
    }
}

bind Text <BackSpace> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
	%W delete sel.first sel.last
	tkTextSetCursor %W insert
    } else {
	tkTextSetCursor %W insert-1c
	%W delete insert
	%W see insert
    }
}

bind Text <Return> {
    tkTextInsert %W \n
    tkTextSetCursor %W insert
}
