/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef NOTEBOOK_H
#define NOTEBOOK_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>
#include <vdk/vdkprops.h>
extern char *book_open_xpm[];
extern char *book_closed_xpm[];

class VDKPixmap;
class VDKLabel;
class VDKBox;
class VDKForm;
class VDKNotebook;
class PageList;
class VDKTabPage;
typedef VDKList<VDKTabPage> PList;
typedef VDKListiterator<VDKTabPage> PListIterator;

/*
*/
typedef VDKReadWriteValueProp<VDKNotebook,int> NoteBookIntProp;

class ActivePageProperty: public NoteBookIntProp
{

public:
  ActivePageProperty();
  ActivePageProperty(
		     char* name,
		     VDKNotebook* object,
		     void (VDKNotebook::*write)(int) = NULL,
		     int (VDKNotebook::*read)(void) = NULL
		     );
  virtual ~ActivePageProperty();
  operator int();
  void operator=(int page);
  void operator++();
  void operator--();
  void operator++(int);
  void operator--(int);
};

/*
 */
class NotebookTabPosProperty: public NoteBookIntProp
{

public:
  NotebookTabPosProperty();
  NotebookTabPosProperty(
			 char* name,
			 VDKNotebook* object,
			 void (VDKNotebook::*write)(int) = NULL,
			 int (VDKNotebook::*read)(void) = NULL
			 );
  virtual ~NotebookTabPosProperty();
  void operator = (int pos);
};
/*
 */
class VDKTabPage
{
  
  GtkWidget /**label_wid,*/*tab;
  GdkPixmap *open;
  GdkPixmap *closed;
  GdkBitmap *open_mask;
  GdkBitmap *closed_mask;
  friend class PageList;
  friend class VDKNotebook;
  VDKObject* child;
  VDKObject* book;
 public:
 
  // properties
  //VDKObject*  TabLabel; // the tab label
  VDKLabel*  TabLabel; // the tab label
  VDKTabPage(VDKObject* owner,
	     VDKObject* child,
	     char *label,
	     char **pixmap_closed,
	     char **pixmap_open);
  virtual ~VDKTabPage() {}
};
/*
 */
class PageList: PList
{
  friend class VDKNotebook;
  VDKNotebook *book;
 public:
  PageList(VDKNotebook* book = NULL): PList(), book(book) {}
  ~PageList();
  void AddPage(VDKObject* child,
	       char *label,
	       char **pixmap_closed,
	       char **pixmap_open);
  // operator substitution
  VDKTabPage* operator[](int n);
  int size() { return PList::size() ; }
};
/*
 */
class VDKNotebook: public VDKObjectContainer 
{
  static void PageSwitch(GtkWidget *widget, 
				      GtkNotebookPage *page,
				      int pagenum,
				      gpointer gp);
 protected:

public:
  // properties
  PageList Pages; // run-time read only
  ActivePageProperty ActivePage;
  NotebookTabPosProperty TabPosition;
  VDKReadWriteValueProp<VDKNotebook,bool> Scrollable;
  VDKReadWriteValueProp<VDKNotebook,bool> PopUp;
  VDKReadOnlyValueProp<VDKNotebook,int> PreviousActivePage;
  //
  VDKNotebook(VDKForm* owner = NULL);
  virtual ~VDKNotebook();
  void Add(VDKObject* obj, int , int , int , int )
      { AddPage(obj,""); }
  void AddPage(VDKObject* obj,
	       char *label,
	       char **pixmap_closed = NULL,
	       char **pixmap_open = NULL);
  void RemovePage(int page);
  bool GetScrollable()
    { return Scrollable; }
  void SetScrollable(bool flag)
    { 
      gtk_notebook_set_show_tabs (GTK_NOTEBOOK(widget), flag);
      gtk_notebook_set_scrollable (GTK_NOTEBOOK(widget), flag);
    }
  bool GetPopUp()
    { return PopUp; }
  void SetPopUp(bool flag)
    { 
      if (flag)
	gtk_notebook_popup_enable (GTK_NOTEBOOK(widget));
      else
	gtk_notebook_popup_disable (GTK_NOTEBOOK(widget));
    }
  int GetPreviousActivePage()
    { return gtk_notebook_current_page(GTK_NOTEBOOK(widget)); }
};
#endif


