/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * Revision 0.4.2
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdk_grid_h
#define _vdk_grid_h
#include <vdk/vdkobj.h>
#include <vdk/gtksheet.h>
#include <vdk/gtkitementry.h>
#include <vdk/vdkstring.h>
#include <vdk/vdkarray.h>
#include <vdk/vdkutils.h>
#define  FIT_COLUMN_WIDTH  0
#define  FIT_ROW_HEIGHT    0
enum
{
grid_select_cell = 1024,
grid_unselect_cell,
grid_changed_cell,
grid_select_row,
grid_select_column,
grid_hor_scrolled,
grid_vert_scrolled
};

class VDKForm;
class VDKGrid;
#ifndef _string_array_def
typedef VDKArray<VDKString> StringArray;
#endif
///////////// VDKCELL CLASS ///////////////////////
class VDKGridCell
{
  // properties
 public:
  __rwproperty(VDKGridCell, VDKString)        Text;
  __rwproperty(VDKGridCell, GtkJustification) Align;
  __rproperty(VDKGridCell, VDKObject*)        AttachedWidget;
 protected:
  friend class VDKGrid;
  GtkSheet* sheet;
  VDKObject* grid;
  int row,col;
  void SetText(VDKString text)
    { 
      if (sheet)
	  gtk_sheet_set_cell(sheet,row,col,Align,(char*) text); 
    }
  void SetAlign(GtkJustification j)
    {
      if(GTK_WIDGET_VISIBLE(sheet))
	{
	  VDKString s = Text;
	  gtk_sheet_set_cell(sheet,row,col,j,(char*) s);
	}
    }
 public:
  VDKGridCell(GtkSheet *sheet, int row, int col):
    Text("Text",this,VDKString(NULL),&VDKGridCell::SetText),
    Align("Align",this,GTK_JUSTIFY_LEFT,&VDKGridCell::SetAlign),
    AttachedWidget("AttachedWidget",this, NULL),
    sheet(sheet),row(row),col(col){}
  virtual ~VDKGridCell() {}
  void SetBackground(VDKRgb& rgb);
  void SetForeground(VDKRgb& rgb);
  void Attach(VDKObject* object,float x_align, float y_align);
  int Row() { return row; }
  int Column() { return col; }
  void SetBorder(int mask, int width, int line_style);
}; 
///////////////// ROW/COLUMN CLASS //////////////
class VDKGridSlice
{

 protected:
  friend class VDKGrid;
  GtkSheet* sheet;
 public:
  VDKGridSlice(GtkSheet *sheet):sheet(sheet){}
  virtual ~VDKGridSlice() {}
  void SetRangeForeground(VDKRgb& rgb,GtkSheetRange& range);
  void SetRangeBackground(VDKRgb& rgb,GtkSheetRange& range);
};

class VDKGridColumn : public VDKGridSlice
{
 public:
  // properties
  __rwproperty(VDKGridColumn, VDKString) Title;
  __rwproperty(VDKGridColumn, int)       Width;
  __rwproperty(VDKGridColumn, bool)      Enabled;
  __rwproperty(VDKGridColumn, VDKRgb)  Background;
  __rwproperty(VDKGridColumn, VDKRgb)  Foreground;
  __rwproperty(VDKGridColumn, bool)    Visible;
 protected:
  friend class VDKGrid;
  int col;
  void SetTitle(VDKString s) 
    {
      gtk_sheet_column_button_add_label(sheet,col, (char*) s);
    }
  VDKString GetTitle()
    {
      VDKString p(sheet->column[col].button.label);
      return p;
    }
  int  GetWidth() { return sheet->column[col].width; }
  void SetWidth(int w);
  void SetEnabled(bool f)
    {
      gtk_sheet_column_set_sensitivity(sheet,col,f);
    }
  void SetVisible(bool flag)
    {
      gtk_sheet_column_set_visibility	(sheet, col, flag);
    }
  void SetForeground(VDKRgb c);
  void SetBackground(VDKRgb c);
 public:
  VDKGridColumn(GtkSheet *sheet,int col):
    VDKGridSlice(sheet),
    Title("Title",this,
	  VDKString(""),&VDKGridColumn::SetTitle,&VDKGridColumn::GetTitle),
    Width("Width",this,0,&VDKGridColumn::SetWidth,&VDKGridColumn::GetWidth),
    Enabled("Enabled",this,false,&VDKGridColumn::SetEnabled),
    Background("Background",this,
	       VDKRgb(0,0,0),&VDKGridColumn::SetBackground),
    Foreground("Foreground",this,
	       VDKRgb(0,0,0),&VDKGridColumn::SetForeground),
    Visible("Visible",this,false,&VDKGridColumn::SetVisible),
    col(col)
    {}
  virtual ~VDKGridColumn() {};
};
/*
 */
class VDKGridRow : public VDKGridSlice
{
 public:
  // properties
  __rwproperty(VDKGridRow, VDKString) Title;
  __rwproperty(VDKGridRow, int)       Height;
  __rwproperty(VDKGridRow, bool)  Visible;
  __rwproperty(VDKGridRow, bool)  Enabled;
 protected:
  friend class VDKGrid;
  int row;
  void SetTitle(VDKString s) 
    {
      gtk_sheet_row_button_add_label(sheet, row, (char*) s);
    }
  VDKString GetTitle()
    {
      VDKString p(sheet->row[row].button.label);
      return p;
    }    
  void SetVisible(bool flag)
    {
      gtk_sheet_row_set_visibility(sheet, row, flag);
    }
  void SetEnabled(bool f)
    {
      gtk_sheet_row_set_sensitivity(sheet,row,f);
    }
  void SetHeight(int w);
  int  GetHeight() { return sheet->row[row].height; }
 public:
  VDKGridRow(GtkSheet* sheet, int row):
    VDKGridSlice(sheet),
    Title("Title",this,
	  VDKString(""),&VDKGridRow::SetTitle,&VDKGridRow::GetTitle),
    Height("Height",this,0,&VDKGridRow::SetHeight,&VDKGridRow::GetHeight),
    Visible("Visible",this,false,&VDKGridRow::SetVisible),
    Enabled("Enabled",this,false,&VDKGridRow::SetEnabled),
    row(row) 
    {}
  virtual ~VDKGridRow() {};
};

////////////////////////////////////
class VDKGrid: public VDKObject
{
 private:
  VDKGridCell* aCell;
  VDKGridColumn* aColumn;
  VDKGridRow *aRow;
 public:
   // properties
  __rproperty(VDKGrid,VDKGridCell*) ActiveCell;
  __rproperty(VDKGrid,VDKGridCell*) PreviousActiveCell;
  __rproperty(VDKGrid,VDKGridCell*) ChangedCell;
  __rproperty(VDKGrid, int)     SelectedRow;
  __rproperty(VDKGrid, int)     SelectedColumn;
  __rwproperty(VDKGrid, bool)   RowTitleVisible;
  __rwproperty(VDKGrid, bool)   ColumnTitleVisible;
  __rproperty(VDKGrid,int)      MaxRows;
  __rproperty(VDKGrid,int)      MaxColumns;
 protected:
  static int ActivateCell(GtkWidget*, int row, int col, gpointer);
  static int DeactivateCell(GtkWidget*, int row, int col, gpointer);
  static int OnChangedCell(GtkWidget* wid, int row, int col, gpointer gp);
  static void SelectRow(GtkWidget* , int, gpointer );
  static void SelectColumn(GtkWidget* , int, gpointer );
  static void HAdjChanged(GtkWidget* wid, gpointer gp);
  static void VAdjChanged(GtkWidget* wid, gpointer gp);
  virtual void    SetForeground(VDKRgb color, 
				GtkStateType state = GTK_STATE_NORMAL);
  virtual void    SetBackground(VDKRgb color, 
				GtkStateType state = GTK_STATE_NORMAL);
  void SetRowTitleVisible(bool flag)
    {
      if(flag)
	gtk_sheet_show_row_titles(GTK_SHEET(widget));
      else
	gtk_sheet_hide_row_titles(GTK_SHEET(widget));
    }
  void SetColumnTitleVisible(bool flag)
    {
      if(flag)
	gtk_sheet_show_column_titles(GTK_SHEET(widget));
      else
	gtk_sheet_hide_column_titles(GTK_SHEET(widget));
    }
  int GetMaxRows() { return GTK_SHEET(widget)->maxrow+1; }
  int GetMaxColumns() { return GTK_SHEET(widget)->maxcol+1; }

 public:
  VDKGrid(VDKForm* owner, int row, int cols, bool editable = false,
	  char* title = "title");
  virtual ~VDKGrid() 
    {
      if(aCell)
	delete aCell;
    }
  VDKGridCell* Cell(int row, int col);
  VDKGridCell* Cell(VDKPoint p)
    {
      return Cell(p.X(),p.Y());
    }
  VDKGridColumn* Column(int col);
  VDKGridRow* Row(int row);
  void Clear()
    { gtk_sheet_range_clear(GTK_SHEET(widget), NULL); }

  void AddRow(StringArray& array);

  void AddBlankRows(int n);

  void Flush()
    { gtk_sheet_delete_rows(GTK_SHEET(widget),0,
			    GTK_SHEET(widget)->maxrow); }
  virtual void Setup();
};

#endif




 
