/*
 * File:	WIN_glcanvas.cc
 * Purpose:	wxWindows interface for OpenGL using the GLX extension
 * Author:	Wolfram Gloger (adapted from J. Smart's Windows version)
 * Created:	1995
 * Updated:	Jul 1996, for wx-Xt 1.65 (WG)
 * Updated:	Jul 1997, for wx-Xt 1.66c (WG)
 */

#define	Uses_XtIntrinsic
#define Uses_GLCanvas
#include "wx.h"

#define Uses_EnforcerWidget
/*#define Uses_ShellWidget*/
#include "widgets.h"

#include "GLwDrawA.h"

// simplify setting of args
#define SET_ARG(n, v) args[args_i].name = (n);\
                      args[args_i++].value = (XtArgVal)(v);

/*
 * GLCanvas implementation
 */

wxGLCanvas::wxGLCanvas(wxWindow* parent, int x, int y, int w, int h,
					   int style, Constdata char* name, int* attrib_list,
					   wxColourMap* colour_map, Bool direct,
					   const wxGLCanvas* shareList):
wxItem()
{
	__type = wxTYPE_GL_CANVAS;

	glx_cx  = 0;
	is_rgba = FALSE;
	gl_cmap = 0;

	Create(parent, x, y, w, h, style, name, attrib_list, colour_map,
		   direct, shareList);
}

Bool
wxGLCanvas::Create(wxWindow* panel, int x, int y, int w, int h,
				   int style, Constdata char* name, int* attrib_list,
				   wxColourMap* colour_map, Bool direct,
				   const wxGLCanvas* shareList)
{
	Display* display = wxGetDisplay();
	XVisualInfo* vi = 0;

	if (!panel || !panel->IsKindOf(CLASSINFO(wxPanel)))
		wxFatalError("parent has to be a wxFrame, wxPanel, or any subtype",
					 "wxGLCanvas");

	ChainToPanel((wxPanel*)panel, style, name);

	// create frame
	FWidget() = XtVaCreateManagedWidget
		("Enforcer", xfwfEnforcerWidgetClass, GetParentWidget(parent),
		 XtNalignment,          XfwfTop,
		 XtNbackground,         bg.GetPixel(&cmap),
		 XtNforeground,         label_fg.GetPixel(&cmap),
		 XtNfont,               label_font.GetInternalFont(),
		 XtNhighlightThickness, 2,
		 XtNlabelOffset,        2,
		 XtNtraversalKeys,      XfwfTraverseKeyTab,
		 NULL);

	// check for the presence of the GLX extension
	if(!glXQueryExtension(display, NULL, NULL)) {
		wxDebugMsg("wxGLCanvas: GLX extension is missing\n");
		return FALSE;
	}

	// create GL drawing area
	Arg args[4]; int args_i = 0;
	SET_ARG(XtNborderWidth, 0);
	SET_ARG(GLwNattribList, attrib_list);
	if(colour_map) {
		gl_cmap = colour_map;
		SET_ARG(XtNcolormap, colour_map->GetColormap());
		SET_ARG(GLwNcreateColormap, False);
	}
	HWidget() = XtCreateManagedWidget
		(name, glwDrawingAreaWidgetClass, FWidget(), args, args_i);

	((wxPanel*)panel)->PositionItem(this, x, y, w, h);
	AddEventHandlers();

	// Create the GLX context
	XtVaGetValues(HWidget(), GLwNvisualInfo, &vi, NULL);
	if(!vi) {
		wxDebugMsg("wxGLCanvas: can't get visual info\n");
		return FALSE;
	}
	//fprintf(stderr, "visual=0x%x depth=%d\n", (int)vi->visualid, vi->depth);
	glx_cx = glXCreateContext(display, vi,
							  shareList ? shareList->glx_cx : 0,
							  direct ? GL_TRUE : GL_FALSE);

	return TRUE;
}

wxGLCanvas::~wxGLCanvas()
{
	if(glx_cx)
		glXDestroyContext(wxGetDisplay(), glx_cx);
}

void
wxGLCanvas::SwapBuffers()
{
	if(glx_cx)
		GLwDrawingAreaSwapBuffers(HWidget());
}

int
wxGLCanvas::SetCurrent()
{
	if(!glx_cx || !XtWindow(HWidget()))
		return -1;
	GLwDrawingAreaMakeCurrent(HWidget(), glx_cx);
	glGetBooleanv(GL_RGBA_MODE, &is_rgba);
	return 0;
}

void
wxGLCanvas::SetColour(const char* col)
{
	wxColour *the_colour = wxTheColourDatabase->FindColour(col);
	if(the_colour) {
		if(IsRGBA()) {
			glColor3ub(the_colour->Red(),
					   the_colour->Green(),
					   the_colour->Blue());
		} else {
			GLint pix = (GLint)the_colour->GetPixel(gl_cmap ? gl_cmap: &cmap);
			// GetPixel() can't fail in wx-Xt (maybe returns black).
			//cerr << "col=" << col << " pix=" << (int)pix << endl;
			glIndexi(pix);
		}
	}
}

void
wxGLCanvas::AfterRealize()
{
}

Bool
wxGLCanvas::HaveVisual(int* attrib_list)
{
	XVisualInfo* vi;

	vi = glXChooseVisual(wxGetDisplay(), XScreenNumberOfScreen(wxAPP_SCREEN),
						 attrib_list);
	if(!vi)
		return FALSE;
	XFree(vi);
	return TRUE;
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
