/*								-*- C++ -*-
 * $Id: WIN_button.cpp,v 1.2 1997-01-15 14:58:55+01 mho Exp $
 *
 * Purpose: button panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_button.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxButton
#include "wx.h"
#define  Uses_ButtonWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy button
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxButton, wxItem)

wxButton::wxButton(void) : wxItem()
{
    __type = wxTYPE_BUTTON;

    isBitmap = FALSE;
}

wxButton::wxButton(wxPanel *panel, wxFunction function, Const char *label,
		   int x, int y, int width, int height,
		   long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_BUTTON;

    Create(panel, function, label, x, y, width, height, style, name);
}

wxButton::wxButton(wxPanel *panel, wxFunction function, wxBitmap *bitmap,
		   int x, int y, int width, int height,
		   long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_BUTTON;

    Create(panel, function, bitmap, x, y, width, height, style, name);
}

wxButton::wxButton(wxPanel *panel, wxFunction function, wxBitmap& bitmap,
		   int x, int y, int width, int height,
		   long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_BUTTON;

    Create(panel, function, bitmap, x, y, width, height, style, name);
}

Bool wxButton::Create(wxPanel *panel, wxFunction function, Const char *label,
		      int x, int y, int width, int height,
		      long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    Boolean border = !(style & wxNO_BORDER);	// is there a border around the button
    int     margin = (border ? 4 : 0);		// margin around the label
    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfButtonWidgetClass, GetParentWidget(parent),
	 XtNlabel,       	label,
	 XtNbackground,  	bg.GetPixel(&cmap),
	 XtNforeground,  	fg.GetPixel(&cmap),
	 XtNfont,        	font.GetInternalFont(),
	 XtNshrinkToFit, 	(width < 0 || height < 0),
	 XtNhighlightThickness, margin/2,
	 XtNtraversalOn, 	border,
	 XtNleftMargin, 	margin,
	 XtNrightMargin,        margin,
	 XtNtopMargin,          margin,
	 XtNbottomMargin,       margin,
	 NULL);
    // set data declared in wxItem
    callback = function;
    XtAddCallback(HWidget(), XtNactivate, wxButton::EventCallback, (XtPointer)this);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();
    AllowResize(FALSE);

    isBitmap = FALSE;
    return TRUE;
}

Bool wxButton::Create(wxPanel *panel, wxFunction function, wxBitmap *bitmap,
		      int x, int y, int width, int height,
		      long style, Constdata char *name)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxButton::Create");
	return Create(panel, function, "ERROR", x, y, width, height, style, name);
    } 
    return Create(panel, function, *bitmap, x, y, width, height, style, name);
}

Bool wxButton::Create(wxPanel *panel, wxFunction function, wxBitmap& bitmap,
		      int x, int y, int width, int height,
		      long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    // check bitmap
    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxButton::Create");
	return Create(panel, function, "ERROR", x, y, width, height, style, name);
    }
    bmp = bitmap;
    Boolean border = !(style & wxNO_BORDER);	// is there a border around the button
    int     margin = (border ? 4 : 0);		// margin around the label
    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfButtonWidgetClass, GetParentWidget(parent),
	 XtNpixmap,      	bitmap.GetPixmap(),
	 XtNmask,        	bitmap.GetMask(),
	 XtNbackground,  	bg.GetPixel(&cmap),
	 XtNforeground,  	fg.GetPixel(&cmap),
	 XtNfont,        	font.GetInternalFont(),
	 XtNshrinkToFit, 	(width < 0 || height < 0),
	 XtNhighlightThickness, margin/2,
	 XtNtraversalOn, 	border,
	 XtNleftMargin, 	margin,
	 XtNrightMargin,        margin,
	 XtNtopMargin,          margin,
	 XtNbottomMargin,       margin,
	 NULL);
    // set data declared in wxItem
    callback = function;
    XtAddCallback(HWidget(), XtNactivate, wxButton::EventCallback, (XtPointer)this);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();
    AllowResize(FALSE);

    isBitmap = TRUE;
    return TRUE;
}

//-----------------------------------------------------------------------------
// alternate SetLabel for changing bitmap
//-----------------------------------------------------------------------------

void wxButton::AllowResize(Bool allow)
{
    XtVaSetValues(HWidget(), XtNshrinkToFit, allow, NULL);
}

void wxButton::SetAlignment(long alignment)
{
    XtVaSetValues(HWidget(), XtNalignment, alignment, NULL);
}

void wxButton::SetDefault(void)
{
    ((wxPanel*)parent)->SetDefaultItem(this);
}

void wxButton::SetLabel(char *label)
{
    isBitmap = FALSE;
    XtVaSetValues(HWidget(),
		  XtNlabel,  label,
		  XtNpixmap, None,
		  XtNmask,   None,
		  NULL);
}

void wxButton::SetLabel(wxBitmap *bitmap)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxButton::SetLabel");
	SetLabel("ERROR");
    } else
	SetLabel(*bitmap);
}

void wxButton::SetLabel(wxBitmap& bitmap)
{
    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxButton::SetLabel");
	SetLabel("ERROR");
    } else {
	bmp = bitmap;
	if (bmp.GetDepth() == 1 || bmp.GetDepth() == wxDisplayDepth())
	    XtVaSetValues(HWidget(),
			  XtNlabel,  NULL,
			  XtNpixmap, bitmap.GetPixmap(),
			  XtNmask,   bitmap.GetMask(),
			  NULL);
    }
    isBitmap = TRUE;
}

//-----------------------------------------------------------------------------
// do the same as if button was clicked
//-----------------------------------------------------------------------------

void wxButton::Command(wxCommandEvent &event)
{
//  wxCommandEvent ev(wxEVENT_TYPE_BUTTON_COMMAND);
//  ev.eventObject = this;
//  ProcessCommand(ev);
    wxItem::Command(event);
}

//-----------------------------------------------------------------------------
// callback for commandWidgetClass
//-----------------------------------------------------------------------------

void wxButton::EventCallback(Widget WXUNUSED(w), XtPointer clientData,
			     XtPointer WXUNUSED(ptr))
{
    wxButton       *button = (wxButton*)clientData;
    wxCommandEvent event(wxEVENT_TYPE_BUTTON_COMMAND);

    event.eventObject = button;

    button->ProcessCommand(event);
}

void wxButton::SetLabelFont(wxFont *new_font)
{
    SetFont(new_font);
    label_font = new_font;
}

