/*								-*- C++ -*-
 * $Id: WIN_windowevent.cpp,v 1.5 1999/08/31 10:38:16 wmglo Exp $
 *
 * Purpose: event handling methods for wxWindow (included as is from Window.cpp)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

//-- DIRTY -- DIRTY -- DIRTY -- DIRTY -- DIRTY --
//
// I've used the following way to intercept the incoming events:
// - first Xt calls the expose method of the widget
// - second it calls all event handlers installed by XtAddEventHandler
// - third it evaluates the the widget's translation table
// --> I forbid the evaluation of the translation table and call
// 	_XtTranslateEvent by myself. 
//
//-- DIRTY -- DIRTY -- DIRTY -- DIRTY -- DIRTY --

_XFUNCPROTOBEGIN
extern EventMask _XtConvertTypeToMask(int type);	  // internal Xt function
extern void      _XtTranslateEvent(Widget w, XEvent *ev); // internal Xt function
_XFUNCPROTOEND

//-----------------------------------------------------------------------------
// virtual event functions, that implement the default behaviour
//-----------------------------------------------------------------------------

void wxWindow::OnActivate(Bool active)
{
    if (active && mapped) {
	Time time=CurrentTime;
	XtCallAcceptFocus((X->priv_frame ? X->priv_frame : X->handle), &time);
    }
}

void wxWindow::OnChar(wxKeyEvent& wxevent)
{
    XEvent *xev = (XEvent*)wxevent.eventHandle; // X event

    // check if widget has translations and if this event is selected by the widget
    if (X->handle->core.tm.translations
    && (X->translations_eventmask & _XtConvertTypeToMask(xev->type))) {
	// translate wxKeyEvent to XEvent
	KeySym keysym = CharCodeWXToX(wxevent.keyCode);
	if (keysym != 0)
	    xev->xkey.keycode = XKeysymToKeycode(xev->xkey.display, keysym);
	xev->xkey.x	 = int(LogicalToDeviceX(wxevent.x));
	xev->xkey.y	 = int(LogicalToDeviceY(wxevent.y));
	xev->xkey.state &= ~(ShiftMask | ControlMask | Mod1Mask | Mod3Mask);
	xev->xkey.state |= (wxevent.altDown     ? Mod3Mask    : 0) |
			   (wxevent.controlDown ? ControlMask : 0) |
			   (wxevent.metaDown    ? Mod1Mask    : 0) |
			   (wxevent.shiftDown   ? ShiftMask   : 0);
	// call Widget methods to handle this event
	_XtTranslateEvent(X->handle, xev);
    }
}

Bool wxWindow::OnCharHook(wxKeyEvent& event)
{
    // OnCharHook events are routed to the parent by default
    // wxFrame roots it to wxApp
    if (parent && parent->GetEventHandler())
	return parent->GetEventHandler()->OnCharHook(event);
    return FALSE;
}

void wxWindow::OnCommand(wxWindow& win, wxCommandEvent& event)
{
    // OnCommand events are routed to the parent by default
    // wxFrame stops the rooting
    if (parent && parent->GetEventHandler())
	parent->GetEventHandler()->OnCommand(win, event);
}

void wxWindow::OnDefaultAction(wxItem *initiatingItem)
{
    // OnDefaultAction events are routed to the parent by default
    // wxFrame stops the rooting
    if (parent && parent->GetEventHandler())
	parent->GetEventHandler()->OnDefaultAction(initiatingItem);
}

void wxWindow::OnEvent(wxMouseEvent& wxevent)
{
    XEvent    *xev = (XEvent*)wxevent.eventHandle; // X event
    EventMask mask = _XtConvertTypeToMask(xev->xany.type); // eventmask of event

    // OnLeftClick and OnRightClick
    if (wxevent.eventType == wxEVENT_TYPE_LEFT_UP) {
	GetEventHandler()->OnLeftClick(xev->xbutton.x, xev->xbutton.y,
				       (wxevent.controlDown ? wxKEY_CTRL  : 0)
				       | (wxevent.shiftDown ? wxKEY_SHIFT : 0));
    }
    if (wxevent.eventType == wxEVENT_TYPE_RIGHT_UP) {
	GetEventHandler()->OnRightClick(xev->xbutton.x, xev->xbutton.y,
					(wxevent.controlDown ? wxKEY_CTRL  : 0)
					| (wxevent.shiftDown ? wxKEY_SHIFT : 0));
    }
    // adapt converted mask (Xt error????)
    if (mask & ButtonMotionMask)
	mask |= Button1MotionMask | Button2MotionMask | Button3MotionMask |
		Button4MotionMask | Button5MotionMask;
    // check if widget has translations and if this event is selected by the widget
    if (X->handle->core.tm.translations && (X->translations_eventmask & mask)) {
	// no translation of wxMouseEvents to XEvents as for OnChar
	// --- may be added on request ---
	// call Widget methods to handle this event
	_XtTranslateEvent(X->handle, xev);
    }
}

void wxWindow::OnPaint(void)
{
    // This works only for subclasses of the xfwfCommonWidgetClass
    XfwfCallExpose(X->handle, X->expose_event, X->expose_region);
}

void wxWindow::OnScroll(wxCommandEvent& event)
{
    XfwfScrollInfo *sinfo = (XfwfScrollInfo*)event.eventHandle;

    // sinfo->gx and sinfo->gy are set by the ScrolledWindow widget
    XtMoveWidget(X->handle, -sinfo->gx, -sinfo->gy);
}

void wxWindow::OnSize(int WXUNUSED(width), int WXUNUSED(height))
{
#if USE_CONSTRAINTS
    if (GetAutoLayout())
	Layout();
#endif
}

//-----------------------------------------------------------------------------
// protected event handlers needed for internals
//-----------------------------------------------------------------------------

void wxWindow::AfterRealize(void)
{
    // setup drawable of dc on first expose
    if (dc && !(dc->ok)) {
	dc->DrawWindow() = dc->DrawArea() = XtWindow(X->handle);
	dc->ok = TRUE;
	dc->SetBackground(dc->current_background_brush);
	if (painting_enabled)
	    dc->Clear();
    }
    // set colourmap: has to be done during the first expose to be sure, that
    // the window exists
    SetColourMapWMHint();
}

void wxWindow::PreResize(int x, int y, int width, int height)
{
    // call event handlers
    GetEventHandler()->OnMove(x, y);
    GetEventHandler()->OnSize(width, height);
}

//-----------------------------------------------------------------------------
// apply event handling to a wxWindow
//-----------------------------------------------------------------------------

void wxWindow::AddEventHandlers(void)
{
    if (!X->frame || !X->handle) // forbid, if no widget associated
	return;

    // event handler for frame
    XtInsertEventHandler(X->frame,		// handle events for frame widget
			 StructureNotifyMask |	// for OnSize, OnEvent
			 SubstructureNotifyMask |
			 ButtonPressMask |	// for panel item placement
			 ButtonReleaseMask |	//   to send this events
			 ButtonMotionMask |	//   to handle window
			 PointerMotionMask |
			 PointerMotionHintMask |
			 (XtIsSubclass(X->frame, xfwfCommonWidgetClass) ?
			  NoEventMask : FocusChangeMask), // for OnKillFocus, OnSetFocus
			 TRUE,			// for OnClose (ClientMessage)
			 (XtEventHandler)wxWindow::FrameEventHandler,
			 (XtPointer)this,
			 XtListTail);
    // handle focus events (works only for subclasses of xfwfCommonWidgetClass)
    if (XtIsSubclass(X->frame, xfwfCommonWidgetClass)) {
	XtAddCallback(X->frame, XtNfocusHiliteChange,
		      (XtCallbackProc)wxWindow::FocusEventHandler,
		      (XtPointer)this);
    }
    // event handler for handle
    if (XtIsRealized(X->handle)) {
	// if widget is realized add handlers immediately
	AddEventHandlers2(X->handle, this, NULL, NULL);
    } else {
	// add event handler after creation
	XtInsertEventHandler(X->handle,		     // handle events for handle widget
			     StructureNotifyMask |
			     SubstructureNotifyMask, // for CreateNotify
			     FALSE,
			     (XtEventHandler)wxWindow::AddEventHandlers2,
			     (XtPointer)this,
			     XtListTail);
    }
    // handle expose events (works only for subclasses of xfwfCommonWidgetClass)
    if (XtIsSubclass(X->handle, xfwfCommonWidgetClass)) {
	XtAddCallback(X->handle, XtNexposeCallback,
		      (XtCallbackProc)wxWindow::ExposeEventHandler,
		      (XtPointer)this);
	XtVaSetValues(X->handle, XtNuseExposeCallback, TRUE, NULL);
    }
    // handle scroll events (works only for scrollable widgets)
    if (X->priv_frame && XtIsSubclass(X->priv_frame, xfwfScrolledWindowWidgetClass)) {
	XtAddCallback(X->priv_frame, XtNscrollCallback,
		      (XtCallbackProc)wxWindow::ScrollEventHandler,
		      (XtPointer)this);
    }
}

void wxWindow::AddEventHandlers2(Widget widget, wxWindow *win, XEvent *xev,
				 Boolean *WXUNUSED(continue_to_dispatch_return))
{
    if (!xev || xev->xany.type == CreateNotify || xev->xany.type == MapNotify) {
	// eventhandler is installed AFTER create, because the widget event
	// mask is generated during the realization process
	win->X->translations_eventmask = XtBuildEventMask(widget);
	XtInsertEventHandler(
	    widget,		// handle events for frame widget
	    KeyPressMask |	// for OnChar
	    ButtonPressMask |	// for OnEvent
	    ButtonReleaseMask |
	    ButtonMotionMask |
	    PointerMotionMask |
	    PointerMotionHintMask |
	    EnterWindowMask |
	    LeaveWindowMask |
	    (XtIsSubclass(widget, xfwfCommonWidgetClass) ?
	     	NoEventMask : ExposureMask), // for OnPaint (non-xfwfCommonWidget-subclasses)
	    FALSE,
	    (XtEventHandler)wxWindow::WindowEventHandler,
	    (XtPointer)win,
	    XtListTail);
	// remove THIS eventhandler because the work is done
	XtRemoveEventHandler(widget, XtAllEvents, TRUE,
			     (XtEventHandler)wxWindow::AddEventHandlers2,
			     (XtPointer)win);
    }
}

void wxWindow::RemoveEventHandlers(void)
{
    if (!X->frame || !X->handle) // forbid, if no widget associated
	return;

    // remove event handlers
    XtRemoveEventHandler(X->frame, XtAllEvents, TRUE,
			 (XtEventHandler)wxWindow::FrameEventHandler,
			 (XtPointer)this);
    XtRemoveEventHandler(X->handle, XtAllEvents, TRUE,
			 (XtEventHandler)wxWindow::AddEventHandlers2,
			 (XtPointer)this);
    XtRemoveEventHandler(X->handle, XtAllEvents, TRUE,
			 (XtEventHandler)wxWindow::WindowEventHandler,
			 (XtPointer)this);
    // remove callbacks
    if (XtIsSubclass(X->frame, xfwfCommonWidgetClass)) {
	XtRemoveCallback(X->frame, XtNfocusHiliteChange,
			 (XtCallbackProc)wxWindow::FocusEventHandler,
			 (XtPointer)this);
    }
    if (XtIsSubclass(X->handle, xfwfCommonWidgetClass)) {
	XtRemoveCallback(X->handle, XtNexposeCallback,
			 (XtCallbackProc)wxWindow::ExposeEventHandler,
			 (XtPointer)this);
    }
    if (X->priv_frame && XtIsSubclass(X->priv_frame, xfwfScrolledWindowWidgetClass)) {
	XtRemoveCallback(X->priv_frame, XtNscrollCallback,
			 (XtCallbackProc)wxWindow::ScrollEventHandler,
			 (XtPointer)this);
    }
}

//-----------------------------------------------------------------------------
// XtEventHandlers, that translate the incoming X events to WX events
//-----------------------------------------------------------------------------

void wxWindow::ExposeEventHandler(Widget     WXUNUSED(w),
				  wxWindow*  win,
				  XtPointer  p_XfwfExposeInfo)
{
    XfwfExposeInfo *einfo = (XfwfExposeInfo*)p_XfwfExposeInfo;

    if (win->first_painting)
	win->AfterRealize();
    win->first_painting = FALSE;
    if (win->painting_enabled) { // painting is allowed
	if (win->dc) {
	    // setup clipping region
	    win->dc->ExposeReg() = einfo->region;
	    win->dc->SetCanvasClipping();
	}
	// call refresh method
	win->X->expose_region = einfo->region;
	win->X->expose_event  = einfo->event;
	win->GetEventHandler()->OnPaint();
	win->X->expose_region = NULL;
	win->X->expose_event  = NULL;
	if (win->dc) {
	    // reset clipping region
	    win->dc->ExposeReg() = NULL;
	    win->dc->SetCanvasClipping();
	}
    }
}

void wxWindow::FocusEventHandler(Widget w, wxWindow *win, Boolean *set_focus)
{
#if WXDEBUG_EVENTS
    if (wxAPP_DEBUGEVENTS) {
	printf("%-17s: %s(%p)\n",
	       *set_focus ? "FocusIn - Xt" : "FocusOut - Xt",
	       XtName(w), w);
	fflush(stdout);
    }
#endif
    if (*set_focus)
	win->GetEventHandler()->OnSetFocus();
    else
	win->GetEventHandler()->OnKillFocus();
}

void wxWindow::FrameEventHandler(Widget w,
				 wxWindow *win,
				 XEvent *xev,
				 Boolean *continue_to_dispatch_return)
{
    switch (xev->xany.type) {
    case ClientMessage: { 
	// only wxFrames have a WM_DELETE_WINDOW property
	char* atom_name = XGetAtomName(XtDisplay(w),xev->xclient.message_type);
	if(!strcmp(atom_name, "WM_PROTOCOLS"))
	{
	    XFree(atom_name);
	    atom_name = XGetAtomName(XtDisplay(w),xev->xclient.data.l[0]);
	    if (!strcmp(atom_name, "WM_DELETE_WINDOW"))
	    {
		// I've received a WM_DELETE_WINDOW message for win
		static Bool recursing = FALSE;

#if WXDEBUG_EVENTS
		if (wxAPP_DEBUGEVENTS) {
		    printf("%-17s: %s(%p) - WM_DELETE_WINDOW\n",
			   "ClientMessage", XtName(w), w);
		    fflush(stdout);
		}
#endif
		if ((wxModalShowingStack.Number()>0 &&
		     wxModalFrames.First()->Data()!=win) || recursing) {
		    // forbid closing if there is a top-modal frame other than
		    // this or if called through wxFlushEvents() below
		    XFree(atom_name);
		    return;
		}
		// flush events
		recursing = TRUE;
		wxFlushEvents();
		recursing = FALSE;
		// delete frame, if allowed
		if (win->GetEventHandler()->OnClose()) {
		    win->Show(FALSE);
#if !WXGARBAGE_COLLECTION_ON
		    wxPostDelete(win);
#endif
		}
	    }
	}
	XFree(atom_name);
	// DND protocol (Thanks Robert!)
	Display* display = wxAPP_DISPLAY;
	Window   root    = wxAPP_ROOT;
	Atom     DND     = XInternAtom(display, "DndProtocol", False);
	if (xev->xclient.message_type == DND) {
	    unsigned char *data;
	    unsigned long size;
	    Atom actualType;
	    int actualFormat;
	    unsigned long remainingBytes;
	    XGetWindowProperty(display, root, DND, 0L, 1000000L, FALSE,
			       AnyPropertyType, &actualType, &actualFormat,
			       &size, &remainingBytes, &data );
	    int dropX = (int)((long)(xev->xclient.data.l[3]) & 0xffff); 
	    int dropY = (int)((long)(xev->xclient.data.l[3]) / 65536);
	    wxNode *node = win->GetChildren()->First();
	    while (node) {
		wxWindow *child = (wxWindow*)node->Data();
		int child_x = 0;
		int child_y = 0;
		child->ClientToScreen( &child_x, &child_y );
		if ((dropX > child_x) && (dropY > child_y)) {
		    int child_w = 0;
		    int child_h = 0;
		    child->GetSize( &child_w, &child_h );
		    if ((dropX < child_x+child_w) && (dropY < child_y+child_h)){
			win = child;
			node = win->GetChildren()->First();
			continue;
		    }
		}
		node = node->Next();
	    }
	    win->ScreenToClient( &dropX, &dropY );
	    win->GetEventHandler()->OnDropFiles(1, (char**)data, dropX, dropY);
	    *continue_to_dispatch_return = FALSE; 
	}
	} break;
    case MapNotify: // hold state of window (shown or hidden)
	win->mapped = TRUE;
	break;
    case UnmapNotify: // hold state of window (shown or hidden)
	win->mapped = FALSE;
	break;
    case ConfigureNotify: // notify size and position change
	win->PreResize(xev->xconfigure.x,     xev->xconfigure.y,
		       xev->xconfigure.width, xev->xconfigure.height);
	break;
    case FocusIn:
	if (XtIsShell(w)) {
#if WXDEBUG_EVENTS
	    if (wxAPP_DEBUGEVENTS) {
		printf("%-17s: %s(%p) -> OnActivate(TRUE)\n", "FocusIn", XtName(w), w);
		fflush(stdout);
	    }
#endif
	    wxAPP_ACTIVE_WINDOW = win;
	    win->GetEventHandler()->OnActivate(TRUE);
	}
	if (xev->xfocus.detail != NotifyPointer)
	    win->GetEventHandler()->OnSetFocus();
	break;
    case FocusOut:
	if (XtIsShell(w)) {
#if WXDEBUG_EVENTS
	    if (wxAPP_DEBUGEVENTS) {
		printf("%-17s: %s(%p) -> OnActivate(FALSE)\n", "FocusOut", XtName(w), w);
		fflush(stdout);
	    }
#endif
	    wxAPP_ACTIVE_WINDOW = NULL;
	    win->GetEventHandler()->OnActivate(FALSE);
	}
	if (xev->xfocus.detail != NotifyPointer)
	    win->GetEventHandler()->OnKillFocus();
	break;
    case ButtonPress: case ButtonRelease:
	if (win->GetParent()
	&&  win->GetParent()->GetUserEditMode()
	&&  XtWindow(w) != XtWindow(win->HWidget())) {
	    // propagate event to window
	    Window dummy; int dx, dy; // dummy and offset of handle to frame
	    XTranslateCoordinates(XtDisplay(w), XtWindow(win->HWidget()), XtWindow(w),
				  0, 0, &dx, &dy, &dummy);
	    xev->xbutton.x -= dx;
	    xev->xbutton.y -= dy;
	    WindowEventHandler(win->HWidget(), win, xev, continue_to_dispatch_return);
	}
	break;
    case MotionNotify:
	if (win->GetParent()
	&&  win->GetParent()->GetUserEditMode()
	&&  XtWindow(w) != XtWindow(win->HWidget())) {
	    // propagate event to window
	    Window dummy; int dx, dy; // dummy and offset of handle to frame
	    XTranslateCoordinates(XtDisplay(w), XtWindow(win->HWidget()), XtWindow(w),
				  0, 0, &dx, &dy, &dummy);
	    xev->xmotion.x -= dx;
	    xev->xmotion.y -= dy;
	    WindowEventHandler(win->HWidget(), win, xev, continue_to_dispatch_return);
	}
	break;
    }
}

void wxWindow::ScrollEventHandler(Widget    WXUNUSED(w),
				  wxWindow  *win,
				  XtPointer p_XfwfScrollInfo)
{
    XfwfScrollInfo *sinfo = (XfwfScrollInfo*)p_XfwfScrollInfo;

    wxCommandEvent wxevent;
    wxevent.eventHandle = (char*)p_XfwfScrollInfo;
    // type of event
    switch (sinfo->reason) {
    case XfwfSUp: case XfwfSLeft:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_LINEUP;
	break;
    case XfwfSDown: case XfwfSRight:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_LINEDOWN;
	break;
    case XfwfSPageUp: case XfwfSPageLeft:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_PAGEUP;
	break;
    case XfwfSPageDown: case XfwfSPageRight:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_PAGEDOWN;
	break;
    case XfwfSTop: case XfwfSLeftSide:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_TOP;
	break;
    case XfwfSBottom: case XfwfSRightSide:
	wxevent.eventType = wxEVENT_TYPE_SCROLL_BOTTOM;
	break;
    case XfwfSMove: case XfwfSDrag:	 
	wxevent.eventType = wxEVENT_TYPE_SCROLL_THUMBTRACK;
	break;
    default:
	break;
    }
    // direction and value of scrolling
    if ( (sinfo->flags & XFWF_HORIZONTAL) ) {
	WXSCROLLORIENT(wxevent) = wxHORIZONTAL;
	WXSCROLLPOS(wxevent) = sinfo->gx;
    } else {
	WXSCROLLORIENT(wxevent) = wxVERTICAL;
	WXSCROLLPOS(wxevent) = sinfo->gy;
    }
    // call event handler
    win->GetEventHandler()->OnScroll(wxevent);
}

#define IS_FKT_KEY(k) (IsCursorKey(k)   || IsKeypadKey(k) || IsMiscFunctionKey(k) ||	\
		       IsFunctionKey(k) || IsPFKey(k))

void wxWindow::WindowEventHandler(Widget w,
				  wxWindow *win,
				  XEvent *xev,
				  Boolean *continue_to_dispatch_return)
{
    Bool Enter=FALSE, Press=FALSE;

    switch (xev->xany.type) {
    case KeyPress: {
	wxKeyEvent wxevent(wxEVENT_TYPE_CHAR);
	wxWindow*  f = wxFindFrame(win);
	KeySym	   keysym;
	(void)XLookupString(&(xev->xkey), NULL, 0, &keysym, NULL);
	// set wxWindows event structure
	wxevent.eventHandle	= (char*)xev;
	wxevent.eventObject	= win;
	wxevent.keyCode		= CharCodeXToWX(keysym);
	wxevent.x		= win->DeviceToLogicalX(xev->xkey.x);
	wxevent.y		= win->DeviceToLogicalY(xev->xkey.y);
	wxevent.altDown		= xev->xkey.state & Mod3Mask;
	wxevent.controlDown	= xev->xkey.state & ControlMask;
	wxevent.metaDown	= xev->xkey.state & Mod1Mask;
	wxevent.shiftDown	= xev->xkey.state & ShiftMask;
	wxevent.timeStamp       = xev->xkey.time;
	// first check for "hooked" key, then for hotkey, then for function key
	// if nothing of this was called, call OnChar
	Bool
	    event_handled = win->GetEventHandler()->OnCharHook(wxevent);
	if (!event_handled && f)
	    event_handled = f->GetEventHandler()->OnHotKey(wxevent);
	if (!event_handled && IS_FKT_KEY(keysym))
	    event_handled = win->GetEventHandler()->OnFunctionKey(wxevent);
	if (!event_handled)
	    win->GetEventHandler()->OnChar(wxevent);
	*continue_to_dispatch_return = FALSE; /* Event was handled */ }
	break;
    case ButtonPress:
	Press = TRUE;
    case ButtonRelease: {
	wxMouseEvent wxevent;
	switch (xev->xbutton.button) {
	case Button1: wxevent.eventType = wxEVENT_TYPE_LEFT;   break;
	case Button2: wxevent.eventType = wxEVENT_TYPE_MIDDLE; break;
	case Button3: wxevent.eventType = wxEVENT_TYPE_RIGHT;  break;
	}
	if (Press) {
	    /* MATTHEW */
	    if (!wxIsFrame(win))
		win->SetFocus();
	    // button is down
	    wxevent.eventType |= wxEVENT_TYPE_DOWN;
	    if (win->allow_dclicks) { // doubleclick handling wanted?
		if (xev->xbutton.button == win->X->last_clickbutton
		    &&  xev->xbutton.time   -  win->X->last_clicktime
				<= (unsigned int)XtGetMultiClickTime(wxAPP_DISPLAY))
		{
		    // double click has arrived
		    wxevent.eventType |= wxEVENT_TYPE_DOUBLE;
		    win->X->last_clicktime = 0; 
		} else {
		    // single click has arrived
		    win->X->last_clickbutton = xev->xbutton.button;
		    win->X->last_clicktime   = xev->xbutton.time;
		}
	    }
	}
	// set wxWindows event structure
	wxevent.eventHandle	= (char*)xev;
	wxevent.eventObject	= win;
	wxevent.x		= win->DeviceToLogicalX(xev->xbutton.x);
	wxevent.y		= win->DeviceToLogicalY(xev->xbutton.y);
	wxevent.altDown		= xev->xbutton.state & Mod3Mask;
	wxevent.controlDown	= xev->xbutton.state & ControlMask;
	wxevent.metaDown	= xev->xbutton.state & Mod1Mask;
	wxevent.shiftDown	= xev->xbutton.state & ShiftMask;
	wxevent.leftDown	= xev->xbutton.state & Button1Mask;
	wxevent.middleDown	= xev->xbutton.state & Button2Mask;
	wxevent.rightDown	= xev->xbutton.state & Button3Mask;
	wxevent.timeStamp       = xev->xbutton.time;
	// OnEvent
	win->GetEventHandler()->OnEvent(wxevent);
	*continue_to_dispatch_return = FALSE; /* Event was handled by OnEvent */ }
	break;
    case EnterNotify:
	Enter = TRUE;
    case LeaveNotify: {
	wxMouseEvent wxevent(Enter ? wxEVENT_TYPE_ENTER_WINDOW :
				     wxEVENT_TYPE_LEAVE_WINDOW);
	// set wxWindows event structure
	wxevent.eventHandle	= (char*)xev;
	wxevent.eventObject	= win;
	wxevent.x		= win->DeviceToLogicalX(xev->xcrossing.x);
	wxevent.y		= win->DeviceToLogicalY(xev->xcrossing.y);
	wxevent.altDown		= xev->xcrossing.state & Mod3Mask;
	wxevent.controlDown	= xev->xcrossing.state & ControlMask;
	wxevent.metaDown	= xev->xcrossing.state & Mod1Mask;
	wxevent.shiftDown	= xev->xcrossing.state & ShiftMask;
	wxevent.leftDown	= xev->xcrossing.state & Button1Mask;
	wxevent.middleDown	= xev->xcrossing.state & Button2Mask;
	wxevent.rightDown	= xev->xcrossing.state & Button3Mask;
	wxevent.timeStamp       = xev->xcrossing.time;
	win->GetEventHandler()->OnEvent(wxevent);
	*continue_to_dispatch_return = FALSE; /* Event was handled by OnEvent */ }
	break;
    case MotionNotify: {
	wxMouseEvent wxevent(wxEVENT_TYPE_MOTION);
	if (xev->xmotion.is_hint == NotifyHint) {
	    // hints need a XQueryPointer
	    Window root, child;
	    XQueryPointer(XtDisplay(w), XtWindow(w), &root, &child,
			  &(xev->xmotion.x_root), &(xev->xmotion.y_root),
			  &(xev->xmotion.x),      &(xev->xmotion.y),
			  &(xev->xmotion.state));
	}
	// set wxWindows event structure
	wxevent.eventHandle	= (char*)xev;
	wxevent.eventObject	= win;
	wxevent.x		= win->DeviceToLogicalX(xev->xmotion.x);
	wxevent.y		= win->DeviceToLogicalY(xev->xmotion.y);
	wxevent.altDown		= xev->xmotion.state & Mod3Mask;
	wxevent.controlDown	= xev->xmotion.state & ControlMask;
	wxevent.metaDown	= xev->xmotion.state & Mod1Mask;
	wxevent.shiftDown	= xev->xmotion.state & ShiftMask;
	wxevent.leftDown	= xev->xmotion.state & Button1Mask;
	wxevent.middleDown	= xev->xmotion.state & Button2Mask;
	wxevent.rightDown	= xev->xmotion.state & Button3Mask;
	wxevent.timeStamp       = xev->xmotion.time;
	win->GetEventHandler()->OnEvent(wxevent);
	*continue_to_dispatch_return = FALSE; /* Event was handled by OnEvent */ }
	break;
    case Expose: // arrives for non-xfwfCommonWidget-subclasses only
	if (win->first_painting)
	    win->AfterRealize();
	win->first_painting = FALSE;
	if (win->painting_enabled) { // expose only if painting enabled
	    // call refresh method
	    win->X->expose_region = NULL; // the region does not make any sense
	    win->X->expose_event  = xev;
	    win->GetEventHandler()->OnPaint();
	    win->X->expose_event  = NULL;
	}
        break;
    }
}
