/*								-*- C++ -*-
 * $Id: DEV_psdc.h,v 1.2 1999/08/31 10:34:38 wmglo Exp $
 *
 * Purpose: 
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef PSDC_h
#define PSDC_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxBrush;
class wxColour;
class wxColourMap;
class wxFont;
class wxIcon;
class wxList;
class wxPen;
class ofstream;

class wxPostScriptDC : public wxDC {
DECLARE_DYNAMIC_CLASS(wxPostScriptDC)
public:
    wxPostScriptDC(void);
    wxPostScriptDC(char *output, Bool interactive=TRUE, wxWindow *parent=NULL);
    ~wxPostScriptDC(void);

    Bool Create(char *output, Bool interactive=TRUE, wxWindow *parent=NULL);

    // virtual methods, declared in wxDC
    Bool  Blit(float xdest, float ydest, float w, float h, wxDC *src,
	       float xsrc, float ysrc, int rop=wxCOPY);
    Bool  CanGetTextExtent(void) { return USE_AFM_FOR_POSTSCRIPT; }
    Bool  CanDrawBitmap(void) { return TRUE; }
    void  Clear(void);
    void  CrossHair(float x, float y);
    void  DestroyClippingRegion(void);
    void  DrawArc(float x1, float y1, float x2, float y2, float xc, float yc);
    void  DrawBitmap8(unsigned char *data, int w, int h,
		      wxColourMap *cmap, float x, float y);
    void  DrawEllipse(float x, float y, float w, float h,
		      int startAngle=64*0, int sizeAngle=64*360);
    void  DrawIcon(wxBitmap *icon, float x, float y, Bool useMask=FALSE);
    void  DrawLine(float x1, float y1, float x2, float y2);
    void  DrawLines(int n, wxPoint pts[], float xoff=0, float yoff=0);
    void  DrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    void  DrawLines(wxList *pts, float xoff=0, float yoff=0);
    void  DrawPoint(float x, float y);
    void  DrawPoint(wxPoint &pt)  { DrawPoint(pt.x, pt.y); }
    void  DrawPolygon(int n, wxPoint pts[], float xoff=0, float yoff=0,
		      int fill=wxODDEVEN_RULE);
    void  DrawPolygon(wxList *pts, float xoff=0, float yoff=0,
		      int fill=wxODDEVEN_RULE);
    void  DrawRectangle(float x, float y, float w, float h);
    void  DrawRoundedRectangle(float x, float y, float w, float h,
			       float radius=20);
    void  DrawText(const char *text, float x, float y, Bool use16Bit=FALSE);
    void  FloodFill(float x, float y, wxColour *col,int style=wxFLOOD_SURFACE);
    float GetCharHeight(void);
    float GetCharWidth(void);
    void  GetClippingRegion(float *x, float *y, float *w, float *h);
    void  GetTextExtent(const char *s, float *w, float *h, float *descent = 0,
			float *ext_leading = 0,	wxFont *font=NULL,
			Bool use16bit=FALSE);
    void  IntDrawLine(int x1, int y1, int x2, int y2);
    void  IntDrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    void  SetBackground(wxBrush *brush);
    void  SetBrush(wxBrush *brush);
    void  SetClippingRegion(float x, float y, float w, float h);
    void  SetColourMap(wxColourMap *cmap);
    void  SetFont(wxFont *font);
    void  SetLogicalFunction(int fkt);
    void  SetPen(wxPen *pen);
    void  SetTextBackground(wxColour *col);
    void  SetTextForeground(wxColour *col);
    // ask, if a part of the DC is exposed
    int   IsExposed(float x, float y);
    int   IsExposed(float x, float y, float width, float height);
    // necessary for printing
    Bool  StartDoc(char *message);
    void  EndDoc(void);
    void  StartPage(void);
    void  EndPage(void);
    // methods unique to wxPostScriptDC
    Bool  PrinterDialog(wxWindow *parent);
    void  GetSize(float *width, float *height);
    void  GetSizeMM(float *width, float *height);
    // scale and origin methods
    void  SetAxisOrientation(Bool x_left_right, Bool y_bottom_up);
    void  SetDeviceOrigin(float x, float y);
    void  StartUnzoomedDrawing(float x, float y);
    // compatibility with wx-1.68
    ostream *GetStream() { return pstream; }
protected:
    float    current_red, current_green, current_blue;
    float    underline_position, underline_thickness;
    Bool     clipping;
    int      page_number;
    char     *title;
    ofstream *pstream;

#if USE_SPLINES
    // virtual function for spline drawing
    virtual void DrawOpenSpline(wxList *pts);
#endif
};

#endif // PSDC_h
