;;;
;;;  cmail-e19.el - cmail functions for emacs 19 or later
;;; 
;;;  $Author: iwa $
;;;           toshi@he.kobelcosys.co.jp
;;;  created at: Wed Aug 20 14:00:00 JST 1997
;;;  last modified at: Wed Sep  7 02:00:00 JST 1998
;;;
;;;  Copyright (C) 1995-1996 Yukihiro Matsumoto.

;;; cmail-e19.el

(provide 'cmail-e19)
(require 'cmail)

(define-key cmail-mail-mode-map [menu-bar] (make-sparse-keymap))
(define-key cmail-mail-mode-map [menu-bar cmail]
  (cons "Cmail" (make-sparse-keymap "Cmail")))
(define-key cmail-mail-mode-map [menu-bar cmail send-stay]
  '("Send, Keep Editing" . cmail-send))
(define-key cmail-mail-mode-map [menu-bar cmail send]
  '("Send Message" . cmail-send-and-exit))
(define-key cmail-mail-mode-map [menu-bar cmail cmail-summary]
  '("Summary" . cmail-go-summary))

(define-key cmail-summary-mode-map [menu-bar] (make-sparse-keymap))
(define-key cmail-summary-mode-map [menu-bar cmail]
  (cons "Cmail" (make-sparse-keymap "Cmail")))
(define-key cmail-summary-mode-map [menu-bar cmail quit]
  '("Summary Quit" . cmail-summary-quit))
(define-key cmail-summary-mode-map [menu-bar cmail separator-quit]
  '("--"))

(define-key cmail-summary-mode-map [menu-bar cmail fcntl]
  (cons "Feature Control" (make-sparse-keymap "Feature")))

(define-key cmail-summary-mode-map [menu-bar cmail trans]
  (cons "Transfer" (make-sparse-keymap "Transfer")))
(define-key cmail-summary-mode-map [menu-bar cmail trans c2m]
  '("Cmail to unix mail" . cmail-c2m))
(define-key cmail-summary-mode-map [menu-bar cmail trans r2c]
  '("Rmail to cmail" . cmail-r2c))
(define-key cmail-summary-mode-map [menu-bar cmail trans m2c]
  '("unix mail to cmail" . cmail-m2c))

(define-key cmail-summary-mode-map [menu-bar cmail sort]
  (cons "Sort" (make-sparse-keymap "Sort")))
(define-key cmail-summary-mode-map [menu-bar cmail sort number]
  '("Sort by number" . cmail-sort-by-number))
(define-key cmail-summary-mode-map [menu-bar cmail sort time]
  '("Sort by time" . cmail-sort-by-time))
(define-key cmail-summary-mode-map [menu-bar cmail sort date]
  '("Sort by date" . cmail-sort-by-date))
(define-key cmail-summary-mode-map [menu-bar cmail sort subjectr]
  '("Sort by subject(relative)" . cmail-sort-by-subject-relative))
(define-key cmail-summary-mode-map [menu-bar cmail sort subject]
  '("Sort by subject" . cmail-sort-by-subject))

(define-key cmail-summary-mode-map [menu-bar cmail digest]
  (cons "Digest" (make-sparse-keymap "Digest")))
(define-key cmail-summary-mode-map [menu-bar cmail digest burst]
  '("Burst digest" . cmail-burst-digest))
(define-key cmail-summary-mode-map [menu-bar cmail digest send]
  '("Send digest" . cmail-send-digest))

(define-key cmail-summary-mode-map [menu-bar cmail mark]
(cons "Mark" (make-sparse-keymap "Mark")))
(define-key cmail-summary-mode-map [menu-bar cmail mark unread]
  '("Mark unread" . cmail-mark-unread))
(define-key cmail-summary-mode-map [menu-bar cmail mark hold]
  '("Mark hold" . cmail-mark-hold))
(define-key cmail-summary-mode-map [menu-bar cmail mark delete]
  '("Mark delete" . cmail-mark-delete))
(define-key cmail-summary-mode-map [menu-bar cmail mark active]
  '("Mark active" . cmail-mark-active))
(define-key cmail-summary-mode-map [menu-bar cmail mark unmark]
  '("Unmark ^" . cmail-unmark))
(define-key cmail-summary-mode-map [menu-bar cmail mark all]
  '("Mark ^ to all mails" . cmail-mark-all))
(define-key cmail-summary-mode-map [menu-bar cmail mark mail]
  '("Mark ^" . cmail-mark-mail))
(define-key cmail-summary-mode-map [menu-bar cmail separator-summary]
  '("--"))

(define-key cmail-summary-mode-map [menu-bar cmail wide]
  '("Stop page breaking" . cmail-stop-page-breaking))
(define-key cmail-summary-mode-map [menu-bar cmail caesar]
  '("Caesar message" . cmail-caesar-message))
(define-key cmail-summary-mode-map [menu-bar cmail print]
  '("Print mail" . cmail-print))
(define-key cmail-summary-mode-map [menu-bar cmail pipe]
  '("Mail to pipe" . cmail-pipe))
(define-key cmail-summary-mode-map [menu-bar cmail forward]
  '("Forward" . cmail-forward))
(define-key cmail-summary-mode-map [menu-bar cmail followi]
  '("Followup(include)" . cmail-followup-include-text))
(define-key cmail-summary-mode-map [menu-bar cmail follow]
  '("Followup" . cmail-followup))
(define-key cmail-summary-mode-map [menu-bar cmail replyi]
  '("Reply(include)" . cmail-reply-include-text))
(define-key cmail-summary-mode-map [menu-bar cmail reply]
  '("Reply" . cmail-reply))
(define-key cmail-summary-mode-map [menu-bar cmail mail]
  '("Mail send" . cmail-mail-from-summary))
(define-key cmail-summary-mode-map [menu-bar cmail separator-message]
  '("--"))

(define-key cmail-summary-mode-map [menu-bar cmail folder]
  (cons "Folder" (make-sparse-keymap "Folder")))
(define-key cmail-summary-mode-map [menu-bar cmail folder catchup]
  '("Catch up all" . cmail-catch-up-all))
(define-key cmail-summary-mode-map [menu-bar cmail folder archive]
  '("Auto archive" . cmail-auto-archive))
(define-key cmail-summary-mode-map [menu-bar cmail folder save]
  '("Save Folder" . cmail-save-folder))
(define-key cmail-summary-mode-map [menu-bar cmail folder copy]
  '("Copy Folder" . cmail-copy-folder))
(define-key cmail-summary-mode-map [menu-bar cmail folder rename]
  '("Rename Folder" . cmail-rename-folder))
(define-key cmail-summary-mode-map [menu-bar cmail folder list]
  '("List Folders" . cmail-folders))

(define-key cmail-summary-mode-map [menu-bar cmail visit]
  '("Visit Folder" . cmail-visit-folder))
(define-key cmail-summary-mode-map [menu-bar cmail get]
  '("Get new mail" . cmail-summary-get-newmail))
(define-key cmail-summary-mode-map [menu-bar cmail goto]
  '("Go to mail" . cmail-goto-index))
(define-key cmail-summary-mode-map [menu-bar cmail dispsum]
  '("Display summary" . cmail-disp-summary))

(if (fboundp 'customize-group)
    (progn
      (define-key cmail-summary-mode-map [menu-bar cmail separator-folder]
	'("--"))
      (define-key cmail-summary-mode-map [menu-bar cmail customize]
	'("Cmail Customize" . cmail-customize))))

(define-key cmail-summary-mode-map [mouse-2] 'cmail-mouse-select)

(add-hook 'menu-bar-update-hook 'cmail-toggle-feature-menu-bar)

(defun cmail-toggle-feature-menu-bar ()
  "Toggle display contents of feature control menu bar."
  (interactive)
  (if cmail-use-mailcrypt
      (progn
	(if (not (string= mc-version "3.4"))
	  (if (string= cmail-crypt-default-version "5.0")
	      (define-key cmail-summary-mode-map [menu-bar cmail fcntl pgpver]
		'("Default PGP version -> 2.6" . cmail-crypt-change-default-version))
	    (define-key cmail-summary-mode-map [menu-bar cmail fcntl pgpver]
	      '("Default PGP version -> 5.0" . cmail-crypt-change-default-version))))
	(if cmail-crypt-automatic-decrypt/verify
	    (define-key cmail-summary-mode-map [menu-bar cmail fcntl mcauto]
	      '("Automatic PGP decrypt/verify off" . cmail-crypt-toggle-automatic-decrypt/verify))
	  (define-key cmail-summary-mode-map [menu-bar cmail fcntl mcauto]
	    '("Automatic PGP decrypt/verify on" . cmail-crypt-toggle-automatic-decrypt/verify)))))
  (if cmail-use-mime
      (progn
	(if cmail-mime-automatic-preview
	    (define-key cmail-summary-mode-map [menu-bar cmail fcntl tmauto]
	      '("Automatic MIME preview off" . cmail-mime-toggle-automatic-preview))
	  (define-key cmail-summary-mode-map [menu-bar cmail fcntl tmauto]
	    '("Automatic MIME preview on" . cmail-mime-toggle-automatic-preview)))
	(if cmail-mime-forwarding
	    (define-key cmail-summary-mode-map [menu-bar cmail fcntl mimefw]
	      '("MIME forwarding off" . cmail-toggle-mime-forwarding))
	  (define-key cmail-summary-mode-map [menu-bar cmail fcntl mimefw]
	    '("MIME forwarding on" . cmail-toggle-mime-forwarding)))))
  (if (not (featurep 'hilit19))
      (if cmail-highlight-mode
	  (define-key cmail-summary-mode-map [menu-bar cmail fcntl hilit]
	    '("Highlighting off" . cmail-toggle-highlight-mode))
	(define-key cmail-summary-mode-map [menu-bar cmail fcntl hilit]
	  '("Highlighting on" . cmail-toggle-highlight-mode))))
  (if cmail-use-full-window
      (if cmail-always-display-folders
	  (define-key cmail-summary-mode-map [menu-bar cmail fcntl adispf]
	    '("Always displaying folders off" . cmail-toggle-always-display-folders))
	(define-key cmail-summary-mode-map [menu-bar cmail fcntl adispf]
	  '("Always displaying folders on" . cmail-toggle-always-display-folders)))))

(cmail-toggle-feature-menu-bar)

(define-key cmail-summary-mode-map [double-mouse-2]
  'cmail-sum-mouse-selected-msg-menu)

(defun cmail-sum-mouse-selected-msg-menu (event)
  "Pop up menu for selected message in the cmail summary."
  (interactive "e")
  (let* ((msg-num (save-excursion
		    (mouse-set-point event)
		    (cmail-get-page-number-from-summary)))
         (selection
          (x-popup-menu
           event
           (list (format "Message %d" msg-num)
		 (cons "" cmail-sum-pop-up-menu-2)))))
    (if selection
	(progn
	  (mouse-set-point event)
	  (call-interactively selection)))))

(define-key cmail-summary-mode-map [down-mouse-3]
  'cmail-sum-mouse-folder-menu)
(define-key cmail-summary-mode-map [double-mouse-3]
  'cmail-sum-mouse-folder-menu)

(defun cmail-sum-mouse-folder-menu (event)
  "Pop up menu for folder in the cmail summary."
  (interactive "e")
  (let ((selection
	 (x-popup-menu
	  event
	  (list (format "Current Folder: %s" cmail-current-folder)
		(cons "" cmail-sum-pop-up-menu-1)))))
    (if selection
	(call-interactively selection))))

(defun cmail-sum-mouse-expand ()
  (interactive)
  (delete-other-windows)
  (recenter))

;;; cmail-e19.el ends here.
