/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"rfc1035.h"

static const char rcsid[]="$Id: rfc1035gettxt.c,v 1.2 1999/12/06 13:24:23 mrsam Exp $";

int rfc1035_rr_gettxt(struct rfc1035_rr *p, int startpos, char buf[256])
{
unsigned l;

	if (startpos < 0 || (unsigned)startpos >= p->rdlength ||
		p->rdlength - (unsigned)startpos <=
			(l=(unsigned)(unsigned char)p->rdata[startpos]))
	{
		buf[0]=0;
		return (-1);
	}

	++startpos;

	memcpy(buf, p->rdata + startpos, l);
	buf[l]=0;
	startpos += l;
	if (startpos >= p->rdlength)
		startpos= -1;
	return (startpos);
}
