/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"rfc1035.h"
#include	<errno.h>
#include	<stdlib.h>
#include	"rfc1035_res.h"

static const char rcsid[]="$Id: rfc1035qa.c,v 1.2 1999/12/06 13:24:23 mrsam Exp $";

/* Convenient function to do forward IP lookup */

int rfc1035_a(struct rfc1035_res *res,
	const char *name, struct in_addr **iaptr, unsigned *iasize)
{
struct	rfc1035_reply *reply;
int	n, o;
char	namebuf[RFC1035_MAXNAMESIZE+1];

	strcpy(namebuf, name);

	*iasize=0;
	if (rfc1035_resolve_cname(res,
		RFC1035_RESOLVE_RECURSIVE, namebuf,
		RFC1035_TYPE_A, RFC1035_CLASS_IN, &reply) < 0 ||
		reply == 0 ||
		(n=rfc1035_replysearch_all( reply, namebuf, RFC1035_TYPE_A,
			RFC1035_CLASS_IN, 0)) < 0)
	{
		if (reply && reply->rcode != RFC1035_RCODE_NXDOMAIN)
		{
			errno=EAGAIN;
			rfc1035_replyfree(reply);
			return (1);	/* soft error */
		}

		if (reply) rfc1035_replyfree(reply);
		errno=ENOENT;
		return (-1); /* hard error */
	}

	for (o=n; o >= 0; o=rfc1035_replysearch_all(reply, namebuf,
			RFC1035_TYPE_A, RFC1035_CLASS_IN, o+1))
		++*iasize;

	if ( *iasize == 0 )
	{
		errno=EAGAIN;
		rfc1035_replyfree(reply);
		return (-1);
	}

	if ( (*iaptr=(struct in_addr *)malloc(sizeof(**iaptr)* *iasize)) == 0)
	{
		rfc1035_replyfree(reply);
		return (-1);
	}

	for (*iasize=0; n >= 0; n=rfc1035_replysearch_all(reply, namebuf,
			RFC1035_TYPE_A, RFC1035_CLASS_IN, n+1))
	{
		(*iaptr)[*iasize]= reply->allrrs[n]->rr.inaddr;
		++*iasize;
	}

	rfc1035_replyfree(reply);
	return (0);
}
