/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"lexer.h"
#include	"recipe.h"
#include	"varlist.h"
#include	"funcs.h"
#include	"tempfile.h"
#include	"message.h"
#include	"messageinfo.h"
#include	"xconfig.h"
#include	"exittrap.h"
#include	"maildrop.h"
#include	"config.h"
#include	"setgroupid.h"
#include	<sys/types.h>
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#include	<sysexits.h>
#include	<string.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<pwd.h>
#include	"../dbobj.h"
#if	USERDB
#include	"../userdb/userdb.h"
#endif

static const char rcsid[]="$Id: main.C 1.24 1999/10/18 00:12:23 mrsam Exp $";
#if	HAS_GETHOSTNAME
#else
extern "C" int gethostname(const char *, size_t);
#endif


extern void setprocgroup();

static Message m1, m2;
extern char **environ;
static int errexit=EX_TEMPFAIL;
static const char *defaults_vars[]={"LOCKEXT","LOCKSLEEP","LOCKTIMEOUT",
					"LOCKREFRESH", "PATH", "SENDMAIL"};
static const char *defaults_vals[]={LOCKEXT_DEF,LOCKSLEEP_DEF,LOCKTIMEOUT_DEF,
					LOCKREFRESH_DEF, DEFAULT_PATH,
					SENDMAIL_DEF};

Maildrop maildrop;

Maildrop::Maildrop()
{
	verbose_level=0;
	isdelivery=0;
	sigfpe=0;
	includelevel=0;
	embedded_mode=0;
	msgptr= &m1;
	savemsgptr= &m2;
}

static void help()
{
	mout << "Usage: maildrop [options] [-d user] [arg] [arg] ...\n";
	mout << "       maildrop [options] [filterfile [arg] [arg] ...\n";
}

static void bad()
{
	throw "Bad command line arguments, -h for help.";
}

static void nouser()
{
	errexit=EX_TEMPFAIL;
	throw "Invalid user specified.";
}

static int trusted_user(uid_t uid)
{
static char trusted_users[]=TRUSTED_USERS;
static char buf[ sizeof(trusted_users) ];
char	*p;

	strcpy(buf, trusted_users);
	for (p=buf; (p=strtok(p, " ")) != 0; p=0)
	{
	struct	passwd *q=getpwnam(p);

		if (q && q->pw_uid == uid)
			return (1);
	}
	return (0);
}

static void sethostname(Buffer &buf)
{
char    hostname[256];

        hostname[0]=0;
        gethostname(hostname, 256);
        hostname[sizeof(hostname)-1]=0;

	buf=hostname;
}


static void copyright()
{
static const char msg[]="maildrop " VERSION " Copyright 1998-1999 Double Precision, Inc."

#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
#if USE_GDBM
	"GDBM extensions enabled."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
#endif
#if USE_DB
	"Enabled Berkeley DB instead of GDBM extensions."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
#endif
#if MAILDIRQUOTA
	"Maildir quota extension enabled."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
#endif
#if USERDB
	"Virtual user database extension enabled."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
#endif
	"This program is distributed under the terms of the GNU General Public"
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
        "License. See COPYING for additional information."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
 
		;

	mout << msg;
	mout.flush();
}

void Maildrop::reset_vars()
{
int	i;
Buffer	name, value;

	for (i=0; i<(int)(sizeof(defaults_vars)/sizeof(defaults_vars[0])); i++)
	{
		name=defaults_vars[i];
		value=defaults_vals[i];
		SetVar(name, value);
	}
	name="HOME";
	SetVar(name, maildrop.init_home);
	name="LOGNAME";
	SetVar(name, maildrop.init_logname);
	name="SHELL";
	SetVar(name, maildrop.init_shell);
	name="DEFAULT";
	SetVar(name, maildrop.init_default);

	if (maildrop.init_quota.Length() > 0)
	{
		name="MAILDIRQUOTA";
		SetVar(name, maildrop.init_quota);
	}
}


static int run(int argc, char **argv)
{
int	argn;
const	char *deliverymode=0;
const	char *embedded_filter=0;
const	char *from=0;
Buffer	recipe;
uid_t	orig_uid;
Buffer	extra_headers;
struct passwd *my_pw;
int	found;

	umask( 0007 );
	for (argn=1; argn < argc; )
	{
		if (argv[argn][0] != '-')	break;
		if (strcmp(argv[argn], "--") == 0)	{ ++argn; break; }

	char	optc=argv[argn][1];
	const char *optarg=argv[argn]+2;

		++argn;
		switch (optc)	{
		case 'd':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			deliverymode=optarg;
			break;
		case 'V':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			maildrop.verbose_level=atoi(optarg);
			break;
		case 'v':
			copyright();
			return (0);
		case 'm':
			maildrop.embedded_mode=1;
			break;
		case 'M':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			maildrop.embedded_mode=1;
			if (!deliverymode)	deliverymode="";
			if (!*optarg)
			{
				help();
				return (EX_TEMPFAIL);
			}
			embedded_filter=optarg;
			if (*(const char*)embedded_filter == SLASH_CHAR
				|| strchr(embedded_filter, '.'))
				throw "Invalid argument for -M.";
			break;
		case 'A':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			if (*optarg)
			{
				extra_headers += optarg;
				extra_headers += '\n';
			}
			break;
		case 'f':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			if (*optarg)
				from=optarg;
			break;
		case 'h':
			help();
			return (EX_TEMPFAIL);
		default:
			bad();
		}
	}

#if	USERDB
	userdb_init(ETCDIR "/userdb.dat");
#endif

	my_pw=0;
	found=0;
	orig_uid=getuid();
	if (!deliverymode && argn < argc)
		recipe=argv[argn++];
	else
	{
		if (!deliverymode)	deliverymode="";

		if (*deliverymode)
		{
#if	USERDB
		char	*p;
		struct userdbs *udbs;

			p=userdb(deliverymode);
			if (!p && errno != ENOENT)
			{
				errexit=EX_TEMPFAIL;
				throw "Error opening userdb.dat";
			}
			udbs=0;
			if (p)
			{
				udbs=userdb_creates(p);
				free(p);
				if (!udbs && errno != ENOENT)
				{
					errexit=EX_TEMPFAIL;
					throw "Temp failure in userdb_creates";
				}
			}

			if (udbs)
			{
#if	RESET_GID
				setgroupid(udbs->udb_gid);
#endif
				setuid(udbs->udb_uid);
				if (getuid() != udbs->udb_uid)
					nouser();	// Security violation.

				if (udbs->udb_quota)
					maildrop.init_quota=udbs->udb_quota;
				maildrop.init_home=udbs->udb_dir;
				maildrop.init_logname=deliverymode;
				maildrop.init_shell=udbs->udb_shell &&
						*udbs->udb_shell ?
						udbs->udb_shell:"/bin/sh";
				maildrop.init_default=udbs->udb_mailbox &&
					*udbs->udb_mailbox ?
						udbs->udb_mailbox:
					GetDefaultMailbox(deliverymode);
				userdb_frees(udbs);
				found=1;
			}
			else
#endif
			{
				my_pw=getpwnam(deliverymode);
				if (!my_pw)
					nouser();
#if	RESET_GID
				setgroupid(my_pw->pw_gid);
#endif
				setuid(my_pw->pw_uid);
				if (getuid() != my_pw->pw_uid)
					nouser();	// Security violation.

				maildrop.init_home=my_pw->pw_dir;
				maildrop.init_logname=my_pw->pw_name;
				maildrop.init_shell=
					my_pw->pw_shell && *my_pw->pw_shell
						? my_pw->pw_shell:"/bin/sh";
				maildrop.init_default=
					GetDefaultMailbox(my_pw->pw_name);
				found=1;
			}
		}
		maildrop.isdelivery=1;
#if	RESTRICT_TRUSTED
		if ( getuid() != orig_uid && !trusted_user(orig_uid))
			nouser();	// Security violation
#endif
	}

#if	RESET_GID
	setgroupid(getgid());
#endif

uid_t	my_u=getuid();

	setuid(my_u);	// Drop any setuid privileges.

	if (!found)
	{
#if	USERDB
	struct userdbs *udbs;

		udbs=userdb_createsuid(my_u);

		if (!udbs && errno != ENOENT)
		{
			errexit=EX_TEMPFAIL;
			throw "Temp failure in userdb_creates";
		}

		if (udbs)
		{
			if (udbs->udb_quota)
				maildrop.init_quota=udbs->udb_quota;
			maildrop.init_home=udbs->udb_dir;
			maildrop.init_logname=udbs->udb_name;
			maildrop.init_shell=udbs->udb_shell &&
					*udbs->udb_shell ?
					udbs->udb_shell:"/bin/sh";
			maildrop.init_default=udbs->udb_mailbox &&
				*udbs->udb_mailbox ?
					udbs->udb_mailbox:
				GetDefaultMailbox(udbs->udb_name);
			userdb_frees(udbs);
		}
		else
#endif
		{
			my_pw=getpwuid(my_u);
			if (!my_pw)	nouser();
			maildrop.init_home=my_pw->pw_dir;
			maildrop.init_logname=my_pw->pw_name;
			maildrop.init_shell=
				my_pw->pw_shell && *my_pw->pw_shell
					? my_pw->pw_shell:"/bin/sh";
			maildrop.init_default=
				GetDefaultMailbox(my_pw->pw_name);
		}
	}

#if	USERDB
	userdb_close();
#endif

int	i;
Buffer	name;
Buffer	value;

	if (!maildrop.isdelivery)
	{
		for (i=0; environ[i]; i++)
		{
			name=environ[i];

		char	*p=strchr(environ[i], '=');

			value= p ? (name.Length(p - environ[i]), p+1):"";
			SetVar(name, value);
		}
	}

	i=1;
	while (argn < argc)
	{
		name="";
		name.append( (unsigned long)i);
		value=argv[argn++];
		SetVar(name, value);
		++i;
	}

	if (deliverymode)
	{
	struct	stat	buf;
	Buffer	b;

		b=maildrop.init_home;
		b += '\0';

	const char *h=b;

		if (VerboseLevel() > 1)
			merr << "maildrop: Changing to " << h << "\n";

		if (chdir(h) < 0)
			throw "Unable to change to home directory.";
		recipe=".mailfilter";

		if ( stat(".", &buf) < 0 ||
			!S_ISDIR(buf.st_mode) ||
			buf.st_mode & S_IWOTH ||
			buf.st_uid != getuid())
			throw "Invalid home directory permissions - world writable.";

		// Quietly terminate if the sticky bit is set on the homedir

		if ( buf.st_mode & S_ISVTX)
			return (EX_TEMPFAIL);

		if (embedded_filter)
		{
			i=stat(".mailfilters", &buf);

			if ( (i < 0 && errno != ENOENT) || (i >= 0 && (
				!S_ISDIR(buf.st_mode) ||
				(buf.st_mode & (S_IRWXO|S_IRWXG)) ||
				buf.st_uid != getuid())
							)
				)
				throw "Invalid permissions on $HOME/.mailfilters - remove world and group perms.";
			recipe = embedded_filter;
		}
	}
#if	SHARED_TEMPDIR

#else
	maildrop.tempdir=maildrop.init_home;
	maildrop.tempdir += "/" TEMPDIR;
	maildrop.tempdir += '\0';
	mkdir( (const char *)maildrop.tempdir, 0700 );
#endif
	maildrop.reset_vars();

Buffer	msg;

	maildrop.global_timer.Set(GLOBAL_TIMEOUT);
	maildrop.msgptr->Init(0);	// Read message from standard input.
	maildrop.msginfo.info( *maildrop.msgptr );
	maildrop.msgptr->ExtraHeaders(extra_headers);
	maildrop.msgptr->setmsgsize();


	if (!from)	from="";
	if (*from)	maildrop.msginfo.fromname=from;

// If invoking user is trusted, trust the From line, else set it to invoking
// user.

	if (
#if KEEP_FROMLINE

// The original From_ line is kept, if necessary

#else

// If invoking user is trusted, trust the From line, else set it to invoking
// user.
		!trusted_user(orig_uid) ||
#endif

		maildrop.msginfo.fromname.Length() == 0)
	{
		maildrop.msginfo.fromname=maildrop.init_logname;
	}

	name="FROM";
	value=maildrop.msginfo.fromname;
	SetVar(name, value);

	if (VerboseLevel() > 1)
	{
		msg.reset();
		msg.append("Message start at ");
		msg.append((unsigned long)maildrop.msginfo.msgoffset);
		msg.append(" bytes, envelope sender=");
		if (maildrop.msginfo.fromname.Length() > 0)
			msg += maildrop.msginfo.fromname;
		msg.append("\n");
		msg += '\0';
		merr.write(msg);
	}

	name="HOSTNAME";
	sethostname(value);
	SetVar(name, value);

int	fd;

	//
	//

	if (!embedded_filter && deliverymode)
	{
	Recipe r;
	Lexer in;

		fd=in.Open(ETCDIR "/maildroprc");
		if (fd < 0)
		{
			if (errno != ENOENT)
				throw "Error opening " ETCDIR "/maildroprc.";
		}
		else
		{
			if (r.ParseRecipe(in) < 0)
				return (EX_TEMPFAIL);
			r.ExecuteRecipe();
		}
	}

Recipe	r;
Lexer	in;

#ifdef	DEFAULTEXT
int	firstdefault=1;
#endif

	name="MAILFILTER";
	value=recipe;
	SetVar(name, value);

	for (;;)
	{
		if (embedded_filter)
		{
			msg=".mailfilters/";
			msg += recipe;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
		}
		else
		{
			msg=recipe;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
			break;
		}
#ifndef	DEFAULTEXT
		break;
#else
		if (fd >= 0)	break;
		if (errno != ENOENT)	break;

		if (firstdefault)
		{
			recipe += DEFAULTEXT;
			firstdefault=0;
			continue;
		}

		// Pop DEFAULTEXT bytes from end of recipe name

		for (fd=sizeof(DEFAULTEXT)-1; fd; --fd)
			recipe.pop();

		while (recipe.Length())
		{
			if (recipe.pop() == '-')
			{
				recipe += DEFAULTEXT;
				break;
			}
		}
		if (recipe.Length() == 0)
		{
			msg=".mailfilters/";
			msg += DEFAULTEXT+1;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
			break;
		}
#endif
	}

	setprocgroup();

	if (fd < 0)
	{
		//
		//  If we are operating in delivery mode, it's ok if
		//  .mailfilter does not exist.
		//
		if (!deliverymode || errno != ENOENT)
		{
		static char buf[80];

			sprintf(buf, "Unable to open filter file, errno=%d.",
				errno);
			throw buf;
		}
	}
	else
	{
	struct	stat	stat_buf;

		if (fstat( fd, &stat_buf) != 0)
			throw "stat() failed.";

		if (!S_ISREG(stat_buf.st_mode) ||
			(stat_buf.st_mode & (S_IRWXO | S_IRWXG)) ||
			stat_buf.st_uid != getuid())
			throw "Invalid permissions on filter file - remove world and group permissions.";

		if (r.ParseRecipe(in) < 0)
			return (EX_TEMPFAIL);

//		if (maildrop.msgptr->MessageSize() > 0)
			r.ExecuteRecipe();
	}
//
// If a message is succesfully delivered, an exception is thrown.
// If we're here, we should deliver to the default mailbox.
//

	if (!maildrop.embedded_mode)
	{
		name="DEFAULT";

	const char *v=GetVarStr(name);

		if (!v)	throw "DEFAULT mailbox not defined.";

		value=v;
		value += '\0';
		if (delivery((const char *)value) < 0)
			return (EX_TEMPFAIL);
	}

	value="EXITCODE";
	return ( GetVar(value)->Int("0") );
}

int main(int argc, char **argv)
{
	_exit(Maildrop::trap(run, argc, argv));
}

const char *GetDefaultMailbox(const char *username)
{
static Buffer buf;
int	isfile=0;

	buf="";

const	char *p=DEFAULT_DEF;

	if (*p != SLASH_CHAR)	// Relative to home directory
	{
		buf=maildrop.init_home;
		buf.push(SLASH_CHAR);
		isfile=1;
	}

	while (*p)
	{
		if (*p != '=')
		{
			buf.push(*p);
			++p;
		}

	const char *q=username;

		while (*p == '=')
		{
			buf.push (*q ? *q:'.');
			if (*q)	q++;
			p++;
		}
	}

	if (!isfile)
	{
		buf.push(SLASH_CHAR);
		buf += username;
	}
	buf += '\0';
	return (buf);
}

#if	SHARED_TEMPDIR

#else
const char *TempName()
{
Buffer	t;

	t=(const char *)maildrop.tempdir;
	t += "/tmp.";
	t += '\0';
	return (TempName((const char *)t, 0));
}
#endif
