.\"
.\" %nmhwarning%
.\" $Id: send.man,v 1.1.1.1 1999/04/30 18:08:37 doug Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH SEND %manext1% MH.6.8 [%nmhversion%]
.SH NAME
send \- send a message
.SH SYNOPSIS
.in +.5i
.ti -.5i
send
\%[\-alias\ aliasfile]
\%[\-draft]
\%[\-draftfolder\ +folder]
.br
\%[\-draftmessage\ msg] \%[\-nodraftfolder]
.br
\%[\-filter\ filterfile] \%[\-nofilter]
\%[\-format] \%[\-noformat]
.br
\%[\-forward] \%[\-noforward]
\%[\-mime] \%[\-nomime]
\%[\-msgid]
.br
\%[\-nomsgid]
\%[\-push] \%[\-nopush]
\%[\-split\ seconds]
.br
\%[\-verbose] \%[\-noverbose]
\%[\-watch] \%[\-nowatch]
.br
\%[\-width\ columns]
\%[file\ ...] 
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fISend\fR will cause each of the specified files to be delivered
to each of the destinations in the \*(lqTo:\*(rq, \*(lqcc:\*(rq,
\*(lqBcc:\*(rq, and \*(lqFcc:\*(rq fields of the message.  If \fIsend\fR
is re\-distributing a message, as invoked from \fIdist\fR, then the
corresponding \*(lqResent\-xxx\*(rq fields are examined instead.

By default, \fIsend\fR uses the program \fIpost\fR(8) to do the actual
delivery of the messages, although this can be changed by defining the
\fIpostproc\fR profile component.  Most of the features attributed to
\fIsend\fR are actually performed by \fIpost\fR.

If `\-push' is specified, \fIsend\fR will detach itself from the user's
terminal and perform its actions in the background.  If \fIpush\fR\0'd
and the draft can't be sent, then an error message will be sent (using
the mailproc) back to the user.  If `\-forward' is given, then a copy
of the draft will be attached to this failure notice.  Using `\-push'
differs from putting \fIsend\fR in the background because the output is
trapped and analyzed by \fInmh\fR.

If `\-verbose' is specified, \fIsend\fR will indicate the interactions
occurring with the transport system, prior to actual delivery.
If `\-watch' is specified \fIsend\fR will monitor the delivery of local
and network mail.  Hence, by specifying both switches, a large detail
of information can be gathered about each step of the message's entry
into the transport system.

The `\-draftfolder\ +folder' and `\-draftmessage\ msg' switches invoke
the \fInmh\fR draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the \fImh-draft\fR(5) man page for more
information.

If `\-split' is specified, \fIsend\fR will split the draft into one
or more partial messages prior to sending.  This makes use of the
MIME features in nmh.  Note however that if \fIsend\fR is
invoked under \fIdist\fR\0(1), then this switch is ignored\0--\0it makes
no sense to redistribute a message in this fashion.  Sometimes you want
\fIsend\fR to pause after posting a partial message.  This is usually
the case when you are running \fIsendmail\fR and expect to generate a
lot of partial messages.  The argument to `\-split' tells it how long
to pause between postings.

\fISend\fR with no \fIfile\fR argument will query whether the draft
is the intended file, whereas `\-draft' will suppress this question.
Once the transport system has successfully accepted custody of the
message, the file will be renamed with a leading comma, which allows
it to be retrieved until the next draft message is sent.  If there are
errors in the formatting of the message, \fIsend\fR will abort with a
(hopefully) helpful error message.

If a \*(lqBcc:\*(rq field is encountered, its addresses will be used for
delivery, and the \*(lqBcc:\*(rq field will be removed from the message
sent to sighted recipients.  The blind recipients will receive an entirely
new message with a minimal set of headers.  Included in the body of the
message will be a copy of the message sent to the sighted recipients.
If `\-filter\ filterfile' is specified, then this copy is filtered
(re\-formatted) by \fImhl\fR prior to being sent to the blind recipients.
Alternately, if you specify the `-mime' switch, then \fIsend\fR will
use the MIME rules for encapsulation.

Prior to sending the message, the fields \*(lqFrom:\ user@local\*(rq,
and \*(lqDate:\ now\*(rq will be appended to the headers in the message.
If the environment variable \fB$SIGNATURE\fR is set, then its value
is used as your personal name when constructing the \*(lqFrom:\*(rq
line of the message.  If this environment variable is not set, then
\fIsend\fR will consult the profile entry \*(lqSignature\*(rq for
this information.  On hosts where \fInmh\fR was configured with the UCI
option, if \fB$SIGNATURE\fR is not set and the \*(lqSignature\*(rq profile
entry is not present, then the file \fB$HOME\fR/.signature is consulted.
If `\-msgid' is specified, then a \*(lqMessage\-ID:\*(rq field will also
be added to the message.

If \fIsend\fR is re\-distributing a message (when invoked by
\fIdist\fR\0), then \*(lqResent\-\*(rq will be prepended to each of these
fields: \*(lqFrom:\*(rq, \*(lqDate:\*(rq, and \*(lqMessage\-ID:\*(rq.
If the message already contains a \*(lqFrom:\*(rq field, then a
\*(lqSender: user@local\*(rq field will be added as well.  (An already
existing \*(lqSender:\*(rq field is an error!)

By using the `\-format' switch, each of the entries in the \*(lqTo:\*(rq
and \*(lqcc:\*(rq fields will be replaced with \*(lqstandard\*(rq
format entries.  This standard format is designed to be usable by all
of the message handlers on the various systems around the Internet.
If `\-noformat' is given, then headers are output exactly as they appear
in the message draft.

If an \*(lqFcc:\ folder\*(rq is encountered, the message will be copied
to the specified folder for the sender in the format in which it will
appear to any non\-Bcc receivers of the message.  That is, it will have
the appended fields and field reformatting.  The \*(lqFcc:\*(rq fields
will be removed from all outgoing copies of the message.

By using the `\-width\ columns' switch, the user can direct \fIsend\fR
as to how long it should make header lines containing addresses.

The files specified by the profile entry \*(lqAliasfile:\*(rq and any
additional alias files given by the `\-alias aliasfile' switch will be
read (more than one file, each preceded by `\-alias', can be named).
See \fImh\-alias\fR\0(5) for more information.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Draft\-Folder:~^To find the default draft\-folder
.Ps
^Aliasfile:~^For a default alias file
.Ps
^Signature:~^To determine the user's mail signature
.Ps
^mailproc:~^Program to post failure notices
.Ps
^postproc:~^Program to post the message
.Sa
comp(1), dist(1), forw(1), repl(1), mh\-alias(5), post(8)
.De
`file' defaults to <mh\-dir>/draft
.Ds
`\-alias %etcdir%/MailAliases'
.Ds
`\-nodraftfolder'
.Ds
`\-nofilter'
.Ds
`\-format'
.Ds
`\-forward'
.Ds
`\-nomime'
.Ds
`\-nomsgid'
.Ds
`\-nopush'
.Ds
`\-noverbose'
.Ds
`\-nowatch'
.Ds
`\-width\ 72'
.Co
None
.Bu
Under some configurations, it is not possible to monitor the mail delivery
transaction; `\-watch' is a no-op on those systems.
.sp
Using `\-split\00' doesn't work correctly.
.En
