#! /usr/local/bin/perl

# summary2gp.pl : generate input data for gnuplot from summary of log.

# Usage: cat summary* | summary2gp.pl

open (GP1, ">gp-data.1") || die("gp-data.1");
open (GP2, ">gp-data.2") || die("gp-data.2");
open (GP3, ">gp-data.3") || die("gp-data.3");
open (GP4, ">gp-data.4") || die("gp-data.4");
open (GP5, ">gp-data.5") || die("gp-data.5");
open (GP6, ">gp-data.6") || die("gp-data.6");

while (<>) {
	chop;
	next if (/^#/);
	@data = split(',');

#	next if ($data[9] > 3000);	# ignore too slow completion
#	next if ($data[6] < 0);		# ignore tsendmail=-1
	next if ($data[2] < 10);	# ignore too small recipients
	next if ($data[4] < 10);	# ignore too small transactions
	$data[6] = 0 if ($data[6] < 0);

	# par recipient
	printf GP1 "%d, %d, %d, %d, %d, %d, %d\n",
		$data[2], $data[6], $data[7], $data[8], $data[9],
		$data[6] + $data[7] + $data[8],
		$data[6] + $data[7] + $data[9];

	# par transaction
	printf GP2 "%d, %d, %d, %d, %d, %d, %d\n",
		$data[4], $data[6], $data[7], $data[8], $data[9],
		$data[6] + $data[7] + $data[8],
		$data[6] + $data[7] + $data[9];

	# average par recipient
	printf GP3 "%d, %f, %f, %f, %f, %f, %f\n",
		$data[2],
		$data[6] / $data[2], $data[7] / $data[2],
		$data[8] / $data[2], $data[9] / $data[2],
		($data[6] + $data[7] + $data[8]) / $data[2],
		($data[6] + $data[7] + $data[9]) / $data[2];

	# average par transaction
	printf GP4 "%d, %f, %f, %f, %f, %f, %f\n",
		$data[4],
		$data[6] / $data[4], $data[7] / $data[4],
		$data[8] / $data[4], $data[9] / $data[4],
		($data[6] + $data[7] + $data[8]) / $data[4],
		($data[6] + $data[7] + $data[9]) / $data[4];

	($time1, $time2) = split(' ', $data[0]);
	($M, $D) = split('/', $time1);
	($h, $m, $s) = split(':', $time2);
	$M -= 8;	# XXX
	$x = ((($M * 31 + $D) * 24 + $h) * 60 + $m) * 60 + $s;

	# par recipient
	printf GP5 "%d, %f, %f, %f, %f, %f, %f\n",
		$x,
		$data[6] / $data[2], $data[7] / $data[2],
		$data[8] / $data[2], $data[9] / $data[2],
		($data[6] + $data[7] + $data[8]) / $data[2],
		($data[6] + $data[7] + $data[9]) / $data[2];

	# par transaction
	printf GP6 "%d, %f, %f, %f, %f, %f, %f\n",
		$x,
		$data[6] / $data[4], $data[7] / $data[4],
		$data[8] / $data[4], $data[9] / $data[4],
		($data[6] + $data[7] + $data[8]) / $data[4],
		($data[6] + $data[7] + $data[9]) / $data[4];

}

exit 0;
