/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "init.h"

extern gchar spruce_ver[];

extern gint texticons;                          /* use text, icons or both? */

void set_security(void)
{
   struct rlimit coredump;

   coredump.rlim_cur = RLIMIT_NOFILE;
   coredump.rlim_max = RLIMIT_NOFILE;
   setrlimit(RLIMIT_CORE, &coredump);  /* we don't want core dumps do we? ;-) */
}

void spruce_init(int argc, char **argv)
{
   gint cur = 0, longindex = 0;
   gchar *param = NULL;
   longopts_t longopts[] =
   {
     {"help",     no_arg, 'h'},
     {"version",  no_arg, 'v'},
     {"bindings", no_arg,  1 },
     {"icons",    no_arg, 'i'},
     {"text",     no_arg, 't'},
     {"both",     no_arg, 'b'},
     {NULL,       no_arg,   0}
   };

   texticons = 0;

   while (cur != -1)
   {
      cur = getopts_long(argc, argv, "hitbv", longopts, &longindex, param);

      switch (cur)
      {
         case 'h':
            spruce_help(argv[0]);
            break;
         case 'i':
            if (texticons != TB_BOTH && texticons != TB_ICONS)
               texticons += TB_ICONS;
            break;
         case 't':
            if (texticons != TB_BOTH && texticons != TB_TEXT)
               texticons += TB_TEXT;
            break;
         case 'b':
            texticons = TB_BOTH;
            break;
         case 'v':
            fprintf(stdout, "Spruce v%s\n\n", spruce_ver);
            exit(0);
            break;
         case 1:
            fprintf(stdout, "Key bindings:\n");
            fprintf(stdout, "  Control + C\t\tCopy message...\n");
            fprintf(stdout, "  Control + D\t\tDelete selected message\n");
            fprintf(stdout, "  Control + E\t\tExpunge selected message\n");
            fprintf(stdout, "  Control + F\t\tForward selected message\n");
            fprintf(stdout, "  Control + M\t\tMove message...\n");
            fprintf(stdout, "  Control + N\t\tNew Message\n");
            fprintf(stdout, "  Control + O\t\tOpen selected message\n");
            fprintf(stdout, "  Control + P\t\tPrint Message\n");
            fprintf(stdout, "  Control + R\t\tReply to message\n");
            fprintf(stdout, "  Control + S\t\tSave Message As...\n");
            fprintf(stdout, "  Control + X\t\tExit Spruce\n");
            fprintf(stdout, "  Control + .\t\tNext message\n");
            fprintf(stdout, "  Control + ,\t\tPrevious message\n\n");
            fflush(stdout);
            exit(0);
            break;
         default:
            break;
      }
   }

   if (!texticons)
      texticons = TB_BOTH;  /* default is toolbar buttons w/ icons and text */
}

void spruce_help(gchar *program)
{
   fprintf(stdout, "Usage: %s [options ...]\n", program);
   fprintf(stdout, "Valid options are:\n");
   fprintf(stdout, "  --bindings\t\tShow key bindings\n");
   fprintf(stdout, "  -h, --help \t\tOutput this help\n");
   fprintf(stdout, "  -i, --icons\t\tUse icons in toolbars\n");
   fprintf(stdout, "  -t, --text \t\tUse text in toolbars\n");
   fprintf(stdout, "  -b, --both \t\tUse both text and icons in toolbars\n");
   fprintf(stdout, "  -v, --version\t\tPrint version information\n\n");
   fflush(stdout);
   exit(0);
}
