/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mbox.h"

extern guint32 *mailpos;  /* steal this from mailbox.c */

gboolean mailbox_is_mbox_format(gchar *mbx, gboolean return_last_retval)
{
   static gboolean retval = FALSE;
   gchar buffer[512];
   FILE *fp;

   /* time to see if we want to re-test the format or not */
   if (return_last_retval)
      return retval;  /* return the old return value */

   fp = fopen(mbx, "rt");
   if (fp == NULL)
   {
      retval = FALSE;
      return retval;
   }

   memset(buffer, 0, sizeof(buffer));
   fgets(buffer, sizeof(buffer)-1, fp);
   if (!strncmp("From ", buffer, strlen("From ")))
   {
      fclose(fp);
      retval = TRUE;
      return retval;
   }

   fclose(fp);

   retval = FALSE;
   return retval;
}

guint mbox_get_num_mesgs(gchar *mbx)
{
   gchar *p, *q, *r;
   struct stat st;
   gint fd;
   guint num = 0;

   if (mailpos != NULL)
      g_free(mailpos);

   if (mbx == NULL)
      return 0;

   fd = open(mbx, O_RDONLY);
   if (fd == -1)
   {
      perror("open()");
      return 0;
   }

   if (stat(mbx, &st) == -1)
   {
      perror("stat()");
      close(fd);
      return 0;
   }

   if (st.st_size)
   {
      p = q = (gchar*) mmap(0, st.st_size, PROT_READ, MAP_PRIVATE, fd, 0);
      if (p == (gchar*)NULL)
      {
         close(fd);
         perror("mmap()");
         return 0;
      }

      if (!g_strncasecmp(p, "From ", strlen("From ")))
      {
         mailpos = g_malloc0(sizeof(guint32));
         mailpos[0] = 0;
         num = 1;
      }
      else
      {
         close(fd);
         fprintf(stderr, "%s is corrupt.\n", mbx);
         fflush(stderr);
         return 0;
      }

      p += strlen("From ");
      while ((p = strstr(p, "\nFrom ")))
      {
         /* this might be the beginning of a new mbox message... 
          * to make sure we must advance to the next line and read it */
         r = p + strlen("\nFrom ");
         for ( ; *r != '\n' && *r != '\0'; r++);

         /* if it says "Return-Path: " then it *is* the beginning of a message */
         if (!g_strncasecmp(r, "\nReturn-Path: ", strlen("\nReturn-Path: ")))
         {
            mailpos = g_realloc(mailpos, (num + 1) * sizeof(guint32));
            mailpos[num] = (guint32)(p - q); /* yuk  */
            num++;
         }
         p = r; /* skip past where we were before, and this is as good a place as any */
      }
      munmap(q, st.st_size);
   }

   close(fd);

   fprintf (stderr, "Total messages for %s = %d\n", mbx, num);
   fflush(stderr);

   return num;
}

gchar *mbox_get_mesg(guint mesg_num, gchar *mbx)
{
   gchar *data = NULL;
   gchar *p, *q, *r, *s;
   struct stat st;
   gint fd;
   guint32 n, offset, pagesize;

   fprintf(stderr, "getting message %d\n", mesg_num);
	fflush(stderr);

   fd = open(mbx, O_RDONLY);
   if (fd == -1)
   {
      perror("open()");
      return NULL;
   }

   if (stat(mbx, &st) == -1)
   {
      perror("stat()");
      close(fd);
      return NULL;
   }

   if (st.st_size)
   {
      pagesize = getpagesize();
      offset = (mailpos[mesg_num - 1] / pagesize) * pagesize;

      p = q = (gchar *)mmap(0, st.st_size, PROT_READ, MAP_PRIVATE, fd, offset);
      if (p == (gchar*)NULL)
      {
         close(fd);
         perror("mmap()");
         return NULL;
      }

      p += mailpos[mesg_num - 1] % pagesize;
      if (mesg_num != 1)
         p++; /* seek to just past the \n */
      n = 0;

      for (r = p; *r != '\0'; r++)
      {
         if (*r == '\n')
         {
            if (!g_strncasecmp(r, "\nFrom ", strlen("\nFrom ")))
            {
               /* skip ahead to the next line */
               for (s = r + strlen("\nFrom "); *s != '\0' && *s != '\n'; s++);
               if (!g_strncasecmp(s, "\nReturn-Path: ", strlen("\nReturn-Path: ")))
               {
                  n = (guint32) (r - p);  /* set the size of the email */
                  break;
               }
            }
         }
      }

      if (*r == '\0')
         n = (guint32) ((r-1) - p);  /* musta been the last email */

      if (n > 0)
      {
         data = g_malloc0(n + 1);
         strncpy(data, p, n);

         /* we should just strip the message here, makes more sense */
         strip(data, '\r');
      }

      munmap(q, st.st_size);
	}

   close(fd);

   return data;
}
