#! --PERL--
##
##
## This module is part of ML and provides some tools

package tools;

use Mail::Internet;
use Mail::Header;
use Conf;
use Language;
use Log;

## RCS identification.
#my $id = '@(#)$Id: tools.pl,v 1.3 1998/12/22 13:52:43 sympa Exp $';

## Sorts the list of adresses by domain name
## Input : users hash
## Sort by domain.
sub sortbydomain {
   my($x, $y) = @_;
   $x = join('.', reverse(split(/[@\.]/, $x)));
   $y = join('.', reverse(split(/[@\.]/, $y)));
   #print "$x $y\n";
   $x cmp $y;
}

## Safefork does several tries before it gives up.
## Do 3 trials and wait 10 seconds between each.
## Exit with a fatal error is fork failed after all
## tests have been exhausted.
sub safefork {
   my($i, $pid);
   
   for ($i = 1; $i < 360; $i++) {
      my($pid) = fork;
      return $pid if (defined($pid));
      do_log ('warning', "Can't create new process in safefork: %m");
      ## should send a mail to the listmaster
      sleep(10 * $i);
   }
   fatal_err("Can't create new process in safefork: %m");
   ## No return.
}

@avoid_hdr = (
        'help',
        'ind(ex)?',
        'lists?',
        '(please\s+)?(add|unsub?(scribe)?|remove|del|sub(\s|scribe)?|sign?o?f?f?)',
        'rev(iew)?\s+\S+',
        'stats\s+\S+',
        'get\s+\S+\s+\S+',
        'set\s+\S+\s+(no)?(mail|conceal|digest)',
        'purge\s+\S+\s+\S+',
        'exp(ire)?\s+\S+\s+\S+\s+\S+',
        'exp(ire)?del\s+\S+',
        'exp(ire)?ind(ex)?\s+\S+',
        'ind(ex)?exp(ire)?\s+\S+',
        'mod(eration)?ind(ex)?\s+\S+',
        'ind(ex)?mod(eration)?\s+\S+',
	'rev(iew)?\s+\S+',
        'dis(tribute)?\s+\S+\s+\S+',
        'rej(ect)?\s+\S+\s+\S+',
        '(re)?con(firm)?\s+\S+',
	'rev(iew)?\s+\S+',
);

## Check for commands in the body of the message. Returns true
## if there are some commands in it.
sub checkcommand {
   my($msg, $sender) = @_;
   do_log('debug2', 'tools::checkcommand(%s)', $sender);

   my($avoid, $i);

   return 0 if ($#{$msg->body} >= 15);  ## More than 15 lines in the text.
   my $hdr = $msg->head;

   ## Check for commands in the subject.
   my $subject = $msg->get('Subject');
   if ($subject) {
      foreach $avoid (@avoid_hdr) {
         if ($subject =~ /^\s*(quiet)?($avoid)(\s+|$)/im) {
            &rejectMessage($msg, $sender);
            return 1;
         }
      }
   }
   foreach $i (@{$msg->body}) {
      foreach $avoid (@avoid_hdr) {
         if ($i =~ /^\s*(quiet)?($avoid)(\s+|$)/im) {  ## Suspicious line
            &rejectMessage($msg, $sender);
            return 1;
         }
      }
      ## Control is only applied to first non-blank line
      last unless $i =~ /^\s*$/;
      
   }
   return 0;
}

sub rejectMessage {
   my($msg, $sender) = @_;
   do_log('debug2', 'tools::rejectMessage(%s)', $sender);

   *REJ = smtp::smtpto($Conf{'request'}, \$sender);
   print REJ "To: $sender\n";
   print REJ "Subject: [sympa] " . Msg(5, 2, "Misadressed message ?") . "\n";
   printf REJ "MIME-Version: %s\n", Msg(12, 1, '1.0');
   printf REJ "Content-Type: text/plain; charset=%s\n", Msg(12, 2, 'us-ascii');
   printf REJ "Content-Transfer-Encoding: %s\n", Msg(12, 3, '7bit');
   print REJ "\n";
   printf REJ Msg(5, 3, "\
Your message has been sent to a list but it seems it contains commands like
subscribe, signoff, help, index, get, ...

If your message did really contain a command, please note that such messages
must be sent to %s only.

If it happens that your message was by mistake considered as containing
commands, then please contact the manager of this service %s
so that he can take care of your problem.

Thank you for your attention.

------ Beginning of the suspect message --------
"), "$Conf{'sympa'}", $Conf{'request'};
   $msg->print(\*REJ);
   print REJ Msg(5, 4, "------- Fin message suspect ---------\n");
   close(REJ);
}

## Return a decoded QP or/and Base64 string
sub decode_string {
    my $text = pop;
    do_log('debug2', 'tools::decode_string(%s)', $text);
    
    
    	## [RFC 2047] encoded-word = "=?" charset "?" encoding "?" encoded text "?="
	while ($text =~ /=\?ISO-8859-1\?(Q|B)\?([^\?]*)\?=/i) {
	    my ($encoding, $encoded_text) = ($1, $2);
	    my $decoded_text;
		    
	    if ($encoding =~ /Q/i) {
		use MIME::QuotedPrint;
		$encoded_text =~ s/_/\=20/g; ## Spaces may be represented by "_"
		$decoded_text = MIME::QuotedPrint::decode($encoded_text);
	    }elsif ($encoding =~ /B/i) {
		use MIME::Base64;
		$decoded_text = MIME::Base64::decode($encoded_text);
	    }
	    $text =~ s/=\?ISO-8859-1\?$encoding\?([^\?]*)\?=/$decoded_text/i;
	} 

    return $text;
}


## return a hash from the edit_list_conf file
sub load_edit_list_conf {

    my $file;
    my $conf ;
    
    if (-r "$Conf{'etc'}/edit_list.conf") {
	$file = "$Conf{'etc'}/edit_list.conf";
    }elsif (-r "--DIR--/bin/edit_list.conf") {
	$file = "--DIR--/bin/edit_list.conf";
    }else {
	&do_log('info','Cannot find edit_list.conf');
	return undef;
    }

    unless (open (FILE, $file)) {
	&do_log('info','Unable to open config file %s', $file);
	return undef;
    }

    while (<FILE>) {
	next if /^\s*(\#.*|\s*)$/;

	if (/^\s*(\S+)\s+(listmaster|privileged_owner|owner|editor|subscriber|any)\s+(read|write|hidden)\s*$/i) {
	    $conf->{$1}{$2} = $3;
	}else{
	    &do_log ('info', 'unknown parameter in %s  (Ignored) %s', "$Conf{'etc'}/edit_list.conf",$_ );
	    next;
	}
    }
    
    close FILE;
    return $conf;
}

sub smime_sign_check {

    my $msgfile = shift;
    my $sender = shift;

    my $is_signed = {};
    $is_signed->{'body'} = undef;   
    $is_signed->{'subject'} = undef;

    my $verify ;

    do_log('debug2', 'tools::smime_sign_check (%s,%s)', $msgfile,$sender);

    ## first step is the msg signing OK
    do_log('debug2', '%s smime -in %s -verify -CApath %s',$Conf{'openssl'},$msgfile,$Conf{'ca_path'});
    $verify = `$Conf{'openssl'} smime -in $msgfile -verify -CApath $Conf{'ca_path'} 2>&1` ;
    if ($? != 0) {
	do_log('debug2', "$verify");
	return $is_signed ;
    }
    ## second step is the message signer match the sender
    my $signer = `$Conf{'openssl'} smime -pk7out -in $msgfile | $Conf{'openssl'} pkcs7 -print_certs -noout`;
    $signer =~ /subject\=\/Email\=([^\/]+\@[^\/]+)\//i ; 
    $signer=$1;
    if ( lc($sender) eq lc($signer)) {
	do_log('debug2', "S/MIME signed message, signature checked and sender($sender) match signer($signer)",$sender,$signer);
	$is_signed->{'body'} = 'signed';
	# futur version should check if the subject was part of the SMIME signature.
	$is_signed->{'subject'} = undef;
    }else{
	do_log('notice', "S/MIME signed message, sender($sender) do NOT match signer($signer)",$sender,$signer);	
    }
    return $is_signed ;    
}

1;












