
foreach $src (@ARGV) {

   unless (open(IN, $src)) {
      print STDERR "Can't read $src: $!\n";
      next;
   }

   my $dest = "$ENV{'INSTALLDIR'}/$src";

   if (-f $dest) {
      print STDERR "Overwriting $dest\n";
   } else {
      print STDERR "Creating $dest\n";
   }
   unless (open(OUT, "> $dest")) {
      print STDERR "Can't write $dest: $!\n";
      close(IN);
      next;
   }
   while (<IN>) {
      s/--PERL--/$ENV{'PERL'}/g;
      s/--CONFIG--/$ENV{'CONFIG'}/g;
      s/--SYMPADIR--/$ENV{'SYMPADIR'}/g;
      s/--INSTALLDIR--/$ENV{'INSTALLDIR'}/g;
      print OUT $_;
   }
   close(OUT);
   close(IN);
#   chown ((getpwnam($ENV{'USER'}))[2,3], $dest);
   chmod oct($ENV{'UMASK'}), $dest;
}
exit(0);
