// $Id: xxl_funcs.hh,v 1.10 1997/01/02 16:15:30 aml Exp $

#ifndef _XXL_FUNCS_DOT_HH_
#define _XXL_FUNCS_DOT_HH_

#include "rpn.hh"
class Sheet;

int month_function(double);
int day_function(double);
int hour_function(double);
int minute_function(double);
int second_function(double);

class If {
    Stack_elem *se;
    int cnt;
    double sum;
    int choice;
  public:
    If();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~If();
};

class Sumif {
    Stack_elem *se;
    int cnt;
    Range rg1,rg2;
    char *cond;
  public:
    Sumif();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Sumif();
};

class Round {
    Stack_elem *se;
    double res;
  public:
    Round();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Round();
};

class Vlookup {
    Stack_elem *se;
    double res;
  public:
    Vlookup();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Vlookup();
};

class Hlookup {
    Stack_elem *se;
    double res;
  public:
    Hlookup();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Hlookup();
};

class Upper {
    Stack_elem *se;
    double res;
  public:
    Upper();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Upper();
};

class Lower {
    Stack_elem *se;
    double res;
  public:
    Lower();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Lower();
};

class Proper {
    Stack_elem *se;
    double res;
  public:
    Proper();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Proper();
};

class Sum {
    Stack_elem *se;
    double sum;

  public:
    Sum();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Sum();
};

class Max {
    Stack_elem *se;
    double max;
  public:
    Max();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Max();
};

class Min {
    Stack_elem *se;
    double min;
  public:
    Min();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Min();
};

class Count {
    Stack_elem *se;
    int count;
  public:
    Count();
    Stack_elem *eval(Stack_elem *, Sheet *sheet, short col, short row);
    ~Count();
};

#endif

/* $log
*/
