// $Id: canvas.hh,v 1.6 1996/09/17 15:16:19 aml Exp $

#define WEST 1
#define CENTER 2
#define EAST 3
#define NORTH 4
#define SOUTH 5

extern "C" {
#include "../canvas/default.h"
#include "../canvas/tclInt.h"
#include "../canvas/tkInt.h"
#include "../canvas/tkPort.h"
#include "../canvas/tkCanvas.h"
int CanvasWidgetCmd(    ClientData ,Tcl_Interp*,int,char **argv);
}

struct canvas;

extern "C" {
  struct canvas *get_canvas_info(char *);
  int cell_col(int,struct canvas *);
  int cell_row(int,struct canvas *);
  int x_coord(int,struct canvas *);
  int y_coord(int,struct canvas *);
  char *coltoa(int col);
  char *coltoa_formated(int col);
  char * cell_name_rc(short col, short row) ;

  extern int *global_col_origin;
  extern int *global_row_origin;
};

void newCanvas(Canvas *c, Tcl_Interp *interp,char *canvas,
               int width,int height);
void deleteCanvas(Canvas *c);

#include "canvas.h"


/* $Log: canvas.hh,v $
 * Revision 1.6  1996/09/17 15:16:19  aml
 * Fixed problems with copying of cells with non-default formats.
 * Created printing formats, alignment formats.
 * Format toolbar now reflects format of active cell.
 *
 * Revision 1.5  1996/08/26 12:08:50  aml
 * Fixed problem with several sheets. Each canvas now has its own
 * canvas info.
 * Fixed scroll up and down. Implemented max_row and max_col.
 * Fairly stable version.
 *
# Revision 1.4  1996/08/23  16:13:38  aml
# Top window resizing now works well.
# Range selection now uses a filled rectangle with overall good results.
# Intermediate version, does not work well.
#
# Revision 1.3  1996/07/23  14:01:13  aml
# Changed canvas widget to handle special items like cell borders.
# Seems to work well. Spreadsheet size is no more limited now.
#
 * Revision 1.2  1996/04/19 10:46:39  aml
 * First cut at speeding up canvas critical functions.
 * CanvasWidgetCommand is now called directly from draw_sheet.
 * Fixed bug in reading values from datafiles. Also works
 * for Suns now.
 * Created canvas directory, replacing builtin command canvas.
 *
 * Revision 1.1  1996/04/18 09:44:05  aml
 * Initial revision
 * */
