/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef classbase_h
#define classbase_h

#include <stdio.h>
#include <gtk/gtk.h>
#include "couleur.h"
#include "define.h"


#define PI 3.14159265359

#define EPAIS 2
#define RI (3/ECHELLE)		// rayon de l'intervalle d'erreur de
				// detection de colision.
		// en pixel il est egal a  RI*ECHELLE

// Caracteristique de la fonte a largeur fixe
#define FIXED_FONT_W 16
#define FIXED_FONT_H 16

//type precis de figure (ie la classe)
enum classe_figure
  {
    POINT_PL = 0,
    POINT_DR = 1,
    POINT_DD = 2,
    POINT_SE = 3,
    POINT_CE = 4,
    POINT_CO = 5,
    POINT_DR_DR = 6,
    POINT_DR_DD = 7,
    POINT_DR_SE = 8,
    POINT_DR_CE = 9,
    POINT_MI_SE = 10,
    POINT_DD_DD = 11,
    POINT_DD_SE = 12,
    POINT_DD_CE = 13,
    POINT_MI_2PT = 14,
    POINT_SE_SE = 15,
    POINT_SE_CE = 16,

    POINT_CE_CE = 18,

    POINT_TR = 20,
    POINT_SY = 21,
    POINT_RE = 22,
    POINT_RO = 23,

    POINT_LI = 24,

    POINT_AR = 25,

    POINT_DR_AR = 26,
    POINT_DD_AR = 27,
    POINT_SE_AR = 28,
    POINT_CE_AR = 29,
    POINT_AR_AR = 30,

    POINT_HO = 31,

    DR_2PT = 300,
    DD_2PT = 301,
    SE_2PT = 302,
    VE_2PT = 303,
    CE_2PT = 304,
    CE_SE = 305,
    CE_VA = 306,
    AC_3PT = 307,


    DR_PA_DR = 400,
    DR_PA_2PT = 401,
    DR_OR_DR = 402,
    DR_OR_2PT = 403,

    DR_TR = 501,
    DR_SY = 502,
    DR_RE = 503,
    DD_TR = 504,
    DD_SY = 505,
    DD_RE = 506,
    SE_TR = 507,
    SE_SY = 508,
    SE_RE = 509,
    CE_TR = 510,
    CE_SY = 511,
    CE_RE = 512,
    VE_TR = 513,
    VE_RE = 514,
    DR_RO = 515,
    DD_RO = 516,
    SE_RO = 517,
    VE_RO = 518,
    CE_RO = 519,
    AR_RE = 520,
    AR_SY = 521,
    AR_TR = 522,
    AR_RO = 523,

    DR_HO = 524,
    DD_HO = 525,
    SE_HO = 526,
    CE_HO = 527,
    VE_HO = 528,
    AR_HO = 529,

    VA_LO_SE = 600,
    VA_NO_VE = 601,
    VA_DI_PT_PT = 602,
    VA_DI_PT_CE = 603,
    VA_DI_PT_DR = 604,
    VA_PE_CE = 605,
    VA_AN_3PT = 606,
    VA_AN_2VE = 607,
    VA_AB_PT = 608,
    VA_OR_PT = 609,
    VA_AB_VE = 610,
    VA_OR_VE = 611,
    VA_LI = 612,
    VA_PE_DR = 613,

    EQ_DR = 700,
    EQ_CE = 701,

    LI_PT_DR = 800,
    LI_PT_DD = 801,
    LI_PT_SE = 802,
    LI_PT_CE = 803,
    LI_PT_LI_PT = 804		// lieu de point selon point sur lieu
  };

//Type de famille de figure (ie une groupe de classe)
enum type_figure
  {
    NO_OBJET = 0,
    FIG_POINT = 1,
    FIG_DROITE = 2,
    FIG_SEGMENT = 3,
    FIG_DEMI_DROITE = 4,
    FIG_NOMBRE = 5,
    FIG_REPERE = 6,
    FIG_EQUATION_R = 7,
    FIG_EQUATION_C = 8,
    FIG_VECTEUR = 9,
    FIG_CERCLE = 10,
    FIG_VALEUR = 11,
    FIG_EQUATION = 12,
    FIG_LIEU_PT = 13,
    FIG_ARC_CERCLE = 14,
    PLAN = 127
  };

//Flag pour cas_possible
#define NO_VALIDE 0
#define VALIDE 1

// type d'unite des classe angle
#define DEGRES 1
#define GRADE 2
#define RADIAN 3

//Style pour la classe point
// #define RAYON     (int)(ECHELLE/3)               // must be screen witdh
// dependant
#define RAYON     3
#define ROND      1
#define CROIX     2
#define CARRE     3

// Parametre pour les lieux geometrique
// On calcule des points du lieu de
// [-PAS_LIEU*NB_PT_LIEU/2+O;PAS_LIEU*NB_PT_LIEU/2+O]
#define NB_PT_LIEU_SE 100
#define NB_PT_LIEU_CE 100
#define NB_PT_LIEU_DR 200
#define NB_PT_LIEU_DD 200
#define NB_PT_LIEU_LI 200

#define FERME_LIEU UNIT_ECRtoMON(30)	// soit 5 pixels pour ferme le lieu (test
				       // dans lieu_point_c::dessine)
#define PAS_LIEU  15		// tout les combien de pixel on determine un
				// point du lieu

// Rappel du codage de l'aspect des objets
// Style : R000SSSS    R=1 objet rempli  SSSS=style (pour les points)
// Epaisseur : 0 1 2 3   : 0 transparent, 1 pointille, 2 normal, 3 epais
// Couleur : couleur de l'objet

// variable externe
extern double ECHELLE, ORIGIN_W, ORIGIN_H, MON_L, MON_R, MON_T, MON_B;
// Declaration de la classe mere 'figure_c' et point_c droite_c....
// de la classe cercle_c et de structures
typedef struct vecteur_s
  {
    double x, y;
  }
vecteur_s;
vecteur_s operator + (vecteur_s v1, vecteur_s v2);	// v1+v2

vecteur_s operator - (vecteur_s v1);	// -v1

vecteur_s operator - (vecteur_s v1, vecteur_s v2);	// v1-v2

double operator *(vecteur_s v1, vecteur_s v2);	// v1*v2

vecteur_s operator *(vecteur_s v1, double k);	// v1*k

vecteur_s operator *(double k, vecteur_s v1);	// k*v1

vecteur_s operator / (vecteur_s v1, double k);	// v1/k
#define point_s vecteur_s
typedef struct droite_s
  {
    point_s a, b;
  }
droite_s;
typedef struct param_droite
  {
    double a, b, c;
  }
param_droite;


//Masque status with 'masque'
// TRUE   :             objet masque
// FALSE  :             objet apparent
// -2     :    l'objet est issue d'une macro-construction
#define OBJET_MASQUE TRUE
#define OBJET_APPARENT FALSE
#define OBJET_MACRO -2

extern int objet_issue_macro_construction;

// Declaration de la classe liste chainee
// Attention : les objets pointes de la listes doivent etre detruits
// explicitement
// ---------    avant la destruction de la liste
class elem
{
  friend class liste_elem;
    public:
    elem * suivant;
  void *fig;
    elem (void)
  {
    fig = NULL;
    suivant = (elem *) NULL;
  }
};
class liste_elem
{
  public:
  elem * debut, *courant, *lecture;
  int nb_elem;
    liste_elem (void)
  {
    lecture = debut = courant = new (elem);
    nb_elem = 0;
  }
   ~liste_elem (void)
  {
    elem *p;
    while (debut->suivant != NULL)
      {
	p = debut->suivant;
	delete (debut);
	debut = p;
      }
    delete (debut);
  }
  liste_elem (liste_elem & l);
  int ajoute (void *fig);
  int supprime (void *fig);
  int position (void *fig);
  void init_lire (void);
  void *lire (int pos);
  void vide (void);
};
// Fonctions assocciees a liste_elem
char contenue (liste_elem & l1, liste_elem & l2);
// l1 inclue dans l2 ? (suppose sans repetition)
liste_elem & concatene (liste_elem & l1, liste_elem & l2);
// concatene l1,l2 dans l1 sans repetition
char liste_elem_egale (liste_elem & l1, liste_elem & l2);
// l1 et l2 sont-elles egales ?


// Declaration des types de bases noyau_macro et macro
// structure de liste_parent
// 0            nb_parent
// 4            numero parent 1
// 8            numero parent 2
// ..     ..
class noyau_macro
{
  friend class macro;
    public:
    noyau_macro * suivant;
  int type, *liste_parent;
  // le type se rapport soit a 'classe'(precis) 
  // soit a 'type'(groupe de classe d'objet) (si c'est un param_i)

  void *fig;
  // adresse de la figure correspondant au noyau lors de la creation de la macro
  // utile lors de la creation de la macro et de son fonctionnement pour
  // stocker l'@ de l'objet cree a partir de ce noyau

  int param_f;
  // Flag pour signifier si ce noyau represente  une figure finale

  int signe;
  // parametre supplementaire pour pts intersection cercle et xxx

    noyau_macro (void)
  {
    suivant = (noyau_macro *) NULL;
    liste_parent = (int *) NULL;
  }
};

class macro
{
  public:
  noyau_macro * debut, *courant, *lecture;

  int version;
  // numero de version de la macro

  int param_i, param_f, nb_noyau;
  // nb d'arguments initiaux et finaux de la macro, nb total de noyau

  char nom[MACRO_NAME_WIDTH];
  // nom de la macro

  char info[MACRO_TEXT_INFO];
  // information texte sur la macro

    macro (int pi, int pf, char *name)
  {
    lecture = debut = courant = new (noyau_macro);
    param_i = pi;
    param_f = pf;
    nb_noyau = 0;
    strcpy (nom, name);
    strcpy (info, name);
    version = MAC_VERSION;
  }
   ~macro (void)
  {
    noyau_macro *p;
    while (debut->suivant != NULL)
      {
	p = debut->suivant;
	delete (debut);
	debut = p;
      }
    delete (debut);
  }
  int ajoute (int *parent, int type_objet, void *objet, int flag, int signe);
  // retourne la position d'insertion ou l'emplacement si le noyau existe deja

  int position (void *fig);
  // cherhce la position de fig dans les noyaux (utile lors de la creation de la macro)

  void init_lire (void);

  noyau_macro *lire (int pos);
  // retourne l'@ du noyau de la pos eme

  void vide (void);
};

class figure_c
{
  friend class liste_elem;
    public:
  unsigned char couleur, epaisseur, style;
  char masque, type, existe;	// type de figure

  char signe, libre;		// pour les intersections double cercle et
  // xxx, etc
  // libre: figure libre sur objet ou fixe(non deplacable)

  char nom_type[LONGUEUR_NOM_TYPE];	// nom du type d'objet

  char nom[LONGUEUR_NOM];	// nom de l'objet

  int classe;
    figure_c (void)
  {
    couleur = NOIR;
    if (objet_issue_macro_construction)
      masque = OBJET_MACRO;
    else
      masque = OBJET_APPARENT;
    libre = FALSE;
    epaisseur = 2;
    style = 1;
    existe = TRUE;
    nom_type[0] = 0;
    nom[0] = 0;
  }
  figure_c (char a, char b, char c, char d)
  {
    couleur = a;
    if (objet_issue_macro_construction)
      masque = OBJET_MACRO;
    else
      masque = b;
    epaisseur = c;
    style = d;
    existe = TRUE;
    libre = FALSE;
    nom_type[0] = 0;
    nom[0] = 0;
  }
  virtual void dessine (GdkPixmap * ecran, char force) = 0;
  virtual void actualise (void) = 0;
  virtual char appartient (int xm, int ym) = 0;
  virtual void move (int mx, int my) = 0;
  virtual char dependance (figure_c * fig) = 0;
  virtual liste_elem *parents (liste_elem * liste_parent)
  {
    return (liste_elem *) NULL;
  };
  virtual void sauve_disk (FILE * f)
  {
  };				// A changer -> '=0'

  virtual void lire_disk (FILE * f)
  {
  };
  virtual void init_nom (void) = 0;
};

// Base class for point object
class point_c:public figure_c
{
  public:
  point_s p;
  point_c (void):figure_c ()
  {
    type = FIG_POINT;
    classe = POINT_PL;
  }
  point_c (char a, char b, char c, char d):figure_c (a, b, c, d)
  {
    type = FIG_POINT;
    classe = POINT_PL;
  }
  point_s coordonnees (void);
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  virtual void move (int mx, int my);
  virtual void sauve_disk (FILE * f);
  virtual void lire_disk (FILE * f);
  virtual char dependance (figure_c * fig)
  {
    return FALSE;
  };
  virtual void init_nom (void);
};
// Classe de base valeur_c
class valeur_c:public figure_c
{
  public:
  point_s p;
  double val;
  char unite;			// sert pour la rotaion et l'affichage de des 
  // 
  // angles

    valeur_c (void):figure_c ()
  {
    couleur = BLEU_FONCE;
    type = FIG_VALEUR;
    p.x = 0;
    p.y = 0;
    unite = RADIAN;
  }
  valeur_c (double mx, double my):figure_c ()
  {
    type = FIG_VALEUR;
    init_nom ();
    p.x = mx;
    couleur = BLEU_FONCE;
    p.y = my;
    unite = RADIAN;
  }
  valeur_c (double mx, double my, char a, char b, char c, char d):figure_c (a, b, c, d)
  {
    type = FIG_VALEUR;
    p.x = mx;
    p.y = my;
  }
  virtual void init_nom (void);
  virtual void dessine (GdkPixmap * ecran, char force);
  virtual char appartient (int xm, int ym);
  void move (int xm, int ym);
  double valeur (void);
};
// Classe de base 'cercle_c'
class cercle_c:public figure_c
{
  public:
  point_c * C;			// le centre

  cercle_c (void):figure_c ()
  {
    type = FIG_CERCLE;
  }
  cercle_c (char a, char b, char c, char d):figure_c (a, b, c, d)
  {
    type = FIG_CERCLE;
  }
  virtual void init_nom (void);
  virtual double rayon () = 0;
  virtual point_s centre ();
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  virtual void move (int xm, int ym);
};
// Classe de base 'arc_cercle_c'
class arc_cercle_c:public figure_c
{
  public:
  point_s center;
  double radius, origin, length;
    arc_cercle_c (void):figure_c ()
  {
    type = FIG_ARC_CERCLE;
  }
  arc_cercle_c (char a, char b, char c, char d):figure_c (a, b, c, d)
  {
    type = FIG_ARC_CERCLE;
  }
  virtual void init_nom (void);
  virtual double rayon () = 0;
  virtual point_s centre () = 0;
  // signed arc origin in intervalle [ - PI ; PI [
  virtual double arc_origin () = 0;
  // signed arc length in intervalle [ - 2PI ; 2PI [
  virtual double arc_length () = 0;
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  virtual void move (int xm, int ym);
};
// Classe de base 'droite_c'
class droite_c:public figure_c
{
  public:
  point_c * M1;
  droite_s p;
    droite_c (void):figure_c ()
  {
    type = FIG_DROITE;
  }
  droite_c (char a, char b, char c, char d):figure_c (a, b, c, d)
  {
    type = FIG_DROITE;
  }
  virtual void init_nom (void);
  virtual droite_s coordonnees (void) = 0;
  virtual vecteur_s normal (void);
  virtual vecteur_s directeur (void);
  double longueur (void);	// distance entre les deux points definissant 
  // 
  // l'objet

  virtual double pente (void);
  virtual void dessine (GdkPixmap * ecran, char force);
  virtual char appartient (int xm, int ym);
  virtual void move (int xm, int ym);
  param_droite parametre (void);
};
// Classe de base lieu_c
class lieu_point_c:public figure_c
{
  public:
// Le mobile peut etre un point sur segement,demi-droite,droite,cercle
  point_c * lieu, *mobile;
  point_s *liste_point;		// pour stocker le lieu du point 'lieu'

  int max_nb_objet_sur_lieu, nb_objet_sur_lieu;
    lieu_point_c (int nb_pt):figure_c ()
  {
    max_nb_objet_sur_lieu = nb_pt;
    type = FIG_LIEU_PT;
    liste_point = new point_s[max_nb_objet_sur_lieu];
  }
  lieu_point_c (liste_elem & lp, int nb_pt):figure_c ()
  {
    max_nb_objet_sur_lieu = nb_pt;
    type = FIG_LIEU_PT;
    liste_point = new point_s[max_nb_objet_sur_lieu];
  }
  virtual ~ lieu_point_c (void)
  {
    delete liste_point;
  }
  void init_nom (void);
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  void move (int xm, int ym)
  {
  };
  char dependance (figure_c * fig);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
};

// Classe demi_droite
class demi_droite_c:public droite_c
{
  public:
  demi_droite_c (void):droite_c ()
  {
    type = FIG_DEMI_DROITE;
  }
  demi_droite_c (char a, char b, char c, char d):droite_c (a, b, c, d)
  {
    type = FIG_DEMI_DROITE;
  }
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  vecteur_s directeur (void);	// Argh il faut l'oppose de celui pris pour
  // les droites

  virtual void init_nom (void);
};
// Classe segment
class segment_c:public droite_c
{
  public:
  segment_c (void):droite_c ()
  {
    type = FIG_SEGMENT;
  }
  segment_c (char a, char b, char c, char d):droite_c (a, b, c, d)
  {
    type = FIG_SEGMENT;
  }
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  virtual void init_nom (void);
};
// Classe vecteur
class vecteur_c:public droite_c
{
  public:
  vecteur_c (void):droite_c ()
  {
    type = FIG_VECTEUR;
  }
  vecteur_c (char a, char b, char c, char d):droite_c (a, b, c, d)
  {
    type = FIG_VECTEUR;
  }
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  virtual vecteur_s vecteur () = 0;
  virtual void init_nom (void);
};

// Common functions used by the geometric object
char lire_parametre_base (FILE * fichier, figure_c * fig);
char sauver_parametre_base (FILE * fichier, figure_c * fig);
point_s reflexion_p (droite_c * axe, point_s pt);
point_s rotation_p (point_c * centre, valeur_c * angle, point_s pt);
vecteur_s reflexion_v (droite_c * axe, vecteur_s v);
vecteur_s rotation_v (valeur_c * angle, vecteur_s v);
// Associated function for intersection with circle object
point_s *inter_cercle_droite (point_s & u1, point_s & pt1, point_s & centre, double rayon, char k);
point_s *inter_cercle_droite_cart (param_droite para, point_s * centre, double rayon, char k);
point_s *cramer (param_droite d1, param_droite d2);

#endif
