/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef coordonnees_h
#define coordonnees_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Classes in charge of point and vector coordinate
class abscisse_point:public valeur_c
{
  public:
  point_c * pt;
  abscisse_point (void):valeur_c ()
  {
    classe = VA_AB_PT;
  }
  abscisse_point (liste_elem & lp, double mx, double my):valeur_c ()
  {
    classe = VA_AB_PT;
    pt = (point_c *) lp.lire (1);
    p = pt->coordonnees ();
    p.x = mx - p.x;
    p.y = my - p.y;
    init_nom ();
  }
abscisse_point (liste_elem & lp):valeur_c ()
  {
    classe = VA_AB_PT;
    pt = (point_c *) lp.lire (1);
    init_nom ();
  }
  virtual void init_nom (void);
  void dessine (GdkPixmap * ecran, char force);
  char appartient (int xm, int ym);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
class ordonnee_point:public abscisse_point
{
  public:
  ordonnee_point (void):abscisse_point ()
  {
    classe = VA_OR_PT;
  }
  ordonnee_point (liste_elem & lp, double mx, double my):abscisse_point (lp, mx, my)
  {
    classe = VA_OR_PT;
    init_nom ();
  }
ordonnee_point (liste_elem & lp):abscisse_point (lp)
  {
    classe = VA_OR_PT;
    init_nom ();
  }
  void actualise (void);
  virtual void init_nom (void);
};
class abscisse_vecteur:public valeur_c
{
  public:
  vecteur_c * v;
  abscisse_vecteur (void):valeur_c ()
  {
    classe = VA_AB_VE;
  }
  abscisse_vecteur (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    classe = VA_AB_VE;
    v = (vecteur_c *) lp.lire (1);
    init_nom ();
  }
abscisse_vecteur (liste_elem & lp):valeur_c ()
  {
    classe = VA_AB_VE;
    v = (vecteur_c *) lp.lire (1);
    init_nom ();
  }
  void actualise (void);
  virtual void init_nom (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
class ordonnee_vecteur:public abscisse_vecteur
{
  public:
  ordonnee_vecteur (void):abscisse_vecteur ()
  {
    classe = VA_OR_VE;
  }
  ordonnee_vecteur (liste_elem & lp, double mx, double my):abscisse_vecteur (lp, mx, my)
  {
    classe = VA_OR_VE;
    init_nom ();
  }
ordonnee_vecteur (liste_elem & lp):abscisse_vecteur (lp)
  {
    classe = VA_OR_VE;
    init_nom ();
  }
  void actualise (void);
  virtual void init_nom (void);
};

#endif
