
/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "demi_droite.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;
extern int h_ecran, w_ecran;


// Common methods for half-line object
void demi_droite_c::
init_nom (void)
{
  char tmp[8];
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this half-line %1"));
  strinsmsg (nom_type, nom, "%1");
}
vecteur_s demi_droite_c::
directeur (void)
{
  vecteur_s d;
  double m;
  d.x = p.b.x - p.a.x;
  d.y = p.b.y - p.a.y;
  m = sqrt (d.x * d.x + d.y * d.y);
  if (m == 0)
    m = 1;
  d.x /= m;
  d.y /= m;
  return d;
}
void demi_droite_c::
dessine (GdkPixmap * ecran, char force)
{
  long signed c[2][2], xa, xb, ya, yb;
  char dehors_ecran = TRUE;	// indique si la demi-droite est entierement
  // dehors

  double b, d, x, y;
  droite_s co;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  co = coordonnees ();
  xa = ECRx (co.a.x);
  ya = ECRy (co.a.y);
  xb = ECRx (co.b.x);
  yb = ECRy (co.b.y);
  if (xa == xb && ya == yb)
    return;
  if (xa == xb)
    {
      c[0][0] = c[1][0] = xa;
      c[0][1] = ya;
      if (ya > yb)
	c[1][1] = 0;
      else
	c[1][1] = h_ecran;
      dehors_ecran = FALSE;
    }
  else
    {
      d = (co.a.y - co.b.y) / (co.a.x - co.b.x);	// pente

      if (d == 0)
	{
	  c[0][0] = xa;
	  c[0][1] = c[1][1] = ya;
	  if (xb > xa)
	    c[1][0] = w_ecran;
	  else
	    c[1][0] = 0;
	  dehors_ecran = FALSE;
	}
      else
	{
	  c[0][0] = xa;
	  c[0][1] = ya;
	  b = co.a.y - d * co.a.x;	// ordonne a  l'origine

	  y = d * MON_L + b;
	  if (y >= MON_B && y < MON_T && xb < xa && xa > 0)
	    {
	      c[1][0] = 0;
	      c[1][1] = ECRy (y);
	      dehors_ecran = FALSE;
	      goto aff_demi_droite;
	    }
	  y = d * MON_R + b;
	  if (y >= MON_B && y < MON_T && xb > xa && xa < w_ecran)
	    {
	      c[1][0] = w_ecran;
	      c[1][1] = ECRy (y);
	      dehors_ecran = FALSE;
	      goto aff_demi_droite;
	    }
	  x = (MON_B - b) / d;
	  if (x >= MON_L && x < MON_R && yb > ya && ya < h_ecran)
	    {
	      c[1][0] = ECRx (x);
	      c[1][1] = h_ecran;
	      dehors_ecran = FALSE;
	      goto aff_demi_droite;
	    }
	  x = (MON_T - b) / d;
	  if (x >= MON_L && x < MON_R && yb < ya && ya > 0)
	    {
	      c[1][0] = ECRx (x);
	      c[1][1] = 0;
	      dehors_ecran = FALSE;
	      goto aff_demi_droite;
	    }
	}
    }
aff_demi_droite:
  if (dehors_ecran)
    return;
  switch (epaisseur)
    {
    case 0:
      dotted_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, 1);
      break;
    case 1:
      dotted_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, 2);
      break;
    case 2:
      gline (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur);
      break;
    case 3:
      thick_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, EPAIS);
      break;
    }
}
char demi_droite_c::
appartient (int xm, int ym)
{
  droite_s co;
  vecteur_s n, ab;
  double x, y;
  n = normal ();
  if (n.x == 0 && n.y == 0)
    return M1->appartient (xm, ym);
  co = coordonnees ();
  x = MONx (xm) - co.a.x;
  y = MONy (ym) - co.a.y;
  ab.x = co.b.x - co.a.x;
  ab.y = co.b.y - co.a.y;
  if (ABS (x * n.x + y * n.y) >= RI || (x * ab.x + y * ab.y) < 0)
    return FALSE;
  return TRUE;
}
// half-line defined by two points
char demi_droite1::
dependance (figure_c * fig)
{
  return (M1 == fig || M2 == fig);
}
droite_s demi_droite1::
coordonnees (void)
{
  p.a = M1->p;
  p.b = M2->p;
  return p;
}
void demi_droite1::
actualise (void)
{
  if (!M1->existe || !M2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p.a = M1->coordonnees ();
  p.b = M2->coordonnees ();
  if (ECRx (p.a.x) == ECRx (p.b.x) && ECRy (p.a.y) == ECRy (p.b.y))
    existe = FALSE;
}
liste_elem *demi_droite1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) M2);
  return liste_parent;
}
void demi_droite1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  M2->move (xm, ym);
  actualise ();
}
void demi_droite1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) M2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void demi_droite1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  M2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
void demi_droite1::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this half-line %1"));
  if ((strlen (M1->nom) + strlen (M2->nom) + 3) <= LONGUEUR_NOM && strlen (M1->nom) != 0 && strlen (M2->nom) != 0)
    sprintf (nom, "[%s%s)", M1->nom, M2->nom);
  strinsmsg (nom_type, nom, "%1");
}
// Transformed half-line
// By reflexion
char reflexion_demi_droite::
dependance (figure_c * fig)
{
  return (axe == fig || demi_droite == fig);
}
droite_s reflexion_demi_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = demi_droite->coordonnees ();
  co1.a = reflexion_p (axe, co.a);
  co1.b = reflexion_p (axe, co.b);
  return co1;
}
void reflexion_demi_droite::
actualise (void)
{
  if (!demi_droite->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s reflexion_demi_droite::
normal (void)
{
  return reflexion_v (axe, demi_droite->normal ());
}
vecteur_s reflexion_demi_droite::
directeur (void)
{
  return reflexion_v (axe, demi_droite->directeur ());
}
void reflexion_demi_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) demi_droite);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_demi_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  demi_droite = (demi_droite_c *) liste_figure.lire (pos);
  init_nom ();
}
// By symetry
char symetrie_demi_droite::
dependance (figure_c * fig)
{
  return (symetrie == fig || demi_droite == fig);
}
droite_s symetrie_demi_droite::
coordonnees (void)
{
  droite_s co, co1;
  point_s c;
  c = 2 * (symetrie->coordonnees ());
  co = demi_droite->coordonnees ();
  co1.a = c - co.a;
  co1.b = c - co.b;
  return co1;
}
void symetrie_demi_droite::
actualise (void)
{
  if (!demi_droite->existe || !symetrie->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s symetrie_demi_droite::
normal (void)
{
  return -(demi_droite->normal ());
}
vecteur_s symetrie_demi_droite::
directeur (void)
{
  return -(demi_droite->directeur ());
}
void symetrie_demi_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) symetrie);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) demi_droite);
  fwrite (&pos, 1, sizeof (pos), f);
}
void symetrie_demi_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  symetrie = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  demi_droite = (demi_droite_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_demi_droite::
dependance (figure_c * fig)
{
  return (v == fig || demi_droite == fig);
}
droite_s translation_demi_droite::
coordonnees (void)
{
  droite_s co, co1;
  vecteur_s t;
  t = v->vecteur ();
  co = demi_droite->coordonnees ();
  co1.a = co.a + t;
  co1.b = co.b + t;
  return co1;
}
void translation_demi_droite::
actualise (void)
{
  if (!demi_droite->existe || !v->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s translation_demi_droite::
normal (void)
{
  return demi_droite->normal ();
}
vecteur_s translation_demi_droite::
directeur (void)
{
  return demi_droite->directeur ();
}
liste_elem *translation_demi_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) demi_droite);
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void translation_demi_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) demi_droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_demi_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  demi_droite = (demi_droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_demi_droite::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || demi_droite == fig);
}
droite_s rotation_demi_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = demi_droite->coordonnees ();
  co1.a = rotation_p (c, v, co.a);
  co1.b = rotation_p (c, v, co.b);
  return co1;
}
void rotation_demi_droite::
actualise (void)
{
  if (!demi_droite->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s rotation_demi_droite::
normal (void)
{
  return rotation_v (v, demi_droite->normal ());
}
vecteur_s rotation_demi_droite::
directeur (void)
{
  return rotation_v (v, demi_droite->directeur ());
}
void rotation_demi_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) demi_droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_demi_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  demi_droite = (demi_droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_demi_droite::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || demi_droite == fig);
}
droite_s homothetie_demi_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = demi_droite->coordonnees ();
  co1.a = c->p + (co.a - c->p) * v->val;
  co1.b = c->p + (co.b - c->p) * v->val;
  return co1;
}
void homothetie_demi_droite::
actualise (void)
{
  if (!demi_droite->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s homothetie_demi_droite::
normal (void)
{
  return (demi_droite->normal ());
}
vecteur_s homothetie_demi_droite::
directeur (void)
{
  return (demi_droite->directeur ());
}
void homothetie_demi_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) demi_droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_demi_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  demi_droite = (demi_droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
