
/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef equation_h
#define equation_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class equation of line and circle
class equation_droite:public figure_c
{
  public:
  droite_c * d;
  point_s p;
    equation_droite (void):figure_c ()
  {
    classe = EQ_DR;
    type = FIG_EQUATION;
  }
  equation_droite (liste_elem & lp, double mx, double my):figure_c ()
  {
    p.x = mx;
    p.y = my;
    couleur = BLEU_FONCE;
    classe = EQ_DR;
    type = FIG_EQUATION;
    d = (droite_c *) lp.lire (1);
    init_nom ();
  }
equation_droite (liste_elem & lp):figure_c ()
  {
    p.x = 0;
    p.y = 0;
    couleur = BLEU_FONCE;
    classe = EQ_DR;
    type = FIG_EQUATION;
    d = (droite_c *) lp.lire (1);
    init_nom ();
  }
  void actualise (void)
  {
    existe = d->existe;
  };
  void dessine (GdkPixmap * ecran, char force);
  virtual void init_nom (void);
  char appartient (int xm, int ym);
  void move (int mx, int my);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
class equation_cercle:public figure_c
{
  public:
  cercle_c * c;
  point_s p;
    equation_cercle (void):figure_c ()
  {
    classe = EQ_CE;
    type = FIG_EQUATION;
  }
  equation_cercle (liste_elem & lp, double mx, double my):figure_c ()
  {
    p.x = mx;
    p.y = my;
    couleur = BLEU_FONCE;
    classe = EQ_CE;
    type = FIG_EQUATION;
    c = (cercle_c *) lp.lire (1);
    init_nom ();
  }
equation_cercle (liste_elem & lp):figure_c ()
  {
    p.x = 0;
    p.y = 0;
    couleur = BLEU_FONCE;
    classe = EQ_CE;
    type = FIG_EQUATION;
    c = (cercle_c *) lp.lire (1);
    init_nom ();
  }
  void actualise (void)
  {
    existe = c->existe;
  };
  void dessine (GdkPixmap * ecran, char force);
  virtual void init_nom (void);
  char appartient (int xm, int ym);
  void move (int mx, int my);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

#endif
