













/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "lieu.h"
#include "point.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;

// Common method for locus object
void lieu_point_c::
dessine (GdkPixmap * ecran, char force)
{
  int b, x1, y1, x2, y2;
  char fermer;
  point_s *p_old, *p_new;
  point_s co;
  if ((masque == OBJET_MACRO) || (masque && !force) || !existe)
    return;
  p_new = &liste_point[0];
  x2 = ECRx (p_new->x);
  y2 = ECRy (p_new->y);
  for (b = 1; b < nb_objet_sur_lieu; b++)
    {
      p_old = p_new;
      p_new = &liste_point[b];
      if (ABS (p_old->x - p_new->x) < FERME_LIEU && ABS (p_old->y - p_new->y) < FERME_LIEU)
	fermer = TRUE;
      else
	fermer = FALSE;
      x1 = x2;
      y1 = y2;
      x2 = ECRx (p_new->x);
      y2 = ECRy (p_new->y);
      switch (epaisseur)
	{
	case 0:
	  if (fermer)
	    dotted_line (ecran, x1, y1, x2, y2, couleur, 1);
	  else
	    plotpixel (ecran, x2, y2, couleur);
	  break;
	case 1:
	  if (fermer)
	    dotted_line (ecran, x1, y1, x2, y2, couleur, 2);
	  else
	    plotpixel (ecran, x2, y2, couleur);
	  break;
	case 2:
	  if (fermer)
	    line_good_clip (ecran, x1, y1, x2, y2, couleur);
	  else
	    plotpixel (ecran, x2, y2, couleur);
	  break;
	case 3:
	  if (fermer)
	    thick_line (ecran, x1, y1, x2, y2, couleur, EPAIS);
	  else
	    rectanglefilled (ecran, x2 - EPAIS, y2 - EPAIS, EPAIS << 1, EPAIS << 1, couleur);
	  break;
	}
    }
  p_old = &liste_point[0];
  x1 = (int) (p_old->x - p_new->x);
  y1 = (int) (p_old->y - p_new->y);
  if (ABS (x1) < FERME_LIEU && ABS (y1) < FERME_LIEU)
    {
      x1 = ECRx (p_old->x);
      y1 = ECRy (p_old->y);
      x2 = ECRx (p_new->x);
      y2 = ECRy (p_new->y);
      switch (epaisseur)
	{
	case 0:
	  dotted_line (ecran, x1, y1, x2, y2, couleur, 1);
	  break;
	case 1:
	  dotted_line (ecran, x1, y1, x2, y2, couleur, 2);
	  break;
	case 2:
	  line_good_clip (ecran, x1, y1, x2, y2, couleur);
	  break;
	case 3:
	  thick_line (ecran, x1, y1, x2, y2, couleur, EPAIS);
	  break;
	}
    }
}
char lieu_point_c::
appartient (int xm, int ym)
{
  double x, y;
  point_s *pt;
  int b;
  for (b = 0; b < nb_objet_sur_lieu; b++)
    {
      pt = &liste_point[b];
      x = MONx (xm) - pt->x;
      y = MONy (ym) - pt->y;
      if (ABS (x) < RI && ABS (y) < RI)
	return TRUE;
    }
  return FALSE;
}
void lieu_point_c::
init_nom (void)
{
  char *parent_mobile;
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("%1's locus when %2 describes %3"));
  switch (classe)
    {
    case LI_PT_DR:
      parent_mobile = ((point_sur_droite *) mobile)->parent->nom;
      break;
    case LI_PT_DD:
      parent_mobile = ((point_sur_demi_droite *) mobile)->parent->nom;
      break;
    case LI_PT_SE:
      parent_mobile = ((point_sur_segment *) mobile)->parent->nom;
      break;
    case LI_PT_CE:
      parent_mobile = ((point_sur_cercle *) mobile)->parent->nom;
      break;
    case LI_PT_LI_PT:
      parent_mobile = ((point_sur_lieu *) mobile)->parent->nom;
      break;
    }
  if ((strlen (lieu->nom) + strlen (mobile->nom) + strlen (nom_type) + strlen (parent_mobile) + 1) <= LONGUEUR_NOM_TYPE)
    {
      strinsmsg (nom_type, parent_mobile, "%3");
      strinsmsg (nom_type, mobile->nom, "%2");
      strinsmsg (nom_type, lieu->nom, "%1");
    }
  if ((strlen (lieu->nom) + strlen (mobile->nom) + 1) <= LONGUEUR_NOM)
    {
      strcpy (nom, mobile->nom);
      strcat (nom, lieu->nom);
    }
  else
    {
      // 'l' name
      nom[0] = 76;
      nom[1] = 0;
    }
}
char lieu_point_c::
dependance (figure_c * fig)
{
  return (lieu == fig || mobile == fig);
}
liste_elem *lieu_point_c::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) lieu);
  liste_parent->ajoute ((void *) mobile);
  return liste_parent;
}
void lieu_point_c::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) lieu);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) mobile);
  fwrite (&pos, 1, sizeof (pos), f);
}
void lieu_point_c::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  lieu = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  mobile = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// Member functions of lieu_point_mobile_sur_droite
// mobile on a line
void lieu_point_mobile_sur_droite::
actualise ()
{
  int mvx, mvy, b, pos, lieu_pos;
  vecteur_s h, n, u;
  droite_s co;
  double abscisse, xm0, pas;
  existe = mobile->existe;
  if (!existe)
    return;
// we seek H, the orthogonal projection of O on the line (= the shortest point to O on the line)
  co = ((point_sur_droite *) mobile)->parent->coordonnees ();
  n = ((point_sur_droite *) mobile)->parent->normal ();
  u = ((point_sur_droite *) mobile)->parent->directeur ();
  abscisse = co.a * n;
  h.x = abscisse * n.x;
  h.y = abscisse * n.y;
  // H abscissa on the line
  abscisse = (h - co.a) * u;

  pas = UNIT_ECRtoMON (PAS_LIEU);
  xm0 = abscisse - pas * max_nb_objet_sur_lieu / 2;

  abscisse = ((point_sur_droite *) mobile)->xm;
  pos = liste_figure.position ((figure_c *) mobile);
  lieu_pos = liste_figure.position ((figure_c *) this);
  // we want to build the locus, its childs must't rely on it
  existe = false;
  for (b = 0, nb_objet_sur_lieu = 0; b < max_nb_objet_sur_lieu; b++, xm0 += pas)
    {
      ((point_sur_droite *) mobile)->xm = xm0;
      mise_a_jour (pos, lieu_pos, FALSE);
      if (lieu->existe)
	liste_point[nb_objet_sur_lieu++] = lieu->coordonnees ();
    }
  ((point_sur_droite *) mobile)->xm = abscisse;
  mise_a_jour (pos, lieu_pos, FALSE);
  if (nb_objet_sur_lieu == 0)
    existe = FALSE;
  else
    existe = TRUE;
}
// Member functions of class 'lieu_point_mobile_sur_cercle'
// mobile on a circle
void lieu_point_mobile_sur_cercle::
actualise ()
{
  // I try there an adapdive sample rate, but no yet good
  int pos, lieu_pos, checkd = FALSE;
  int statut = 2;		/* 0 : pt too close, 1 : pt too far */
  double abscisse, pas, xm0;
  double pasmin, pasmax, paso, dmin, dmax, d;
  point_s pt_old, pt_next;
  vecteur_s v;
  existe = mobile->existe;
  if (!existe)
    return;
  abscisse = ((point_sur_cercle *) mobile)->xm;
  pos = liste_figure.position ((figure_c *) mobile);
  lieu_pos = liste_figure.position ((figure_c *) lieu);
  pas = paso = (2 * PI) / max_nb_objet_sur_lieu;
  pasmin = pas / 2;
  pasmax = 1;
  dmin = UNIT_ECRtoMON (5);
  dmax = UNIT_ECRtoMON (30);
  pt_old.x = 0;
  pt_old.y = 0;
  // we want to build the locus, its childs must't rely on it
  existe = false;

  for (xm0 = 0, nb_objet_sur_lieu = 0; xm0 < 2 * PI && nb_objet_sur_lieu < max_nb_objet_sur_lieu; xm0 += pas)
    {
      ((point_sur_cercle *) mobile)->xm = xm0;
      mise_a_jour (pos, lieu_pos, FALSE);
      if (lieu->existe)
	{
	  pt_next = lieu->coordonnees ();
	  v = pt_next - pt_old;
	  d = sqrt (v * v);
	  if (d < dmin && pas < pasmax && checkd)
	    {
	      // point are too close, let's increase pas
	      xm0 -= pas;
	      pas *= 2;
	      statut = 0;
	    }
	  else if (d > dmax && pas > pasmin && checkd)
	    {
	      // point are too far
	      if (statut == 0)
		{
		  // there were previsiously too close, let's sample anyway
		  liste_point[nb_objet_sur_lieu++] = pt_next;
		  pt_old = pt_next;
		  statut = 2;
		}
	      xm0 -= pas;
	      pas /= 2;
	      statut = 1;
	    }
	  else if (d > dmax && pas <= pasmin)
	    {
	      // point too far and we can't adjust the sample rate to get close enought :
	      // let's forget this one
	      pt_old = pt_next;
	      statut = 2;
	    }
	  else
	    {
	      liste_point[nb_objet_sur_lieu++] = pt_next;
	      pt_old = pt_next;
	      statut = 2;
	      checkd = TRUE;
	    }
	}
    }
  ((point_sur_cercle *) mobile)->xm = abscisse;
  mise_a_jour (pos, lieu_pos, FALSE);
  if (nb_objet_sur_lieu == 0)
    existe = FALSE;
  else
    existe = TRUE;
}

// Member functions of class 'lieu_point_mobile_sur_segment'
// mobile on a segment
void lieu_point_mobile_sur_segment::
actualise ()
{
  int b, pos, lieu_pos;
  double abscisse, pas, xm0;

  existe = mobile->existe;
  if (!existe)
    return;
  abscisse = ((point_sur_segment *) mobile)->xm;
  pos = liste_figure.position ((figure_c *) mobile);
  lieu_pos = liste_figure.position ((figure_c *) lieu);
  pas = ((double) 1) / max_nb_objet_sur_lieu;

  // we want to build the locus, its childs must't rely on it
  existe = false;
  for (b = 0, xm0 = 0, nb_objet_sur_lieu = 0; b < max_nb_objet_sur_lieu; b++, xm0 += pas)
    {
      ((point_sur_segment *) mobile)->xm = xm0;
      mise_a_jour (pos, lieu_pos, FALSE);
      if (lieu->existe)
	liste_point[nb_objet_sur_lieu++] = lieu->coordonnees ();
    }
  ((point_sur_segment *) mobile)->xm = abscisse;
  mise_a_jour (pos, lieu_pos, FALSE);
  if (nb_objet_sur_lieu == 0)
    existe = FALSE;
  else
    existe = TRUE;
}

// Member function of class 'lieu_point_mobile_sur_demi_droite'
// mobile on half-line
void lieu_point_mobile_sur_demi_droite::
actualise ()
{
  int b, pos, lieu_pos;
  double abscisse, pas, xm0;
  existe = mobile->existe;
  if (!existe)
    return;
  abscisse = ((point_sur_demi_droite *) mobile)->xm;
  pos = liste_figure.position ((figure_c *) mobile);
  lieu_pos = liste_figure.position ((figure_c *) lieu);
  pas = UNIT_ECRtoMON (PAS_LIEU);
  // we want to build the locus, its childs must't rely on it
  existe = false;

  for (b = 0, xm0 = 0, nb_objet_sur_lieu = 0; b < max_nb_objet_sur_lieu; b++, xm0 += pas)
    {
      ((point_sur_demi_droite *) mobile)->xm = xm0;
      mise_a_jour (pos, lieu_pos, FALSE);
      if (lieu->existe)
	liste_point[nb_objet_sur_lieu++] = lieu->coordonnees ();
    }
  ((point_sur_demi_droite *) mobile)->xm = abscisse;
  mise_a_jour (pos, lieu_pos, FALSE);
  if (nb_objet_sur_lieu == 0)
    existe = FALSE;
  else
    existe = TRUE;
}
// Member function of class lieu_point_mobile_sur_lieu_point
// mobile on a locus
void lieu_point_mobile_sur_lieu_point::
actualise ()
{
  int b, pos, lieu_pos, nb, absci_orig;
  double abscisse, pas, xm0;
  existe = mobile->existe;
  if (!existe)
    return;
  nb_objet_sur_lieu = ((point_sur_lieu *) mobile)->parent->nb_objet_sur_lieu;
  if (nb_objet_sur_lieu > max_nb_objet_sur_lieu)
    nb_objet_sur_lieu = max_nb_objet_sur_lieu;
  absci_orig = ((point_sur_lieu *) mobile)->xm;
  pos = liste_figure.position ((figure_c *) mobile);
  lieu_pos = liste_figure.position ((figure_c *) lieu);
  // we want to build the locus, its childs must't rely on it
  existe = false;

  for (b = 0; b < nb_objet_sur_lieu; b++)
    {
      ((point_sur_lieu *) mobile)->xm = b;
      mise_a_jour (pos, lieu_pos, FALSE);
      if (lieu->existe)
	liste_point[b] = lieu->coordonnees ();
    }
  ((point_sur_lieu *) mobile)->xm = absci_orig;
  mise_a_jour (pos, lieu_pos, FALSE);
  if (nb_objet_sur_lieu == 0)
    existe = FALSE;
  else
    existe = TRUE;
}
