/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef segment_h
#define segment_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"

#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"


class segment1:public segment_c
{
  public:
  point_c * M2;
  segment1 (void):segment_c ()
  {
    classe = SE_2PT;
  }
  segment1 (liste_elem & lp):segment_c ()
  {
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    classe = SE_2PT;
    init_nom ();
  }
  segment1 (char a, char b, char c, char d, liste_elem & lp):segment_c (a, b, c, d)
  {
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
    classe = SE_2PT;
  }
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
  droite_s coordonnees (void);
  void init_nom (void);
};

// Transformed segment
// By reflexion
class reflexion_segment:public segment_c
{
  public:
  droite_c * axe;
  segment_c *segment;
    reflexion_segment (void):segment_c ()
  {
    classe = SE_RE;
  }
  reflexion_segment (liste_elem & lp):segment_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	segment = (segment_c *) f2;
	axe = (droite_c *) f1;
      }
    else
      {
	segment = (segment_c *) f1;
	axe = (droite_c *) f2;
      }
    actualise ();
    classe = SE_RE;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By symetry
class symetrie_segment:public segment_c
{
  public:
  segment_c * segment;
  point_c *symetrie;
    symetrie_segment ():segment_c ()
  {
    classe = SE_SY;
  }
  symetrie_segment (liste_elem & lp):segment_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	segment = (segment_c *) f2;
	symetrie = (point_c *) f1;
      }
    else
      {
	segment = (segment_c *) f1;
	symetrie = (point_c *) f2;
      }
    actualise ();
    classe = SE_SY;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_segment:public segment_c
{
  public:
  segment_c * segment;
  vecteur_c *v;
    translation_segment ():segment_c ()
  {
    classe = SE_TR;
  }
  translation_segment (liste_elem & lp):segment_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_VECTEUR)
      {
	segment = (segment_c *) f2;
	v = (vecteur_c *) f1;
      }
    else
      {
	segment = (segment_c *) f1;
	v = (vecteur_c *) f2;
      }
    actualise ();
    classe = SE_TR;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_segment:public segment_c
{
  public:
  segment_c * segment;
  point_c *c;
  valeur_c *v;
    rotation_segment ():segment_c ()
  {
    classe = SE_RO;
  }
  rotation_segment (liste_elem & lp):segment_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    segment = (segment_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    segment = (segment_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    segment = (segment_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    segment = (segment_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    segment = (segment_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    segment = (segment_c *) f1;
	  }
      }
    actualise ();
    classe = SE_RO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_segment:public segment_c
{
  public:
  segment_c * segment;
  point_c *c;
  valeur_c *v;
    homothetie_segment ():segment_c ()
  {
    classe = SE_HO;
  }
  homothetie_segment (liste_elem & lp):segment_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    segment = (segment_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    segment = (segment_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    segment = (segment_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    segment = (segment_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    segment = (segment_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    segment = (segment_c *) f1;
	  }
      }
    actualise ();
    classe = SE_HO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

#endif
