


/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "valeur.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *object_gc, *font_gc;
extern GdkColor tab_couleur[];

// Common methods for valeur objects
void valeur_c::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this value"));
}
void valeur_c::
dessine (GdkPixmap * ecran, char force)
{
  char out[800];
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  sprintf (out, "%.2f", valeur ());
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, ECRx (p.x), ECRy (p.y), out);
}
char valeur_c::
appartient (int xm, int ym)
{
  double xl, yh, mx, my;
  char out[800];
  mx = MONx (xm);
  my = MONy (ym);
  sprintf (out, "%.2f", valeur ());
  yh = (double) gdk_string_height (fontobject, out);
  xl = (double) gdk_string_width (fontobject, out);
  xl = p.x + xl / ECHELLE;
  yh = p.y + yh / ECHELLE;
  if (mx >= p.x && mx <= xl && my <= yh && my >= p.y)
    return TRUE;
  else
    return FALSE;
}
void valeur_c::
move (int xm, int ym)
{
  double x, y;
  x = xm;
  y = ym;
  p.x += x / ECHELLE;
  p.y -= y / ECHELLE;
}
double valeur_c::
valeur (void)
{
  actualise ();
  return val;
}
// Methods of valeur class derived from valeur_c
void longueur_segment::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("%1's length"));
  if (nom[0] == 0)
    strcpy (nom, parent->nom);
  strinsmsg (nom_type, parent->nom_type, "%1");
}
char longueur_segment::
dependance (figure_c * fig)
{
  return (parent == fig);
}
void longueur_segment::
actualise (void)
{
  existe = parent->existe;
  val = parent->longueur ();
}
liste_elem *longueur_segment::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) parent);
  return liste_parent;
}
void longueur_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) parent);
  fwrite (&pos, 1, sizeof (pos), f);
}
void longueur_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  parent = (segment_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void norme_vecteur::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("%1's magnitude"));
  strinsmsg (nom_type, parent->nom_type, "%1");
  if (nom[0] == 0)
    strcpy (nom, parent->nom);
}
//
void distance_pt_pt::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the distance between %1 and %2"));
  if ((strlen (parent1->nom) + strlen (parent2->nom) + strlen (nom_type) + 1) <= LONGUEUR_NOM_TYPE)
    {
      strinsmsg (nom_type, parent1->nom, "%1");		// arg1=pt1

      strinsmsg (nom_type, parent2->nom, "%2");		// arg1=pt2

    }
  if (nom[0] == 0)
    {
      if ((strlen (parent1->nom) + strlen (parent2->nom) + 1) <= LONGUEUR_NOM)
	{
	  strcpy (nom, parent1->nom);
	  strcat (nom, parent2->nom);
	}
      else
	{
	  nom[0] = 108;		// l

	  nom[1] = 0;
	}
    }
}
char distance_pt_pt::
dependance (figure_c * fig)
{
  return (parent1 == fig || parent2 == fig);
}
void distance_pt_pt::
actualise (void)
{
  point_s p1;
  existe = parent1->existe && parent2->existe;
  if (!existe)
    return;
  p1 = parent2->coordonnees () - parent1->coordonnees ();
  val = sqrt (p1 * p1);
}
liste_elem *distance_pt_pt::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) parent1);
  liste_parent->ajoute ((void *) parent2);
  return liste_parent;
}
void distance_pt_pt::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) parent1);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) parent2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void distance_pt_pt::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  parent1 = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  parent2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void distance_point_cercle::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the distance between %1 and %2"));
  if ((strlen (pt->nom) + strlen (c->nom) + strlen (nom_type) + 1) <= LONGUEUR_NOM_TYPE)
    {
      strinsmsg (nom_type, pt->nom, "%2");
      strinsmsg (nom_type, c->nom, "%1");
    }
  if (nom[0] == 0)
    {
      if ((strlen (c->nom) + strlen (pt->nom) + 1) <= LONGUEUR_NOM)
	{
	  strcpy (nom, c->nom);
	  strcat (nom, pt->nom);
	}
      else
	{
	  nom[0] = 108;		// l

	  nom[1] = 0;
	}
    }
}
char distance_point_cercle::
dependance (figure_c * fig)
{
  return (pt == fig || c == fig);
}
void distance_point_cercle::
actualise (void)
{
  point_s p1, p2, m1, m2, *inter;
  double r;
  param_droite param;
  existe = pt->existe && c->existe;
  if (!existe)
    return;
  p1 = c->centre ();
  r = c->rayon ();
  p2 = pt->coordonnees ();
  if (p1.x == p2.x && p1.y == p2.y)
    {
      val = r;
      return;
    }
  param.a = p1.y - p2.y;
  param.b = p2.x - p1.x;
  param.c = -param.a * p1.x - param.b * p1.y;
  inter = inter_cercle_droite_cart (param, &p1, r, 1);
  if (inter == NULL)
    {
      //      alert ("Erreur dans", "distance_point_cercle::actualise", "inter=NULL,1", "OK", NULL, 0, 0);
      return;
    }
  m1 = *inter;
  delete inter;
  inter = inter_cercle_droite_cart (param, &p1, r, -1);
  if (inter == NULL)
    {
      //    alert ("Erreur dans", "distance_point_cercle::actualise", "inter=NULL,-1", "OK", NULL, 0, 0);
      return;
    }
  m2 = *inter;
  delete inter;
  r = sqrt (pow (p2.x - m1.x, 2) + pow (p2.y - m1.y, 2));
  val = sqrt (pow (p2.x - m2.x, 2) + pow (p2.y - m2.y, 2));
  if (val > r)
    val = r;
}
liste_elem *distance_point_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) pt);
  liste_parent->ajoute ((void *) c);
  return liste_parent;
}
void distance_point_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) pt);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void distance_point_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  pt = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void distance_point_droite::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the distance between %1 and %2"));
  if ((strlen (d->nom) + strlen (pt->nom) + strlen (nom_type) + 1) <= LONGUEUR_NOM_TYPE)
    {
      strinsmsg (nom_type, d->nom, "%1");
      strinsmsg (nom_type, pt->nom, "%2");
    }
  if (nom[0] == 0)
    {
      if ((strlen (d->nom) + strlen (pt->nom) + 1) <= LONGUEUR_NOM)
	{
	  strcpy (nom, d->nom);
	  strcat (nom, pt->nom);
	}
      else
	{
	  nom[0] = 108;		// l

	  nom[1] = 0;
	}
    }
}

char distance_point_droite::
dependance (figure_c * fig)
{
  return (pt == fig || d == fig);
}
void distance_point_droite::
actualise (void)
{
  droite_s co;
  vecteur_s n, a;
  point_s p;
  existe = pt->existe && d->existe;
  if (!existe)
    return;
  p = pt->coordonnees ();
  co = d->coordonnees ();
  n = d->normal ();
  a = p - co.a;
  val = fabs (a * n);
}
liste_elem *distance_point_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) pt);
  liste_parent->ajoute ((void *) d);
  return liste_parent;
}
void distance_point_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) pt);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) d);
  fwrite (&pos, 1, sizeof (pos), f);
}
void distance_point_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  pt = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  d = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void perimetre_cercle::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("%1's perimeter"));
  strinsmsg (nom_type, c->nom, "%1");
  if (nom[0] == 0)
    {
      nom[0] = 'p';
      nom[1] = 0;
    }
}
char perimetre_cercle::
dependance (figure_c * fig)
{
  return (c == fig);
}
void perimetre_cercle::
actualise (void)
{
  existe = c->existe;
  val = c->rayon () * 2 * PI;
}
liste_elem *perimetre_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) c);
  return liste_parent;
}
void perimetre_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void perimetre_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  c = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
//
// Fonctions membres des classes d'equation
// fonctions membres de la classe valeur libre
void valeur_libre::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
}
void valeur_libre::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  init_nom ();
}
// Member function of the pente_droite class
void pente_droite::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the slope of %1"));
  if (nom[0] == 0)
    strcpy (nom, d->nom);
  strinsmsg (nom_type, nom, "%1");
}
char pente_droite::
dependance (figure_c * fig)
{
  return (d == fig);
}
void pente_droite::
actualise (void)
{
  existe = d->existe;
  if (!existe)
    return;
  val = d->pente ();;
}
liste_elem *pente_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) d);
  return liste_parent;
}
void pente_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) d);
  fwrite (&pos, 1, sizeof (pos), f);
}
void pente_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  d = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
