
/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "vecteur.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;

// Common methods for vector objects
void vecteur_c::
init_nom (void)
{
  char tmp[8];
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this vector %1"));
  strinsmsg (nom_type, nom, "%1");
}
void vecteur_c::
dessine (GdkPixmap * ecran, char force)
{
  droite_s co;
  Complex rot, zb, zm, zn, zn2;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || !existe)
    return;
  co = coordonnees ();
  zm = Complex ((co.a.x - co.b.x) / 6 + co.b.x, (co.a.y - co.b.y) / 6 + co.b.y);
  zb = Complex (co.b.x, co.b.y);
  rot = Complex (cos (PI / 7), sin (PI / 7));
  zn = (zm - zb) * rot + zb;
  rot = conj (rot);
  zn2 = (zm - zb) * rot + zb;
  switch (epaisseur)
    {
    case 0:
      dotted_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn)), ECRy (imag (zn)), couleur, 1);
      dotted_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn2)), ECRy (imag (zn2)), couleur, 1);
      dotted_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, 1);
      break;
    case 1:
      dotted_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn)), ECRy (imag (zn)), couleur, 2);
      dotted_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn2)), ECRy (imag (zn2)), couleur, 2);
      dotted_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, 2);
      break;
    case 2:
      line_good_clip (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn)), ECRy (imag (zn)), couleur);
      line_good_clip (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn2)), ECRy (imag (zn2)), couleur);
      line_good_clip (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur);
      break;
    case 3:
      thick_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn)), ECRy (imag (zn)), couleur, EPAIS);
      thick_line (ecran, ECRx (co.b.x), ECRy (co.b.y), ECRx (real (zn2)), ECRy (imag (zn2)), couleur, EPAIS);
      thick_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, EPAIS);
    }
}
char vecteur_c::
appartient (int xm, int ym)
{
  droite_s co;
  vecteur_s n, ab, mb;
  double x, y;
  n = normal ();
  if (n.x == 0 && n.y == 0)
    return M1->appartient (xm, ym);
  co = coordonnees ();
  x = MONx (xm);
  y = MONy (ym);
  mb.x = co.b.x - x;
  mb.y = co.b.y - y;
  x -= co.a.x;
  y -= co.a.y;
  ab.x = co.b.x - co.a.x;
  ab.y = co.b.y - co.a.y;
  if (ABS (x * n.x + y * n.y) >= RI || (x * ab.x + y * ab.y) < 0 || (mb.x * ab.x + mb.y * ab.y) < 0)
    return FALSE;
  return TRUE;
}
// Vector defined by two points
char vecteur1::
dependance (figure_c * fig)
{
  return (M1 == fig || M2 == fig);
}
droite_s vecteur1::
coordonnees (void)
{
  p.a = M1->p;
  p.b = M2->p;
  return p;
}
void vecteur1::
actualise (void)
{
  if (!M1->existe || !M2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p.a = M1->coordonnees ();
  p.b = M2->coordonnees ();
  if (ECRx (p.a.x) == ECRx (p.b.x) && ECRy (p.a.y) == ECRy (p.b.y))
    existe = FALSE;
}
liste_elem *vecteur1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) M2);
  return liste_parent;
}
void vecteur1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  M2->move (xm, ym);
  actualise ();
}
void vecteur1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) M2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void vecteur1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  M2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
void vecteur1::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this vector %1"));
  if ((strlen (M1->nom) + strlen (M2->nom) + 3) <= LONGUEUR_NOM && strlen (M1->nom) != 0 && strlen (M2->nom) != 0)
    sprintf (nom, "%s%s", M1->nom, M2->nom);
  strinsmsg (nom_type, nom, "%1");
}
vecteur_s vecteur1::
vecteur ()
{
  vecteur_s v;
  v.x = (M2->p).x - (M1->p).x;
  v.y = (M2->p).y - (M1->p).y;
  return v;
}
// Transformed vector
// By reflexion
char reflexion_vecteur::
dependance (figure_c * fig)
{
  return (axe == fig || vect == fig);
}
droite_s reflexion_vecteur::
coordonnees (void)
{
  droite_s co, co1;
  co = vect->coordonnees ();
  co1.a = reflexion_p (axe, co.a);
  co1.b = reflexion_p (axe, co.b);
  return co1;
}
void reflexion_vecteur::
actualise (void)
{
  if (!vect->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s reflexion_vecteur::
normal (void)
{
  return reflexion_v (axe, vect->normal ());
}
vecteur_s reflexion_vecteur::
directeur (void)
{
  return reflexion_v (axe, vect->directeur ());
}
vecteur_s reflexion_vecteur::
vecteur (void)
{
  return reflexion_v (axe, vect->vecteur ());
}
void reflexion_vecteur::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) vect);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_vecteur::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  vect = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_vecteur::
dependance (figure_c * fig)
{
  return (v == fig || v_img == fig);
}
droite_s translation_vecteur::
coordonnees (void)
{
  droite_s co, co1;
  vecteur_s t;
  t = v->vecteur ();
  co = v_img->coordonnees ();
  co1.a = co.a + t;
  co1.b = co.b + t;
  return co1;
}
void translation_vecteur::
actualise (void)
{
  if (!v->existe || !v_img->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s translation_vecteur::
normal (void)
{
  return v_img->normal ();
}
vecteur_s translation_vecteur::
directeur (void)
{
  return v_img->directeur ();
}
vecteur_s translation_vecteur::
vecteur (void)
{
  return v_img->vecteur ();
}
void translation_vecteur::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) v_img);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_vecteur::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  v_img = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_vecteur::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || v_img == fig);
}
droite_s rotation_vecteur::
coordonnees (void)
{
  droite_s co, co1;
  co = v_img->coordonnees ();
  co1.a = rotation_p (c, v, co.a);
  co1.b = rotation_p (c, v, co.b);
  return co1;
}
void rotation_vecteur::
actualise (void)
{
  if (!v->existe || !v_img->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s rotation_vecteur::
normal (void)
{
  return rotation_v (v, v_img->normal ());
}
vecteur_s rotation_vecteur::
directeur (void)
{
  return rotation_v (v, v_img->directeur ());
}
vecteur_s rotation_vecteur::
vecteur (void)
{
  return rotation_v (v, v_img->vecteur ());
}
void rotation_vecteur::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) v_img);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_vecteur::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  v_img = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_vecteur::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || v_img == fig);
}
droite_s homothetie_vecteur::
coordonnees (void)
{
  droite_s co, co1;
  co = v_img->coordonnees ();
  co1.a = c->p + (co.a - c->p) * v->val;
  co1.b = c->p + (co.b - c->p) * v->val;
  return co1;
}
void homothetie_vecteur::
actualise (void)
{
  if (!v->existe || !v_img->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s homothetie_vecteur::
normal (void)
{
  return (v_img->normal ());
}
vecteur_s homothetie_vecteur::
directeur (void)
{
  return (v_img->directeur ());
}
vecteur_s homothetie_vecteur::
vecteur (void)
{
  return (c->p + (v_img->vecteur () - c->p) * v->val);
}
void homothetie_vecteur::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) v_img);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_vecteur::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  v_img = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
